' 
'                        RTEngine include file v1.0
'                        by Enhanced Creations 1999
' 

DEFINT A-Z
'$DYNAMIC

' 
' Function prototypes
' 

' Inits RTE
DECLARE FUNCTION RTEinit% (BYVAL NumTextures%, BYVAL XMSneeded%)
' Shuts down RTE
DECLARE SUB RTEclose ()
' Calculates and draws a frame, given player position, angle, doors and objects
DECLARE SUB RTEdoFrame (BYVAL BufferSeg%, BYVAL x%, BYVAL y%, BYVAL Angle%, BYVAL DoorSeg%, BYVAL ObjSeg%)
' Waits for vertical retrace and copies contents of buffer to the screen
DECLARE SUB RTEtoScreen (BYVAL BufferSeg%)
' Scales and copies contents of buffer to the a box on the screen
DECLARE SUB RTEtoBox (BYVAL BufferSeg%, BYVAL x%, BYVAL y%)
' Stores sprite into XMS, at specified position
DECLARE SUB RTEstoreSprite (BYVAL SpriteSeg%, BYVAL IdNumber%)
' Stores level texture into base memory, at specified position
DECLARE SUB RTEstoreTexture (BYVAL TextureSeg%, BYVAL IdNumber%)
' Loads a level map in memory and initializes doors
DECLARE SUB RTEloadMap (BYVAL MapSeg%, BYVAL DoorSeg%, BYVAL ObjectSeg%)
' Returns true if specified key is currently pressed
DECLARE FUNCTION RTEkey% (BYVAL ScanCode%)
' Sets various engine option flags
DECLARE SUB RTEsetOptions (BYVAL OptionsSeg%, BYVAL OptionsOff%)
' Builds the light color map, with colors fading to FarColor% with distance
DECLARE SUB RTEbuildLightMap (BYVAL PalSeg%, BYVAL FarColor%)
' Finds into palette the color that best fits with specified hues
DECLARE FUNCTION RTEfindCol% (BYVAL PalSeg%, BYVAL Red%, BYVAL Green%, BYVAL Blue%)
' Returns id of the door in front of player, 0 if no doors
DECLARE FUNCTION RTEfindDoor% (BYVAL x%, BYVAL y%, BYVAL Angle%)
' Opens a specified door, and sets the "still" time delay before closing
DECLARE SUB RTEopenDoor (BYVAL DoorId%, BYVAL Delay%, BYVAL DoorSeg%)
' Updates doors on current level
DECLARE SUB RTEupdateDoors (BYVAL x%, BYVAL y%, BYVAL DoorSeg%, BYVAL ObjSeg%)
' Returns specified map block informations
DECLARE SUB RTEgetMap (BYVAL x%, BYVAL y%, Wall%, Floor%, Ceiling%)
' Sets specified map block informations
DECLARE SUB RTEsetMap (BYVAL x%, BYVAL y%, BYVAL Wall%, BYVAL Floor%, BYVAL Ceiling%)
' Moves object from a point to another one, checking for collisions
DECLARE SUB RTEwalk (x%, y%, BYVAL DestX%, BYVAL DestY%, BYVAL DoorSeg%, BYVAL ObjSeg%)
' Finds the angle between two given points (in the range 0-1919)
DECLARE FUNCTION RTEangle% (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
' Draws player level map
DECLARE SUB RTEdrawMap (BYVAL VideoSeg%, BYVAL x%, BYVAL y%)
' Draws a console box
DECLARE SUB RTEconsole (BYVAL VideoSeg%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
' Font drawing
DECLARE SUB RTEprint (BYVAL VideoSeg%, BYVAL x%, BYVAL y%, BYVAL StrSeg%, BYVAL StrOff%, BYVAL Col%)
' Font setting
DECLARE SUB RTEsetFont (BYVAL FontSeg%, BYVAL FontOff%)
' Sets new sky picture
DECLARE SUB RTEsetSky (BYVAL SkySeg%, BYVAL SkyOff%)
' Initializes the mouse
DECLARE FUNCTION RTEmouseInit% ()
' Returns mouse x position
DECLARE FUNCTION RTEmouseX% ()
' Returns mouse y position
DECLARE FUNCTION RTEmouseY% ()
' Returns true if left mouse button is pressed
DECLARE FUNCTION RTEmouseLB% ()
' Returns true if right mouse button is pressed
DECLARE FUNCTION RTEmouseRB% ()
' Shows mouse cursor
DECLARE SUB RTEmouseShow ()
' Hides mouse cursor
DECLARE SUB RTEmouseHide ()
' Sets new mouse position
DECLARE SUB RTEsetMousePos (BYVAL NewX%, BYVAL NewY%)
' Sets new mouse shape and hotspot position
DECLARE SUB RTEsetMouseShape (BYVAL ShapeSeg%, BYVAL ShapeOff%, BYVAL HotX%, BYVAL HotY%)
' Draws a sprite from XMS
DECLARE SUB RTEput (BYVAL VideoSeg%, BYVAL SpriteNum%, BYVAL x%, BYVAL y%, BYVAL Scale%)
' Sets view height
DECLARE SUB RTEsetViewHeight (BYVAL ViewHeight%)
' Sets plane height
DECLARE SUB RTEsetPlayerHeight (BYVAL PlayerHeight%)

' 
' Predefined data types
' 

' Customizable engine settings
TYPE RTEsettings
  Detail AS INTEGER           ' Graphical detail flags
  FloorColor AS INTEGER       ' Floor filling color when textures are off
  CeilingColor AS INTEGER     ' Ceiling filling color when textures are off
  MapBackColor AS INTEGER     ' Player's map background color
  MapWallColor AS INTEGER     ' Player's map walls color
  MapDoorColor AS INTEGER     ' Player's map doors color
  MapVisitedColor AS INTEGER  ' Player's map visited path color
  Sight AS INTEGER            ' Sight level (when light-shading is on)
  ClipX1 AS INTEGER           ' Upper-left corner x coord. of clipping box
  ClipY1 AS INTEGER           ' Upper-left corner y coord. of clipping box
  ClipX2 AS INTEGER           ' Lower-right corner x coord. of clipping box
  ClipY2 AS INTEGER           ' Lower-right corner y coord. of clipping box
END TYPE

' Doors structure (must remain 8 bytes!)
TYPE RTEdoor
  offset AS STRING * 1        ' Ranges 0-63; 0=door opened, 63=door closed
  status AS STRING * 1        ' 0=closed, 1=opening, 2=still, 3=closing
  Delay AS INTEGER            ' Cycles the door will remain opened, -1=forever
  xmap AS STRING * 1          ' x cell position on map (ranges 0-63)
  ymap AS STRING * 1          ' y cell position on map (ranges 0-63)
  Texture AS STRING * 1       ' Texture number
  available AS STRING * 1     ' 1 padding byte
END TYPE

' Objects structure (must remain 16 bytes!)
TYPE RTEobject
  Texture AS INTEGER          ' Texture number
  x AS INTEGER                ' x absolute position on map (ranges 0-4095)
  y AS INTEGER                ' y absolute position on map (ranges 0-4095)
  ang AS INTEGER              ' Absolute angle of object (ranges 0-1919)
  flags AS INTEGER            ' Various object option bits
  available AS STRING * 6     ' THE 6 BYTES HERE CAN BE USED AS YOU WISH
END TYPE

' 
' Engine constants
' 

CONST KEYESC = 1, KEYENTER = 28, KEYSPACE = 57
CONST KEYUP = 72, KEYDOWN = 80, KEYLEFT = 75, KEYRIGHT = 77
CONST Floor = 1, Ceiling = 2, VSYNC = 4, SHADING = 8, SKY = 16

