' This program precalculates all the trigonometry tables.
'angle! = ATN(((triginit% - (scr.xsize \ 2)) / scr.distance)) + ((2 * pi! / ego.turns) * scrloop%) - (pi! / 2)
CONST pi! = 3.141593
CONST trigmin! = 64 / 32767

scr.fov = 60    ' 60 degree field of vision.
scr.xsize = 320
scr.ysize = 200
scr.distance = (scr.xsize \ 2) / (TAN(scr.fov / 2 * (pi! / 180)))

DIM sintable&(1919)  ' Precalculated sin-table.
DIM costable&(1919)  ' Precalculated cos-table.
DIM xtantable&(1919) ' Precalculated tan-table for x wall intersections.
DIM ytantable&(1919) ' Precalculated tan-table for y wall intersections.
DIM fishtable&(319)  ' Precalculated cos-table 2 (fishbowl effect).
'DIM invcostable&(319)
DIM floordist&(99)


CLS

FOR triginit% = 0 TO 320 * (360 / scr.fov) - 1
   angle! = (-90 - scr.fov \ 2 + (triginit% * 360& / 1920)) * (pi! / 180)

   sinvalue! = SIN(angle!)
   cosvalue! = COS(angle!)
   xtanvalue! = ABS(TAN(angle!))
   ytanvalue! = ABS(TAN(angle!))

   ' Roundoff to avoid overflow errors:
   IF sinvalue! >= 0 AND sinvalue! < 64 / 4096 THEN sinvalue! = 64 / 4096
   IF sinvalue! < 0 AND sinvalue! > -64 / 4096 THEN sinvalue! = -64 / 4096
   IF cosvalue! >= 0 AND cosvalue! < 64 / 4096 THEN cosvalue! = 64 / 4096
   IF cosvalue! < 0 AND cosvalue! > -64 / 4096 THEN cosvalue! = -64 / 4096

   'IF xtanvalue! > 8192 / 64 THEN xtanvalue! = 8192 / 64
   'IF ytanvalue! >= 0 AND ytanvalue! < 64 / 8192 THEN ytanvalue! = 0
   IF xtanvalue! > 4096 / 64 THEN xtanvalue! = 8192 / 64
   IF ytanvalue! >= 0 AND ytanvalue! < 64 / 8192 THEN ytanvalue! = 64 / 8192

   IF sinvalue! < 0 AND xtanvalue! <= 128 THEN xtanvalue! = -xtanvalue!
   IF cosvalue! < 0 THEN ytanvalue! = -ytanvalue!

   'IF triginit% = 158 THEN
   'IF triginit% = 960 + 162 THEN
   ' PRINT 1 / cosvalue!
   ' END
   'END IF
   cosvalue! = 1 / cosvalue!
   sinvalue! = 1 / sinvalue!
   ytanvalue! = 1 / ytanvalue!

   IF ABS(cosvalue!) >= 64 THEN cosvalue! = cosvalue! * 8
   IF ABS(sinvalue!) >= 64 THEN sinvalue! = sinvalue! * 8

   sintable&(triginit%) = sinvalue! * 65536
   costable&(triginit%) = cosvalue! * 65536
   xtantable&(triginit%) = xtanvalue! * 65536
   ytantable&(triginit%) = ytanvalue! * 65536
'   PRINT angle!
   'PRINT ytantable&(triginit%)
'   DO: LOOP WHILE INKEY$ = ""
NEXT triginit%

' for i := -ANG_30 to ANG_30 do
'  begin
'   rad_angle := (3.272e-4) + i*2*pi/ANG_360;
'   InvCos_table[i+ANG_30] := Round(1024/cos(rad_angle));
'  end;
'FOR i% = -160 TO 159
'  ang# = .0003272# + i% * 6.28 / 1920
'  fishtable&(i% + 160) = 65536 / COS(ang#)
'NEXT i%


FOR triginit% = 0 TO scr.xsize - 1
   fishtable&(triginit%) = 65536 / COS(ATN((triginit% - (scr.xsize \ 2)) / scr.distance))
   'fishtable&(triginit%) = fishtable&(triginit%) / 2
   IF fishtable&(triginit%) = 0 THEN BEEP

NEXT triginit%

'END

OPEN "RESOURCE.RTE" FOR BINARY AS #1

FOR savetrig% = 0 TO 1919
   PUT #1, , sintable&(savetrig%)
   PUT #1, , costable&(savetrig%)
   PUT #1, , xtantable&(savetrig%)
   PUT #1, , ytantable&(savetrig%)
NEXT savetrig%
FOR savetrig% = 0 TO 319
   PUT #1, , fishtable&(savetrig%)
NEXT savetrig%

CLOSE #1


'OPEN "TRIG.DAT" FOR BINARY AS #1
'
'FOR savetrig% = 0 TO 1919
'   PUT #1, , sintable&(savetrig%)
'NEXT
'FOR savetrig% = 0 TO 1919
'   PUT #1, , costable&(savetrig%)
'NEXT
'FOR savetrig% = 0 TO 1919
'   PUT #1, , xtantable&(savetrig%)
'NEXT
'FOR savetrig% = 0 TO 1919
'   PUT #1, , ytantable&(savetrig%)
'NEXT savetrig%
'FOR savetrig% = 0 TO 319
'   PUT #1, , fishtable&(savetrig%)
'NEXT savetrig%
'
'CLOSE #1

