COMMENT \ 

                               RT Engine v2.0

                         by Enhanced Creations 1999


    The RT engine (RTE for short) welcomes you to the world of raycasting!
If you're wondering about the version number starting at 2.0, well, there's a
 reason for that: this whole asm code has been completely rewritten sometimes
 ago, because the old one was all messed up and unoptimized. You are free to
 use RTE for your own games; we've created it as a SDK fast and easy to use.
  Read carefully the RTENGINE.DOC file, which explains the features, details,
        tips and limits of the engine, also with some code examples.

  - Enhanced Creations

        Angelo Mottola                         Petter Holmberg
        angelillo@bigfoot.com                  petter.holmberg@usa.net
        #24084401                              #31097432

\ 

; Trig tables order once loaded in memory
; (x is current angle, s is the current slice number)
;
; sine      0+(x*16)
; cosine    4+(x*16)
; xtan      8+(x*16)
; ytan      12+(x*16)
; fishfix   30720+(s*4)
;
; 90 degrees  = 480
; 270 degrees = 1440


; Doors structure
;
; 00    offset (byte)         specifies how much the door is opened
; 01    status (byte)         0=closed / 1=opening / 2=still / 3=closing
; 02    delay (word)          cycles to be still (-1=never close)
; 04    xmap (byte)           x cell map position
; 05    ymap (byte)           y cell map position
; 06    texture (byte)        texture number
; 07    reserved (byte)


; Objects structure
;
; 00    texture (word)        texture number (-1=object is off)
; 02    xpos (word)           absolute x position
; 04    ypos (word)           absolute y position
; 06    angle (word)          object angle
; 08    flags (word)          bit 0:1=solid,0=passable
; 10    reserved (6 bytes)


.MODEL Medium,Basic

.386

.STACK 250h


XMSdata STRUC
  Len         DD  ?           ; Bytes to move (must be even!)
  SourceHdl   DW  ?           ; Source handle (0=base mem)
  SourceOff   DD  ?           ; Source offset
  DestHdl     DW  ?           ; Destination handle (0=base mem)
  DestOff     DD  ?           ; Destination offset
XMSdata ENDS


InternalObject STRUC
  Texture     DW  ?           ; Object texture
  CenterX     DW  ?           ; Object horizontal center in screen coordinates
  Distance    DW  ?           ; Distance from view point
InternalObject ENDS

; Settings "Detail" flags:
; bit 0: Floor texturing (1=on, 0=off)
; bit 1: Ceiling texturing (1=on, 0=off)
; bit 2: Vertical sync (1=on, 0=off)
; bit 3: Light shading (1=on, 0=off)
; bit 4: Sky (1=on, 0=off)

SettingsData STRUC
  Detail      DB  000011111b  ; Engine detail flags (see above)
  FloorCol    DB  0           ; Floor filling color when texturing is off
  CeilingCol  DB  0           ; Ceiling filling color when texturing is off
  MapBackCol  DB  124         ; Player's map background color (0=transparent)
  MapWallCol  DB  10          ; Player's map walls color
  MapDoorCol  DB  14          ; Player's map doors color
  MapVisCol   DB  2           ; Player's map visited areas color
  Sight       DW  1024        ; Sight range
  x1          DW  0           ; \
  y1          DW  0           ;  |-- Clipping box
  x2          DW  319         ;  |
  y2          DW  199         ; /
SettingsData ENDS


DISTFIX       EQU   16

.DATA

; Array declarations
SpriteBuf     DB  4096 dup(?) ; Texture/sprite buffer
WallDist      DW  320 dup(?)  ; Calculated wall distances
WallHeight    DB  320 dup(?)  ; Calculated wall heights
ViewMap       DB  512 dup(0)  ; Visibility map (bitwise)
PlayerMap     DB  1024 dup(0) ; Player's level map (bitwise)
LevelMap      DB  8192 dup(0) ; Level map (0-4095=walls, 4096-8191=floor/ceil)
LightMap      DB  4096 dup(?) ; Light map colors lookup table (16 shades)
FloorDist     DW  200 dup(0)  ; Floor pixel distances lookup table
CeilingDist   DW  200 dup(0)  ; Ceiling pixel distances lookup table
CurFont       DB  2305 dup(?) ; Font currently in use
Object        InternalObject 256 dup({})    ; For internal objects handling
Key           DB  128 dup(0)  ; Keys status for keyboard handler


; Global variables
OldInt9       DD  ?           ; Old keyboard ISR address
XMSfunc       DD  ?           ; XMS far control function
XMSmove       XMSdata <>      ; XMS data moving structure
XMShdl        DW  ?           ; XMS handle in use
TextureSeg    DW  ?           ; Textures segment
TrigSeg       DW  ?           ; Trig lookup tables segment
TrigFile      DB  'RESOURCE.RTE',0  ; Resource file name holding trig data
EyeHeight     DW  32          ; View height, ranging 0-63
PlaneHeight   DW  100         ; Projection plane height
OldTile       DB  0           ; Last texture used, currently into the buffer
SightStep     DB  6           ; Internal light-shading variable
HorizonCol    DB  0           ; Color of horizon (when light-shading is on)
MouseX        DW  ?           ; Mouse x position
MouseY        DW  ?           ; Mouse y position
MouseBut      DB  ?           ; Mouse buttons status
Settings      SettingsData <> ; Customizable engine settings


; Public declarations
PUBLIC RTEinit,RTEclose,RTEdoFrame,RTEtoScreen,RTEloadMap,RTEstoreSprite
PUBLIC RTEkey,RTEsetOptions,RTEbuildLightMap,RTEfindCol,RTEfindDoor
PUBLIC RTEopenDoor,RTEupdateDoors,RTEgetMap,RTEsetMap,RTEwalk,RTEangle
PUBLIC RTEdrawMap,RTEconsole,RTEprint,RTEsetFont,RTEsetSky,RTEmouseInit
PUBLIC RTEmouseX,RTEmouseY,RTEmouseLB,RTEmouseRB,RTEmouseShow,RTEmouseHide
PUBLIC RTEsetMouseShape,RTEput,RTEstoreTexture
PUBLIC RTEsetViewHeight,RTEsetPlayerHeight

.CODE


COMMENT \ 
  MapLine Procedure
  - Internal procedure for player's visited areas map handling
\ 
MapLine PROC USES DS,lx1:WORD,ly1:WORD,lx2:WORD,ly2:WORD

LOCAL deltax:WORD,deltay:WORD,d:WORD,dinc1:WORD,dinc2:WORD
LOCAL xinc1:WORD,xinc2:WORD,yinc1:WORD,yinc2:WORD,x:WORD,y:WORD

  PUSHA
  MOV AX,lx1
  SUB AX,lx2
  CMP AX,0
  JG @F
  NEG AX
@@:
  MOV deltax,AX
  MOV BX,ly1
  SUB BX,ly2
  CMP BX,0
  JG @F
  NEG BX
@@:
  MOV deltay,BX
  .IF deltax >= BX
    MOV SI,deltax
    INC SI
    SHL BX,1
    SUB BX,deltax
    MOV d,BX
    MOV DX,deltay
    SHL DX,1
    MOV dinc1,DX
    SHR DX,1
    SUB DX,deltax
    SHL DX,1
    MOV dinc2,DX
    MOV xinc1,1
    MOV xinc2,1
    MOV yinc1,0
    MOV yinc2,1
  .ELSE
    MOV SI,BX
    INC SI
    MOV AX,deltax
    SHL AX,1
    SUB AX,BX
    MOV d,AX
    MOV DX,deltax
    SHL DX,1
    MOV dinc1,DX
    SHR DX,1
    SUB DX,BX
    SHL DX,1
    MOV dinc2,DX
    MOV xinc1,0
    MOV xinc2,1
    MOV yinc1,1
    MOV yinc2,1
  .ENDIF
  MOV AX,lx1
  CMP AX,lx2
  JLE @F
  NEG xinc1
  NEG xinc2
@@:
  MOV BX,ly1
  CMP BX,ly2
  JLE @F
  NEG yinc1
  NEG yinc2
@@:
  MOV x,AX
  MOV y,BX
LineLoop:
  MOV DI,y
  SHL DI,6
  ADD DI,x
  MOV BX,DI
  MOV CX,BX
  SHR BX,2
  MOV DL,3
  AND CX,03h
  ADD CX,CX
  SHL DL,CL
  TEST PlayerMap[BX],DL
  JNZ @F
  OR PlayerMap[BX],DL
@@:
  CMP d,0
  JGE @F
  MOV BX,dinc1
  ADD d,BX
  MOV AX,xinc1
  ADD x,AX
  MOV CX,yinc1
  ADD y,CX
  DEC SI
  JNZ LineLoop
  POPA
  RET
@@:
  MOV BX,dinc2
  ADD d,BX
  MOV AX,xinc2
  ADD x,AX
  MOV CX,yinc2
  ADD y,CX
  DEC SI
  JNZ LineLoop
  POPA
  RET
MapLine ENDP


COMMENT \ 
  RTEinit Procedure
  - Initializes XMS and level textures memory
  - Loads the trig tables into base memory
  - Installs a custom keyboard ISR
\ 
RTEinit PROC USES DS,NumTextures:WORD,XMSneeded:WORD
  MOV AX,04300h
  INT 02Fh                ; Checks if an XMM is available
  .IF AL != 080h
    MOV AX,1              ; Error 1: XMM not found
    RET
  .ENDIF
  MOV AX,04310h
  INT 02Fh                ; Gets XMM far control function address
  MOV WORD PTR [XMSfunc],BX
  MOV WORD PTR [XMSfunc+2],ES
  XOR AH,AH
  CALL [XMSfunc]          ; Gets XMM version number
  .IF AH < 3
    MOV AX,2              ; Error 2: Old XMM version not supported
    RET
  .ENDIF
  MOV AH,8
  CALL [XMSfunc]          ; Query free XMS memory
  .IF AX < XMSneeded
    MOV AX,3              ; Error 3: Not enough free XMS memory
    RET
  .ENDIF
  MOV AH,9
  MOV DX,XMSneeded
  CALL [XMSfunc]          ; Allocates memory
  .IF AX != 1
    MOV AX,4              ; Error 4: Error allocating XMS memory
    RET
  .ENDIF
  MOV XMShdl,DX           ; Saves XMS handle
  MOV AH,048h
  MOV BX,2000
  INT 021h                ; Allocates base memory for trig tables
  JNC @F
    MOV AH,0Ah
    MOV DX,XMShdl
    CALL [XMSfunc]        ; Releases XMS memory
    MOV AX,5              ; Error 5: Error allocating base memory
    RET
@@:
  MOV TrigSeg,AX          ; Saves trig segment
  MOV CX,@DATA
  MOV DS,CX
  MOV DX,OFFSET TrigFile
  MOV AX,03D00h
  INT 021h                ; Opens resource file
  JNC @F
    MOV AH,0Ah
    MOV DX,XMShdl
    CALL [XMSfunc]        ; Releases XMS memory
    MOV AX,6              ; Error 6: Error loading resource file
    RET
@@:
  PUSH DS
  MOV BX,AX
  MOV DX,TrigSeg
  MOV DS,DX
  MOV CX,32000
  MOV AH,03Fh
  XOR DX,DX
  INT 021h                ; Loads trig data
  POP DS
  MOV AH,03Eh
  INT 021h                ; Closes resource file
  MOV AH,048h
  MOV BX,NumTextures
  AND BX,0Fh
  SHL BX,8
  INT 021h
  JNC @F
    MOV AH,0Ah
    MOV DX,XMShdl
    CALL [XMSfunc]        ; Releases XMS memory
    MOV BX,TrigSeg
    MOV ES,BX
    MOV AH,049h
    INT 021h                ; Frees base memory
    MOV AX,5              ; Error 5: Error allocating base memory
    RET
@@:
  MOV TextureSeg,AX
  MOV AX,03509h
  INT 021h
  SHL EBX,16
  MOV BX,ES
  MOV OldInt9,EBX
  MOV BX,SEG KeyboardISR
  MOV DX,OFFSET KeyboardISR
  MOV DS,BX
  MOV AX,02509h
  INT 021h
  MOV CX,@DATA
  MOV DS,CX
  MOV OldTile,0FFh
  MOV AX,@DATA
  MOV ES,AX
  MOV DI,OFFSET CurFont
  XOR AX,AX
  MOV DS,AX
  MOV SI,DS:[07Ch]
  MOV AX,DS:[07Eh]
  SUB SI,1024
  MOV DS,AX
  MOV CX,512
  REP MOVSD
  MOV CX,257
  MOV AL,8
  REP STOSB
  XOR AX,AX               ; Returns without errors
  RET
KeyboardISR:
  PUSH BP
  PUSH DS
  PUSH AX
  PUSH BX
  MOV BX,@DATA
  MOV DS,BX
  IN AL,60h
  XOR BH,BH
  MOV BL,AL
  .IF BL <= 07Fh
    MOV Key[BX],1
  .ELSE
    AND BL,07Fh
    MOV Key[BX],0
  .ENDIF
  IN AL,061h
  OR AL,080h
  OUT 061h,AL
  MOV AL,020h
  OUT 020h,AL
  POP BX
  POP AX
  IRET
RTEinit ENDP


COMMENT \ 
  RTEclose Procedure
  - Deallocates XMS memory
  - Deallocates base memory
  - Restores old keyboard ISR
\ 
RTEclose PROC USES DS ES
  MOV BX,TrigSeg
  MOV ES,BX
  MOV AH,049h
  INT 021h                ; Frees base memory
  MOV BX,TextureSeg
  MOV ES,BX
  MOV AH,049h
  INT 021h
  MOV AH,0Ah
  MOV DX,XMShdl
  CALL [XMSfunc]          ; Frees XMS memory
  MOV EDX,OldInt9
  MOV DS,DX
  SHR EDX,16
  MOV AX,02509h
  INT 021h                ; Restores old keyboard handler
  RET
RTEclose ENDP


COMMENT \ 
  RTEsetOptions Procedure
  - Sets or clears specified engine option flags
  - Sets floor and ceiling filling colors when textures are disabled
  - Sets light map colors lookup table and sight factor
\ 
RTEsetOptions PROC USES DS,OptionsSeg:WORD,OptionsOff:WORD

  MOV AX,OptionsSeg
  MOV DS,AX
  MOV SI,OptionsOff
  MOV BX,@DATA
  MOV ES,BX
  MOV DI,OFFSET Settings
  XOR AH,AH
  MOV CX,7
@@:
  LODSW
  STOSB
  DEC CX
  JNZ @B
  MOV CX,5
  REP MOVSW
  MOV AX,@DATA
  MOV DS,AX
  MOV DX,Settings.Sight
  SHR DX,4
  MOV AX,4096
  MOV CX,12
@@:
  TEST DX,AX
  JNZ @F
  SHR AX,1
  DEC CX
  JNZ @B
;  INC CX
@@:
  AND Settings.Sight,0FFF0h
  MOV SightStep,CL
  TEST Settings.Detail,8
  JNZ @F
  MOV Settings.Sight,10000
@@:
  RET
RTEsetOptions ENDP


COMMENT \ 
  RTEtoScreen Procedure
  - Waits for video refresh
  - Copies the contents of the specified 64K offscreen buffer to the screen
\ 
RTEtoScreen PROC USES DS ES,BufferSeg:WORD
  TEST Settings.Detail,04h
  JZ NoWait
  MOV DX,3DAh             ; Vertical retrace port
@@:
  IN AL,DX
  AND AL,8
  JNZ @B
@@:
  IN AL,DX
  AND AL,8
  JZ @B
NoWait:
  MOV CX,16000            ; We're using fast DWORD copy here
  MOV DX,0A000h
  MOV ES,DX
  MOV BX,BufferSeg
  MOV DS,BX
  XOR SI,SI
  XOR DI,DI
  REP MOVSD               ; Blasts the buffer on the screen
  RET
RTEtoScreen ENDP


COMMENT \ 
  RTEtoBox Procedure
  - Waits for video refresh
  - Scales and copies the contents of the specified 64K offscreen buffer to a
    box onto the screen
\ 
RTEtoBox PROC USES DS ES,BufferSeg:WORD,x:WORD,y:WORD
  TEST Settings.Detail,04h
  JZ bNoWait
  MOV DX,3DAh             ; Vertical retrace port
@@:
  IN AL,DX
  AND AL,8
  JNZ @B
@@:
  IN AL,DX
  AND AL,8
  JZ @B
bNoWait:
  MOV DX,0A000h
  MOV ES,DX
  MOV BX,BufferSeg
  MOV DS,BX
  XOR SI,SI
  MOV DI,y
  MOV AX,DI
  SHL AX,6
  SHL DI,8
  ADD DI,AX
  ADD DI,x
  MOV CX,50
  MOV DX,80
@@:
  MOV AL,[SI]
  MOV ES:[DI],AL
  ADD SI,4
  INC DI
  DEC DX
  JNZ @B
  ADD DI,240
  ADD SI,960
  MOV DX,80
  DEC CX
  JNZ @B
  RET
RTEtoBox ENDP


COMMENT \ 
  RTEdoFrame Procedure
  - Renders a frame (main raycasting function!!!)
\ 
RTEdoFrame PROC USES DS ES FS GS,BufferSeg:WORD,EgoX:WORD,EgoY:WORD,Angle:WORD,DoorSeg:WORD,ObjectSeg:WORD

LOCAL CurSlice:WORD,XX:WORD,XY:DWORD,YY:WORD,YX:DWORD,Xtile:BYTE,Ytile:BYTE
LOCAL Xcos:DWORD,XtoAdd:WORD,Xtan:DWORD,Ysin:DWORD,YtoAdd:WORD,Ytan:DWORD
LOCAL XLen:DWORD,YLen:DWORD,SliceInfo:WORD,Height:WORD,StartY:WORD,EndY:WORD
LOCAL DeltaX:DWORD,DeltaY:DWORD,FloorX:DWORD,FloorY:DWORD
LOCAL vx:WORD,vy:WORD,SliceFix:DWORD,XtextCol:BYTE,YtextCol:BYTE
LOCAL HalfXtoAdd:WORD,HalfYtoAdd:WORD,XdoorHit:BYTE,YdoorHit:BYTE
LOCAL ObjCounter:WORD,ObjSize:WORD,ObjDist:WORD,ObjY:WORD
LOCAL OldTexture:WORD,XmapPos:WORD,YmapPos:WORD

  MOV CX,@DATA
  MOV AX,BufferSeg
  MOV BX,TrigSeg
  MOV DX,DoorSeg
  MOV DS,CX
  MOV ES,AX
  MOV FS,BX
  MOV GS,DX

  MOV DX,@DATA
  MOV ES,DX
  MOV CX,128
  MOV DI,OFFSET ViewMap
  XOR EAX,EAX
  REP STOSD               ; Clears visibility map
  MOV BX,BufferSeg
  MOV ES,BX

; ###########################################################################
; ################## SKY DRAWING ############################################
; ###########################################################################

  .IF Settings.Detail & 16
    MOV XMSmove.Len,64000
    MOV CX,XMShdl
    MOV XMSmove.SourceHdl,CX
    MOV XMSmove.SourceOff,0
    MOV XMSmove.DestHdl,0
    MOV BX,BufferSeg
    SHL EBX,16
    XOR BX,BX
    MOV XMSmove.DestOff,EBX
    MOV SI,OFFSET XMSmove
    MOV AH,0Bh
    CALL [XMSfunc]
    MOV DX,170
    SUB DX,PlaneHeight
    MOV SI,DX
    MOV AX,DX
    SHL AX,6
    SHL SI,8
    ADD SI,AX
    XOR DI,DI
    MOV AX,ES
    MOV DS,AX
    MOV BX,170
    SUB BX,DX
@@:
    MOV CX,80
    REP MOVSD
    DEC BX
    JNZ @B
    MOV BX,320
    MOV AX,Angle
    CWD
    DIV BX
    MOV SI,DX
    XOR DI,DI
    MOV CX,171*320
    REP MOVSB
    .IF DX != 320
      MOV BX,320
      SUB BX,DX
      MOV DX,170
      XOR DI,DI
      MOV SI,320
@@:
      MOV CX,BX
      REP MOVSB
      ADD SI,320
      SUB SI,BX
      ADD DI,320
      SUB DI,BX
      DEC DX
      JNZ @B
    .ENDIF
    MOV AX,@DATA
    MOV DS,AX
    TEST Settings.Detail,1
    JNZ @F
    MOV AL,Settings.FloorCol
    MOV AH,AL
    MOV BX,AX
    SHL EAX,16
    MOV AX,BX
    MOV DI,PlaneHeight
    MOV DX,DI
    MOV BX,DX
    SHL DX,6
    SHL DI,8
    ADD DI,DX
    MOV SI,BX
    SHL SI,6
    SHL BX,4
    ADD BX,SI
    MOV CX,16000
    SUB CX,BX
    REP STOSD
@@:
  .ELSE
    MOV AL,Settings.CeilingCol
    MOV AH,AL
    MOV DX,AX
    SHL EAX,16
    MOV AX,DX
    XOR DI,DI
    MOV CX,PlaneHeight
    MOV BX,CX
    SHL BX,6
    SHL CX,4
    ADD CX,BX
    MOV DX,CX
    REP STOSD
    MOV AL,Settings.FloorCol
    MOV AH,AL
    MOV BX,AX
    SHL EAX,16
    MOV AX,BX
    MOV CX,16000
    SUB CX,DX
    REP STOSD
  .ENDIF
  MOV AX,@DATA
  MOV DS,AX

; ###########################################################################
; ################## WALLS/DOORS DRAWING ####################################
; ###########################################################################

  MOV CurSlice,0
  MOV DX,Angle
  SHL DX,4
  MOV SI,DX               ; SI is the trig offset
SliceLoop:
  MOV AX,EgoX             ; Finds the coordinate of first x grid intersection
  AND AX,0FFC0h
  MOV XX,AX
  MOV EAX,FS:[SI+4]
  MOV Xcos,EAX
  CMP EAX,0
  JL @F
    ADD XX,040h
    MOV XtoAdd,040h
    MOV HalfXtoAdd,020h
    JMP XXok
@@:
    DEC XX
    MOV XtoAdd,-040h
    MOV HalfXtoAdd,-020h
XXok:
  MOV AX,EgoY
  SHL EAX,16
  MOV XY,EAX
  XOR EDX,EDX
  MOV DX,EgoX
  .IF XX < DX
    SUB DX,XX
  .ELSE
    MOV BX,XX
    SUB BX,DX
    MOV DX,BX
  .ENDIF
  MOV EAX,FS:[SI+8]
  MOV Xtan,EAX
  SHL Xtan,6
  IMUL EDX
  ADD XY,EAX
  MOV AX,EgoY             ; Finds the coordinate of first y grid intersection
  AND AX,0FFC0h
  MOV YY,AX
  MOV EAX,FS:[SI]
  MOV Ysin,EAX
  CMP EAX,0
  JL @F
    ADD YY,040h
    MOV YtoAdd,040h
    MOV HalfYtoAdd,020h
    JMP YYok
@@:
    DEC YY
    MOV YtoAdd,-040h
    MOV HalfYtoAdd,-020h
YYok:
  MOV AX,EgoX
  SHL EAX,16
  MOV YX,EAX
  XOR EDX,EDX
  MOV DX,EgoY
  .IF YY < DX
    SUB DX,YY
  .ELSE
    MOV BX,YY
    SUB BX,DX
    MOV DX,BX
  .ENDIF
  MOV EAX,FS:[SI+12]
  MOV Ytan,EAX
  SHL Ytan,6
  IMUL EDX
  ADD YX,EAX
CastRay:
  MOV Xtile,0
  MOV Ytile,0
  MOV XdoorHit,0
  MOV YdoorHit,0
StepX:
  MOV AX,XX               ; Steps through the map to find x wall intersections
  CMP AX,0
  JL EndStepX
  CMP AX,0FFFh
  JG EndStepX
  MOV EBX,XY
  CMP EBX,0
  JL EndStepX
  CMP EBX,0FFFFFFFh
  JG EndStepX
  SHR AX,6
  SHR EBX,22
  SHL BX,6
  ADD BX,AX
  MOV AL,LevelMap[BX]
  MOV XmapPos,BX
  MOV CX,BX
  SHR BX,3
  MOV DL,1
  AND CX,07h
  SHL DL,CL
  OR ViewMap[BX],DL
  MOV Xtile,AL
  AND AL,080h
  .IF AL == 0
    .IF Xtile != 0
      MOV EDX,XY
      SHR EDX,16
      AND DL,03Fh
      MOV Xtextcol,DL
      JMP EndStepX      ; Normal wall
    .ENDIF
  .ELSE
    MOV DX,HalfXtoAdd   ; Door
    ADD XX,DX
    SUB Xtile,128
    MOV AL,Xtile
    XOR AH,AH
    MOV DI,AX
    SHL DI,3            ; Gets door offset
    MOV AL,GS:[DI+6]
    MOV Xtile,AL
    INC Xtile
    CMP BYTE PTR GS:[DI+1],0
    JNE @F
    MOV EDX,XY          ; Inactive door
    MOV EAX,Xtan
    SHR EAX,1
    ADD EDX,EAX
    SHR EDX,16
    INC DX
    AND DL,03Fh
    MOV Xtextcol,DL
    MOV XdoorHit,1
    JMP EndStepX
@@:
    MOV EDX,XY          ; Active door
    MOV EAX,Xtan
    SHR EAX,1
    ADD EDX,EAX
    SHR EDX,16
    INC DX
    AND DL,03Fh
    ADD DL,GS:[DI]
    .IF DL < 64
      MOV Xtile,0
      MOV AX,HalfXtoAdd
      SUB XX,AX
    .ELSE
      SUB DL,63
      MOV XtextCol,DL
      JMP EndStepX
    .ENDIF
  .ENDIF
  MOV DX,XtoAdd
  ADD XX,DX
  MOV EAX,Xtan
  ADD XY,EAX
  JMP StepX
EndStepX:

StepY:
  MOV AX,YY               ; Steps through the map to find y wall intersections
  CMP AX,0
  JL EndStepY
  CMP AX,0FFFh
  JG EndStepY
  MOV EBX,YX
  CMP EBX,0
  JL EndStepY
  CMP EBX,0FFFFFFFh
  JG EndStepY
  SHR EBX,22
  AND AL,0C0h
  ADD BX,AX
  MOV AL,LevelMap[BX]
  MOV YmapPos,BX
  MOV CX,BX
  SHR BX,3
  MOV DL,1
  AND CX,07h
  SHL DL,CL
  OR ViewMap[BX],DL
  MOV Ytile,AL
  AND AL,080h
  .IF AL == 0
    .IF Ytile != 0
      MOV EDX,YX
      SHR EDX,16
      AND DL,03Fh
      MOV Ytextcol,DL
      JMP EndStepY      ; Normal wall
    .ENDIF
  .ELSE
    MOV DX,HalfYtoAdd   ; Door
    ADD YY,DX
    SUB Ytile,128
    MOV AL,Ytile
    INC Ytile
    XOR AH,AH
    MOV DI,AX
    SHL DI,3            ; Gets door offset
    MOV AL,GS:[DI+6]
    MOV Ytile,AL
    INC Ytile
    CMP BYTE PTR GS:[DI+1],0
    JNE @F
    MOV EDX,YX          ; Inactive door
    MOV EAX,Ytan
    SHR EAX,1
    ADD EDX,EAX
    SHR EDX,16
    INC DX
    AND DL,03Fh
    MOV Ytextcol,DL
    MOV YdoorHit,1
    JMP EndStepY
@@:
    MOV EDX,YX          ; Active door
    MOV EAX,Ytan
    SHR EAX,1
    ADD EDX,EAX
    SHR EDX,16
    INC DX
    AND DL,03Fh
    ADD DL,GS:[DI]
    .IF DL < 64
      MOV Ytile,0
      MOV AX,HalfYtoAdd
      SUB YY,AX
    .ELSE
      SUB DL,63
      MOV YtextCol,DL
      JMP EndStepY
    .ENDIF
  .ENDIF
  MOV DX,YtoAdd
  ADD YY,DX
  MOV EAX,Ytan
  ADD YX,EAX
  JMP StepY
EndStepY:
  
  .IF Xtile == 0
    MOV Xlen,07FFFFFFFh
  .ELSE
    MOV EAX,Xcos
    XOR EDX,EDX
    MOV DX,XX
    XOR EBX,EBX
    MOV BX,EgoX
    SUB EDX,EBX
    IMUL EDX
    MOV Xlen,EAX
  .ENDIF
  .IF Ytile == 0
    MOV Ylen,07FFFFFFFh
  .ELSE
    MOV EAX,Ysin
    XOR EDX,EDX
    MOV DX,YY
    XOR EBX,EBX
    MOV BX,EgoY
    SUB EDX,EBX
    IMUL EDX
    MOV Ylen,EAX
  .ENDIF
  MOV EAX,Xlen            ; Let's identify the slice and its distance
  .IF EAX < Ylen
    MOV BX,XmapPos
    MOV CX,BX
    SHR BX,2
    AND CX,03h
    ADD CX,CX
    MOV DL,3
    SHL DL,CL
    NOT DL
    AND PlayerMap[BX],DL
    MOV DL,1
    .IF XdoorHit != 0
      MOV DL,2
    .ENDIF
    SHL DL,CL
    OR PlayerMap[BX],DL
    MOV BX,XmapPos
    SHR BX,6
    MOV vy,BX
    MOV BX,XmapPos
    AND BX,03Fh
    MOV vx,BX
    MOV BX,EgoX
    SHR BX,6
    MOV DX,EgoY
    SHR DX,6
    INVOKE MapLine,vx,vy,BX,DX
    MOV ECX,EAX
    MOV DL,Xtile          ; DL holds tile texture number
    DEC DL
    MOV DH,XtextCol       ; DH holds texture column to be drawn
  .ELSE
    MOV BX,YmapPos
    MOV CX,BX
    SHR BX,2
    AND CX,03h
    ADD CX,CX
    MOV DL,3
    SHL DL,CL
    NOT DL
    AND PlayerMap[BX],DL
    MOV DL,1
    .IF YdoorHit != 0
      MOV DL,2
    .ENDIF
    SHL DL,CL
    OR PlayerMap[BX],DL
    MOV BX,YmapPos
    SHR BX,6
    MOV vy,BX
    MOV BX,YmapPos
    AND BX,03Fh
    MOV vx,BX
    MOV BX,EgoX
    SHR BX,6
    MOV DX,EgoY
    SHR DX,6
    INVOKE MapLine,vx,vy,BX,DX
    MOV ECX,Ylen
    MOV DL,Ytile
    DEC DL
    MOV DH,YTextCol
  .ENDIF
  MOV SliceInfo,DX
  MOV DI,CurSlice
  SHL DI,2
  MOV EBX,FS:[30720+DI]
  MOV EAX,ECX
  XOR EDX,EDX
  IDIV EBX
  .IF AX == 0
    MOV AX,1              ; To avoid possible division errors
  .ENDIF
  SHR DI,1
  MOV WallDist[DI],AX     ; Save slice distance for objects hiding
  MOV BX,AX               ; Finds height of slice
  MOV AX,17736
  XOR DX,DX
  DIV BX
  MOV EndY,AX
  MOV BX,64
  SUB BX,EyeHeight
  MUL BX
  SHL EDX,16
  MOV DX,AX
  SHR EDX,6
  MOV AX,PlaneHeight
  SUB AX,DX
  MOV StartY,AX
  ADD EndY,AX
  MOV AX,StartY
  MOV CX,SliceInfo
  AND CX,0Fh
  SHL CX,8
  ADD CX,TextureSeg
  MOV GS,CX
  MOV DI,CurSlice
  ADD DI,DI
  MOV DX,WallDist[DI]
  SHR DI,1
  .IF DX >= Settings.Sight
    MOV AX,StartY
    DEC AX
    .IF AX & 08000h
      MOV CX,EndY
      INC CX
      .IF CX > 200
        MOV CX,200
      .ENDIF
    .ELSE
      INC AX
      MOV BX,AX
      SHL BX,8
      SHL AX,6
      ADD AX,BX
      ADD DI,AX
      MOV CX,EndY
      SUB CX,StartY
      INC CX
      .IF CX > 200
        MOV CX,200
      .ENDIF
    .ENDIF
    MOV AL,HorizonCol
@@:
    MOV ES:[DI],AL
    ADD DI,320
    DEC CX
    JNZ @B
  .ELSE
    MOV CL,SightStep
    SHR DX,CL
    MOV BH,DL
    MOV AX,EndY
    SUB AX,StartY
    INC AX
    MOV Height,AX
    CMP StartY,0
    JL @F
    MOV DX,StartY
    MOV AX,DX
    SHL AX,6
    SHL DX,8
    ADD AX,DX
    ADD DI,AX
@@:   
    MOV DX,StartY
    XOR CX,CX

    MOV AX,SliceInfo
    SHR AX,8
    PUSH SI

    MOV SI,AX

    .IF BYTE PTR GS:[SI] == 0
      POP SI
      MOV EAX,Xlen
      .IF EAX < Ylen
        MOV AX,HalfXtoAdd
        SUB XX,AX
        MOV AX,XtoAdd
        ADD XX,AX
        MOV EAX,Xtan
        ADD XY,EAX
      .ELSE
        MOV AX,HalfYtoAdd
        SUB YY,AX
        MOV AX,YtoAdd
        ADD YY,AX
        MOV EAX,Ytan
        ADD YX,EAX
      .ENDIF
      MOV AX,DoorSeg
      MOV GS,AX
      JMP CastRay
    .ENDIF

DrawSlice:
    CMP DX,0                ; Starts drawing vertical wall slice
    JL @F
    MOV BL,GS:[SI]
    .IF Settings.Detail & 8
      MOV BL,LightMap[BX]
    .ENDIF
    MOV ES:[DI],BL
      
    ADD DI,320
@@:
    ADD CX,040h
@@:
    CMP CX,Height
    JB @F
    ADD SI,040h
    SUB CX,Height
    JMP @B
@@:
    INC DX
    CMP DX,EndY
    JG @F
    CMP DI,0FA00h
    JB DrawSlice
@@:
    POP SI
  .ENDIF
  MOV AX,DoorSeg
  MOV GS,AX

; ###########################################################################
; ################## FLOOR DRAWING ##########################################
; ###########################################################################

  TEST Settings.Detail,1
  JZ SkipFloor
  .IF EndY < 199
    MOV BX,CurSlice
    SHL BX,2
    ADD BX,30720
    MOV AX,EyeHeight
    CWDE
    MOV ECX,18161873
    MUL ECX
    SHR EAX,16
    IMUL DWORD PTR FS:[BX]
    PUSH EDX
    PUSH EAX
    MOV ECX,FS:[SI+4]
    .IF ECX == 0
      XOR EAX,EAX
    .ELSE
      IDIV ECX
    .ENDIF
    SHL EAX,16
    MOV DeltaX,EAX
    POP EAX
    POP EDX
    MOV ECX,FS:[SI]
    .IF ECX == 0
      XOR EAX,EAX
    .ELSE
      IDIV ECX
    .ENDIF
    SHL EAX,16
    MOV DeltaY,EAX
    MOV AX,EgoX
    SHL EAX,16
    MOV FloorX,EAX
    MOV DX,EgoY
    SHL EDX,16
    MOV FloorY,EDX
    MOV CX,EndY
    INC CX
    MOV DI,CX
    MOV AX,DI
    SHL AX,6
    SHL DI,8
    ADD DI,AX
    ADD DI,CurSlice

@@:
    MOV AX,CX
    SUB AX,PlaneHeight
    CWDE
    MOV EBX,EAX
    MOV EAX,DeltaX
    CDQ
    IDIV EBX
    ADD EAX,FloorX
    SHR EAX,16
    MOV vx,AX
    MOV EAX,DeltaY
    CDQ
    IDIV EBX
    ADD EAX,FloorY
    SHR EAX,16
    MOV vy,AX
    MOV BX,AX
    AND BX,0FFC0h
    MOV AX,vx
    SHR AX,6
    ADD BX,AX
    MOV DL,LevelMap[4096+BX]
    AND DL,0Fh
    XOR DH,DH
    SHL DX,8
    ADD DX,TextureSeg
    MOV GS,DX
    MOV BX,vy
    AND BX,03Fh
    SHL BX,6
    MOV AX,vx
    AND AX,03Fh
    ADD BX,AX
    MOV BL,GS:[BX]
    .IF Settings.Detail & 8
      MOV DL,BL
      MOV BX,CX
      SUB BX,PlaneHeight
      INC BX
      ADD BX,BX
      MOV AX,FloorDist[BX]
      MOV BL,DL
      .IF AX >= Settings.Sight
        MOV BL,HorizonCol
      .ELSE
        PUSH CX
        MOV CL,SightStep
        SHR AX,CL
        MOV BH,AL
        MOV BL,LightMap[BX]
        POP CX
      .ENDIF
    .ENDIF
    MOV ES:[DI],BL
    ADD DI,320
    INC CX
    CMP CX,200
    JB @B
  .ENDIF
SkipFloor:

; ###########################################################################
; ################## CEILING DRAWING ########################################
; ###########################################################################

  TEST Settings.Detail,2
  JZ SkipCeiling
  CMP StartY,0
  JLE SkipCeiling
    MOV BX,CurSlice
    SHL BX,2
    ADD BX,30720
    MOV AX,64
    SUB AX,EyeHeight
    CWDE
    MOV ECX,18161873
    MUL ECX
    SHR EAX,16
    IMUL DWORD PTR FS:[BX]
    PUSH EDX
    PUSH EAX
    MOV ECX,FS:[SI+4]
    .IF ECX == 0
      XOR EAX,EAX
    .ELSE
      IDIV ECX
    .ENDIF
    SHL EAX,16
    MOV DeltaX,EAX
    POP EAX
    POP EDX
    MOV ECX,FS:[SI]
    .IF ECX == 0
      XOR EAX,EAX
    .ELSE
      IDIV ECX
    .ENDIF
    SHL EAX,16
    MOV DeltaY,EAX
    MOV AX,EgoX
    SHL EAX,16
    MOV FloorX,EAX
    MOV DX,EgoY
    SHL EDX,16
    MOV FloorY,EDX
    MOV CX,StartY
    DEC CX
    MOV DI,CX
    MOV AX,DI
    SHL AX,6
    SHL DI,8
    ADD DI,AX
    ADD DI,CurSlice

@@:
    MOV AX,CX
    SUB AX,PlaneHeight
    .IF AX & 08000h
      NEG AX
    .ENDIF
    CWDE
    MOV EBX,EAX
    MOV EAX,DeltaX
    CDQ
    IDIV EBX
    ADD EAX,FloorX
    SHR EAX,16
    MOV vx,AX
    MOV EAX,DeltaY
    CDQ
    IDIV EBX
    ADD EAX,FloorY
    SHR EAX,16
    MOV vy,AX
    MOV BX,AX
    AND BX,0FFC0h
    MOV AX,vx
    SHR AX,6
    ADD BX,AX
    MOV DL,LevelMap[4096+BX]
    XOR DH,DH
    SHR DX,4
    .IF DX != 0Fh
      SHL DX,8
      ADD DX,TextureSeg
      MOV GS,DX
      MOV BX,vy
      AND BX,03Fh
      SHL BX,6
      MOV AX,vx
      AND AX,03Fh
      ADD BX,AX
      MOV BL,GS:[BX]
      .IF Settings.Detail & 8
        MOV DL,BL
        MOV BX,PlaneHeight
        SUB BX,CX

        INC BX
        ADD BX,BX
        MOV AX,CeilingDist[BX]
        MOV BL,DL
        .IF AX >= Settings.Sight
          MOV BL,HorizonCol
        .ELSE
          PUSH CX
          MOV CL,SightStep
          SHR AX,CL
          MOV BH,AL
          MOV BL,LightMap[BX]
          POP CX
        .ENDIF
      .ENDIF
      MOV ES:[DI],BL
    .ENDIF
    SUB DI,320
    DEC CX
    CMP CX,0
    JGE @B
SkipCeiling:

  MOV BX,DoorSeg
  MOV GS,BX

  ADD SI,16
  .IF SI >= 30720
    XOR SI,SI
  .ENDIF
  INC CurSlice            ; Process next screen column
  CMP CurSlice,320
  JB SliceLoop

; ###########################################################################
; ################## OBJECTS HANDLING #######################################
; ###########################################################################

  FNINIT
  MOV AX,ObjectSeg
  MOV GS,AX
  XOR CX,CX
  ADD Angle,640
  .IF Angle >= 1920
    SUB Angle,1920
  .ENDIF
  MOV ObjCounter,0
TranslateObjects:
  MOV SI,CX
  SHL SI,4
  MOV DI,ObjCounter
  MOV AX,GS:[SI]
  MOV Object[DI].Texture,AX
  .IF AX != 0FFFFh
    MOV AX,EgoY
    SUB AX,GS:[SI+4]
    SHL EAX,16
    MOV YX,EAX
    MOV AX,GS:[SI+2]
    SUB AX,EgoX
    SHL EAX,16
    MOV XY,EAX
    MOV BX,GS:[SI+4]
    AND BX,0FFC0h
    MOV AX,GS:[SI+2]
    SHR AX,6
    ADD BX,AX

    PUSH CX
    MOV CX,BX
    SHR BX,3
    MOV DL,1
    AND CX,07h
    SHL DL,CL
    POP CX

    .IF ViewMap[BX] & DL
      MOV BX,Angle
      SHL BX,4
      MOV EAX,XY
      CDQ
      IDIV DWORD PTR FS:[BX+4]
      MOV XX,AX
      MOV EAX,YX
      CDQ
      IDIV DWORD PTR FS:[BX]
      SUB XX,AX
      MOV EAX,XY
      CDQ
      IDIV DWORD PTR FS:[BX]
      MOV YY,AX
      MOV EAX,YX
      CDQ
      IDIV DWORD PTR FS:[BX+4]
      ADD YY,AX
      CMP YY,16
      JB @F

      MOV AX,XX
      MOV BX,277
      IMUL BX
      IDIV YY
      ADD AX,160
      MOV Object[DI].CenterX,AX
      MOV AX,GS:[SI+2]
      SUB AX,EgoX
      CWDE
      MOV EBX,EAX
      IMUL EBX
      MOV XY,EAX
      MOV AX,GS:[SI+4]
      SUB AX,EgoY
      CWDE
      MOV EBX,EAX
      IMUL EBX
      ADD XY,EAX
      FILD XY
      FSQRT
      FISTP XY
      FWAIT
      MOV EAX,XY
      MOV BX,Object[DI].CenterX
      .IF BX < 0
        XOR BX,BX
      .ELSEIF BX > 319
        MOV BX,319
      .ENDIF
      SHL BX,2
      SHL EAX,16
      CDQ
      IDIV DWORD PTR FS:[30720+BX]
      MOV Object[DI].Distance,AX
      .IF Settings.Detail & 8
        CMP AX,Settings.Sight
        JGE @F
      .ENDIF

      ADD ObjCounter,6
    .ENDIF
  .ENDIF
@@:
  INC CX
  CMP CX,256
  JB TranslateObjects
  MOV AX,ObjCounter
  .IF AX == 0
    RET
  .ENDIF
  MOV BX,6
  CWD
  DIV BX
  MOV ObjCounter,AX
  .IF ObjCounter > 1
    MOV CX,ObjCounter
    DEC CX
    MOV AX,CX
    SHL CX,2
    ADD CX,AX
    ADD CX,AX
    XOR SI,SI
BubbleSort:
    MOV AX,Object[SI].Distance
    MOV DI,SI
    ADD DI,6
@@:
    .IF AX > Object[DI].Distance
      MOV BX,Object[DI].Distance
      MOV Object[SI].Distance,BX
      MOV Object[DI].Distance,AX
      MOV AX,BX
      MOV DX,Object[SI].Texture
      MOV BX,Object[DI].Texture
      MOV Object[DI].Texture,DX
      MOV Object[SI].Texture,BX
      MOV DX,Object[SI].CenterX
      MOV BX,Object[DI].CenterX
      MOV Object[DI].CenterX,DX
      MOV Object[SI].CenterX,BX
    .ENDIF
    ADD DI,6
    CMP DI,CX
    JBE @B
    ADD SI,6
    CMP SI,CX
    JB BubbleSort
  .ENDIF
  MOV DL,OldTile
  XOR DH,DH
  MOV OldTexture,DX
DrawSprites:
  MOV SI,ObjCounter
  DEC SI
  MOV BX,SI
  SHL SI,2
  ADD SI,BX
  ADD SI,BX
  XOR EBX,EBX
  MOV BX,Object[SI].Texture
  .IF BX != OldTexture
    PUSH SI
    MOV OldTexture,BX
    MOV XMSmove.Len,4096
    MOV DX,XMShdl
    MOV XMSmove.SourceHdl,DX
    SHL EBX,12
    ADD EBX,64000
    MOV XMSmove.SourceOff,EBX
    MOV XMSmove.DestHdl,0
    MOV BX,SEG SpriteBuf
    SHL EBX,16
    MOV BX,OFFSET SpriteBuf
    MOV XMSmove.DestOff,EBX
    MOV SI,OFFSET XMSmove
    MOV AH,0Bh
    CALL [XMSfunc]
    POP SI
  .ENDIF
  MOV AX,17736
  XOR DX,DX
  MOV BX,Object[SI].Distance
  CMP BX,Settings.Sight
  JGE SkipObject
  MOV ObjDist,BX
  DIV BX
  MOV ObjSize,AX
  MOV vx,AX

  MOV BX,64
  SUB BX,EyeHeight
  MUL BX
  SHL EDX,16
  MOV DX,AX
  SHR EDX,6
  MOV AX,PlaneHeight
  SUB AX,DX
  MOV ObjY,AX

  MOV BX,Object[SI].Distance
  MOV CL,SightStep
  SHR BX,CL
  MOV BH,BL
  MOV AX,04000h
  XOR DX,DX
  DIV ObjSize
  MOV XtoAdd,AX
  MOV AX,ObjSize
  SHR AX,1
  MOV DI,ObjY
  MOV YY,DI
  MOV DX,Object[SI].CenterX
  SUB DX,AX
  MOV XX,DX
  XOR CX,CX         ; CX is the row counter
  XOR DX,DX         ; DX is the column counter
LineLoop:
  CMP XX,0
  JL SkipLine
  CMP XX,319
  JG SkipObject
  MOV DI,XX
  ADD DI,DI
  MOV AX,ObjDist
  CMP AX,WallDist[DI]
  JG SkipLine
  MOV AX,ObjSize
  MOV vy,AX
RowLoop:
  CMP YY,0
  JL SkipPixel
  CMP YY,199
  JG SkipPixel
  MOV DI,YY
  MOV AX,DI
  SHL AX,6
  SHL DI,8
  ADD DI,AX
  ADD DI,XX
  MOV SI,DX
  SHR SI,2
  AND SI,0FFC0h
  MOV AX,CX
  SHR AX,8
  ADD SI,AX
  MOV BL,SpriteBuf[SI]
  .IF BL != 0
    .IF Settings.Detail & 8
      MOV BL,LightMap[BX]
    .ENDIF
    MOV ES:[DI],BL
  .ENDIF
SkipPixel:
  ADD DX,XtoAdd
  INC YY
  DEC vy
  JNZ RowLoop
  MOV AX,ObjSize
  SUB YY,AX
SkipLine:
  XOR DX,DX
  ADD CX,XtoAdd
  INC XX
  DEC vx
  JNZ LineLoop
SkipObject:
  DEC ObjCounter
  JNZ DrawSprites
  MOV BX,OldTexture
  .IF BX > 255
    MOV BL,0FFh
  .ENDIF
  MOV OldTile,BL
  RET
RTEdoFrame ENDP


COMMENT \ 
  RTEloadMap Procedure
  - Loads specified map
  - Zeroes player's level map
  - Initializes doors
  - Initializes objects
\ 
RTEloadMap PROC USES DS ES,MapSeg:WORD,DoorSeg:WORD,ObjectSeg:WORD

  MOV AX,@DATA
  MOV ES,AX
  MOV DI,OFFSET PlayerMap
  MOV CX,256
  XOR EAX,EAX
  REP STOSD
  MOV BX,MapSeg
  MOV DS,BX
  MOV CX,2048
  MOV DI,OFFSET LevelMap
  XOR SI,SI
  REP MOVSD
  MOV BX,@DATA
  MOV DS,BX
  MOV AX,DoorSeg
  MOV ES,AX
  MOV EAX,0FFFFFFFFh
  MOV CX,256
  XOR DI,DI
  REP STOSD
  XOR SI,SI
@@:
  MOV AL,LevelMap[SI]
  .IF AL & 080h
    AND AL,07Fh
    XOR AH,AH
    MOV DI,AX
    SHL DI,3
    MOV BYTE PTR ES:[DI],63
    MOV BYTE PTR ES:[DI+1],0
    MOV WORD PTR ES:[DI+2],0
    MOV BX,SI
    AND BX,03Fh
    MOV BYTE PTR ES:[DI+4],BL
    MOV BX,SI
    SHR BX,6
    MOV BYTE PTR ES:[DI+5],BL
    MOV BYTE PTR ES:[DI+6],0
  .ENDIF
  INC SI
  CMP SI,4096
  JB @B
  MOV BX,ObjectSeg
  MOV ES,BX
  MOV AX,0FFFFh
  XOR DI,DI
  MOV CX,256
@@:
  MOV ES:[DI],AX
  ADD DI,16
  DEC CX
  JNZ @B
  RET
RTEloadMap ENDP


COMMENT \ 
  RTEstoreSprite Procedure
  - Stores given sprite into XMS. Sprite must be 64x64 and in GET/PUT format
\ 
RTEstoreSprite PROC USES DS,SpriteSeg:WORD,IdNumber:WORD
  MOV XMSmove.Len,4096
  MOV XMSmove.SourceHdl,0
  MOV BX,SpriteSeg
  SHL EBX,16
  MOV BX,4            ; Skips the sprite header, since we know it's 64x64
  MOV XMSmove.SourceOff,EBX
  MOV AX,XMShdl
  MOV XMSmove.DestHdl,AX
  XOR EDX,EDX
  MOV DX,IdNumber
  SHL EDX,12          ; Finds offset into XMS block from specified number
  ADD EDX,64000
  MOV XMSmove.DestOff,EDX
  MOV SI,OFFSET XMSmove
  MOV AH,0Bh
  CALL [XMSfunc]
  RET
RTEstoreSprite ENDP


COMMENT \ 
  RTEstoreTexture Procedure
  - Stores given texture into base memory. Texture must be 64x64 and in
    GET/PUT format
\ 
RTEstoreTexture PROC USES DS ES,TextSeg:WORD,IdNumber:WORD
  MOV AX,TextSeg
  MOV BX,IdNumber
  SHL BX,8
  ADD BX,TextureSeg
  MOV ES,BX
  MOV DS,AX
  MOV CX,1024
  MOV SI,4
  XOR DI,DI
  REP MOVSD
  RET
RTEstoreTexture ENDP


COMMENT \ 
  RTEkey Procedure
  - Returns true if specified key is currently pressed
\ 
RTEkey PROC USES DS,ScanCode:WORD
  MOV CX,@DATA
  MOV DS,CX
  MOV BX,ScanCode
  MOV AL,Key[BX]
  XOR AH,AH
  NEG AX
  RET  
RTEkey ENDP


COMMENT \ 
  RTEfindCol Procedure
  - Finds the color in specified palette, that best fits with given red,
    green and blue hue values
\ 
RTEfindCol PROC USES DS SI BX CX,PalSeg:WORD,Red:WORD,Green:WORD,Blue:WORD

LOCAL Temp:DWORD,BestDist:DWORD,BestCol:WORD

  MOV BestDist,128
  MOV BestCol,0
  MOV AX,PalSeg
  MOV DS,AX
  XOR SI,SI
  XOR CX,CX
  FNINIT
@@:
  MOV Temp,0
  LODSB
  MOV BX,Red
  SUB AL,BL
  MOV BL,AL
  IMUL BL
  CWDE
  ADD Temp,EAX
  LODSB
  MOV BX,Green
  SUB AL,BL
  MOV BL,AL
  IMUL BL
  CWDE
  ADD Temp,EAX
  LODSB
  MOV BX,Blue
  SUB AL,BL
  MOV BL,AL
  IMUL BL
  CWDE
  ADD Temp,EAX
  FILD Temp
  FSQRT
  FISTP Temp
  FWAIT
  MOV EDX,Temp
  .IF EDX < BestDist
    MOV BestCol,CX
    MOV BestDist,EDX
  .ENDIF
  INC CX
  CMP CX,256
  JB @B
  MOV AX,BestCol
  RET
RTEfindCol ENDP


COMMENT \ 
  RTEbuildLightMap Procedure
  - Creates a light table, with colors fading to specified one
\ 
RTEbuildLightMap PROC USES DS ES,PalSeg:WORD,FinalCol:WORD

LOCAL fRed:WORD,fGreen:WORD,fBlue:WORD,gRed:WORD,gGreen:WORD,gBlue:WORD

  MOV AX,FinalCol
  MOV HorizonCol,AL
  MOV AX,PalSeg
  MOV DS,AX
  MOV BX,@DATA
  MOV ES,BX
  MOV AX,FinalCol
  MOV CL,3
  MUL CL
  MOV SI,AX
  XOR AH,AH
  LODSB
  MOV gRed,AX
  LODSB
  MOV gGreen,AX
  LODSB
  MOV gBlue,AX
  XOR ECX,ECX
;  XOR CX,CX
  XOR BX,BX
BuildMap:
  XOR SI,SI
@@:
  XOR EDX,EDX
  LODSB
  CBW
  PUSH AX
  MOV DI,gRed
  SUB DI,AX
  MOV AX,DI
  SHL EAX,16
  MOV EDI,16
  IDIV EDI
  IMUL ECX
  SHR EAX,16
  POP DI
  ADD AX,DI
  MOV fRed,AX
  XOR EDX,EDX
  LODSB
  CBW
  PUSH AX
  MOV DI,gGreen
  SUB DI,AX
  MOV AX,DI
  SHL EAX,16
  MOV EDI,16
  IDIV EDI
  IMUL ECX
  SHR EAX,16
  POP DI
  ADD AX,DI
  MOV fGreen,AX
  XOR EDX,EDX
  LODSB
  CBW
  PUSH AX
  MOV DI,gBlue
  SUB DI,AX
  MOV AX,DI
  SHL EAX,16
  MOV EDI,16
  IDIV EDI
  IMUL ECX
  SHR EAX,16
  POP DI
  ADD AX,DI
  MOV fBlue,AX
  INVOKE RTEfindCol,PalSeg,fRed,fGreen,fBlue
  MOV DI,OFFSET LightMap
  ADD DI,BX
  MOV ES:[DI],AL
  INC BX
  CMP SI,768
  JB @B
  INC CX
  CMP CX,16
  JB BuildMap
  RET
RTEbuildLightMap ENDP


COMMENT \ 
  RTEfindDoor Procedure
  - Attempts to find an door in front of the player
  - Returns 0 if no doors are in sight, otherwise door id number
\ 
RTEfindDoor PROC USES ES,EgoX:WORD,EgoY:WORD,Angle:WORD

  MOV BX,TrigSeg
  MOV ES,BX
  MOV SI,Angle
  ADD SI,160
  .IF SI >= 1920
    SUB SI,1920
  .ENDIF
  SHL SI,4
  MOV EAX,400000h
  XOR EDX,EDX
  IDIV DWORD PTR ES:[SI+4]
  ADD AX,EgoX
  MOV BX,AX
  MOV EAX,400000h
  XOR EDX,EDX
  IDIV DWORD PTR ES:[SI]
  ADD AX,EgoY
  AND AX,0FFC0h
  SHR BX,6
  ADD BX,AX
  MOV CL,LevelMap[BX]
  XOR AX,AX
  TEST CL,080h
  JZ @F
  MOV AX,CX
  AND AX,07Fh
  INC AX
  RET
@@:
  MOV BX,EgoY
  AND BX,0FFC0h
  MOV AX,EgoX
  SHR AX,6
  ADD BX,AX
  MOV CL,LevelMap[BX]
  XOR AX,AX
  TEST CL,080h
  JZ @F
  MOV AX,CX
  AND AX,07Fh
  INC AX
@@:
  RET
RTEfindDoor ENDP


COMMENT \ 
  RTEopenDoor Procedure
  - Sets the "opening" flag to specified door, and keeps it opened for 'delay'
    cycles
\ 
RTEopenDoor PROC USES ES,DoorId:WORD,Delay:WORD,DoorSeg:WORD
  MOV AX,DoorSeg
  MOV ES,AX
  MOV SI,DoorId
  DEC SI
  SHL SI,3
  MOV BL,ES:[SI+1]
  .IF BL == 1
    RET
  .ELSEIF BL == 2
    RET
  .ELSEIF BL == 3
    .IF BYTE PTR ES:[SI] == 0
      RET
    .ENDIF
  .ENDIF
  MOV BYTE PTR ES:[SI+1],1
  MOV AX,Delay
  MOV WORD PTR ES:[SI+2],AX
  RET
RTEopenDoor ENDP


COMMENT \ 
  RTEupdateDoors Procedure
  - Animates opening/closing doors
\ 
RTEupdateDoors PROC USES ES FS,x:WORD,y:WORD,DoorSeg:WORD,ObjSeg:WORD

  MOV AX,DoorSeg
  MOV ES,AX
  MOV BX,ObjSeg
  MOV FS,BX
  XOR CX,CX
  XOR SI,SI
UpdateDoor:
  MOV AL,ES:[SI+1]
  .IF AL != 255
    XOR BH,BH
    MOV BL,ES:[SI+5]
    SHL BX,6
    MOV DL,ES:[SI+4]
    XOR DH,DH
    ADD BX,DX

    PUSH CX
    MOV CX,BX
    SHR BX,2
    AND CX,03h
    ADD CX,CX
    MOV DL,1
    SHL DL,CL
    TEST PlayerMap[BX],DL
    JZ @F
    XOR PlayerMap[BX],DL
    SHL DL,1
    OR PlayerMap[BX],DL
@@:
    POP CX

    MOV AH,CL
    OR AH,080h
    .IF AL == 1
      DEC BYTE PTR ES:[SI]
      MOV DL,ES:[SI]
      .IF DL == 0
        MOV BYTE PTR ES:[SI+1],2
      .ENDIF
    .ELSEIF AL == 2
      MOV DX,ES:[SI+2]
      .IF DX != 0FFFFh
        DEC DX
        MOV ES:[SI+2],DX
        .IF DX == 0
          MOV AX,x
          SHR AX,6
          .IF AL == BYTE PTR ES:[SI+4]
            MOV BX,y
            SHR BX,6
            .IF BL == BYTE PTR ES:[SI+5]
              INC WORD PTR ES:[SI+2]
              JMP NextDoor
            .ENDIF
          .ENDIF
          XOR BX,BX
CheckObjects:
          MOV AX,FS:[BX+2]
          SHR AX,6
          .IF AL == BYTE PTR ES:[SI+4]
            MOV AX,FS:[BX+4]
            SHR AX,6
            .IF AL == BYTE PTR ES:[SI+5]
              INC WORD PTR ES:[SI+2]
              JMP NextDoor
            .ENDIF
          .ENDIF
          ADD BX,16
          CMP BX,4096
          JB CheckObjects
          MOV BYTE PTR ES:[SI],0
          MOV BYTE PTR ES:[SI+1],3
        .ENDIF
      .ENDIF
    .ELSEIF AL == 3
      INC BYTE PTR ES:[SI]
      MOV DL,ES:[SI]
      .IF DL >= 63
        MOV BYTE PTR ES:[SI],63
        MOV BYTE PTR ES:[SI+1],0
      .ENDIF
    .ENDIF
  .ENDIF
NextDoor:
  ADD SI,8
  INC CX
  CMP CX,128
  JB UpdateDoor
  RET
RTEupdateDoors ENDP


COMMENT \ 
  RTEgetMap Procedure
  - Returns specified map block code.
\ 
RTEgetMap PROC USES ES,x:WORD,y:WORD,Wall:WORD,Floor:WORD,Ceiling:WORD
  MOV BX,y
  SHL BX,6
  ADD BX,x
  XOR AH,AH
  MOV AL,LevelMap[BX]
  MOV SI,Wall
  MOV [SI],AX
  MOV CL,LevelMap[4096+BX]
  MOV AL,CL
  AND AL,0Fh
  MOV SI,Floor
  MOV [SI],AX
  MOV AL,CL
  SHR AL,4
  MOV SI,Ceiling
  MOV [SI],AX
  RET
RTEgetMap ENDP


COMMENT \ 
  RTEsetMap Procedure
  - Sets specified map block code.
\ 
RTEsetMap PROC USES ES,x:WORD,y:WORD,Wall:WORD,Floor:WORD,Ceiling:WORD
  MOV BX,y
  SHL BX,6
  ADD BX,x
  MOV AX,Wall
  MOV LevelMap[BX],AL
  MOV AX,Floor
  AND AL,0Fh
  MOV CX,Ceiling
  AND CL,0Fh
  SHL CL,4
  OR AL,CL
  MOV LevelMap[4096+BX],AL
  RET
RTEsetMap ENDP


COMMENT \ 
  RTEwalk Procedure
  - Given a starting point and a destination point, moves starting point
    into the destination one, checking for walls/doors/objects collisions
    and fixing coordinates accordingly
\ 
RTEwalk PROC USES ES FS,xAddr:WORD,yAddr:WORD,DestX:WORD,DestY:WORD,DoorSeg:WORD,ObjSeg:WORD

LOCAL StartX:WORD,StartY:WORD

  MOV AX,DoorSeg
  MOV ES,AX
  MOV CX,ObjSeg
  MOV FS,CX
  MOV BX,xAddr
  MOV AX,[BX]
  MOV StartX,AX
  MOV BX,yAddr
  MOV AX,[BX]
  MOV StartY,AX
  XOR SI,SI
TrickObjects:
  .IF WORD PTR FS:[SI] != 0FFFFh
    .IF WORD PTR FS:[SI+8] & 1
      MOV BX,FS:[SI+4]
      AND BX,0FFC0h
      MOV AX,FS:[SI+2]
      SHR AX,6
      ADD BX,AX
      MOV LevelMap[BX],1
    .ENDIF
  .ENDIF
  ADD SI,16
  CMP SI,4096
  JB TrickObjects
  MOV DI,DestY
  AND DI,0FFC0h
  MOV AX,StartX
  .IF DestX < AX
    MOV BX,DestX
    SUB BX,DISTFIX
    SHR BX,6
    ADD BX,DI
    MOV DL,LevelMap[BX]
    .IF DL & 080h
      MOV SI,DX
      AND SI,07Fh
      SHL SI,3
      .IF BYTE PTR ES:[SI] < 16
        MOV AX,DestX
        MOV StartX,AX
      .ENDIF
    .ELSE
      .IF DL == 0
        MOV AX,DestX
        MOV StartX,AX
      .ENDIF
    .ENDIF
  .ELSE
    MOV BX,DestX
    ADD BX,DISTFIX
    SHR BX,6
    ADD BX,DI
    MOV DL,LevelMap[BX]
    .IF DL & 080h
      MOV SI,DX
      AND SI,07Fh
      SHL SI,3
      .IF BYTE PTR ES:[SI] < 16
        MOV AX,DestX
        MOV StartX,AX
      .ENDIF
    .ELSE
      .IF DL == 0
        MOV AX,DestX
        MOV StartX,AX
      .ENDIF
    .ENDIF
  .ENDIF
  MOV DI,DestX
  SHR DI,6
  MOV AX,StartY
  .IF DestY < AX
    MOV BX,DestY
    SUB BX,DISTFIX
    AND BX,0FFC0h
    ADD BX,DI
    MOV DL,LevelMap[BX]
    .IF DL & 080h
      MOV SI,DX
      AND SI,07Fh
      SHL SI,3
      .IF BYTE PTR ES:[SI] < 16
        MOV AX,DestY
        MOV StartY,AX
      .ENDIF
    .ELSE
      .IF DL == 0
        MOV AX,DestY
        MOV StartY,AX
      .ENDIF
    .ENDIF
  .ELSE
    MOV BX,DestY
    ADD BX,DISTFIX
    AND BX,0FFC0h
    ADD BX,DI
    MOV DL,LevelMap[BX]
    .IF DL & 080h
      MOV SI,DX
      AND SI,07Fh
      SHL SI,3
      .IF BYTE PTR ES:[SI] < 16
        MOV AX,DestY
        MOV StartY,AX
      .ENDIF
    .ELSE
      .IF DL == 0
        MOV AX,DestY
        MOV StartY,AX
      .ENDIF
    .ENDIF
  .ENDIF
  MOV BX,xAddr
  MOV AX,StartX
  MOV [BX],AX
  MOV BX,yAddr
  MOV AX,StartY
  MOV [BX],AX
  XOR SI,SI
UntrickObjects:
  .IF WORD PTR FS:[SI] != 0FFFFh
    .IF WORD PTR FS:[SI+8] & 1
      MOV BX,FS:[SI+4]
      AND BX,0FFC0h
      MOV AX,FS:[SI+2]
      SHR AX,6
      ADD BX,AX
      MOV LevelMap[BX],0
    .ENDIF
  .ENDIF
  ADD SI,16
  CMP SI,4096
  JB UntrickObjects
  RET
RTEwalk ENDP


COMMENT \ 
  RTEangle Procedure
  - Returns the angle between two given points. Angle ranges 0-1919
\ 
RTEangle PROC USES ES,x1:WORD,y1:WORD,x2:WORD,y2:WORD

LOCAL float:DWORD

  MOV float,960
  FNINIT
  FILD float
  MOV AX,y2
  SUB AX,y1
  CWDE
  MOV float,EAX
  FILD float
  MOV AX,x2
  SUB AX,x1
  CWDE
  MOV float,EAX
  FILD float
  FDIV
  FLD1
  FPATAN
  FLDPI
  FDIV
  FMUL
  FISTP float
  FWAIT
  MOV EAX,float
  ADD AX,480
  MOV BX,x1
  .IF x2 < BX
    ADD AX,960
  .ENDIF
  .IF AX >= 1920
    SUB AX,1920
  .ENDIF
  RET
RTEangle ENDP


COMMENT \ 
  RTEdrawMap Procedure
  - Draws player's level map
\ 
RTEdrawMap PROC USES ES,VideoSeg:WORD,x:WORD,y:WORD
  MOV AX,VideoSeg
  MOV ES,AX
  MOV AL,Settings.MapWallCol
  MOV AH,Settings.MapDoorCol
  MOV DI,y
  MOV DX,DI
  SHL DX,6
  SHL DI,8
  ADD DI,DX
  ADD DI,x
  XOR SI,SI
DrawMapY:
  MOV CH,64
  CMP y,0
  JL SkipMapLine
  CMP y,199
  JG EndDrawMap
DrawMapX:
  CMP x,0
  JL SkipMapPixel
  CMP x,319
  JG SkipMapPixel
  MOV BX,SI
  MOV CL,BL
  SHR BX,2
  MOV DL,1
  AND CL,03h
  ADD CL,CL
  SHL DL,CL
  MOV DH,DL
  SHL DH,1
  .IF PlayerMap[BX] & DH
    .IF PlayerMap[BX] & DL
      MOV DL,Settings.MapVisCol
      MOV ES:[DI],DL
    .ELSE
      MOV ES:[DI],AH
    .ENDIF
  .ELSEIF PlayerMap[BX] & DL
    MOV ES:[DI],AL
  .ELSE
    MOV DL,Settings.MapBackCol
    .IF DL != 0
      MOV ES:[DI],DL
    .ENDIF
  .ENDIF
SkipMapPixel:
  INC DI
  INC SI
  INC x
  DEC CH
  JNZ DrawMapX
  SUB SI,64
  SUB x,64
  SUB DI,64
SkipMapLine:
  ADD SI,64
  ADD DI,320
  INC y
  CMP SI,4096
  JB DrawMapY
EndDrawMap:
  RET
RTEdrawMap ENDP


COMMENT \ 
  RTEconsole Procedure
  - Fills a portion of the screen with a semi-transparent black box
\ 
RTEconsole PROC USES ES,VideoSeg:WORD,x1:WORD,y1:WORD,x2:WORD,y2:WORD
  MOV AX,VideoSeg
  MOV ES,AX
  MOV DI,y1
  MOV BX,DI
  SHL BX,6
  SHL DI,8
  ADD DI,BX
  ADD DI,x1
  MOV EBX,0FF00h
  MOV CX,x2
  SUB CX,x1
  INC CX
  MOV DX,320
  SUB DX,CX
  XOR ESI,ESI
DrawConsole:
  MOV EAX,EBX
@@:
  AND ES:[DI],AL
  ROR EAX,8
  INC DI
  DEC CX
  JNZ @B
  MOV CX,x2
  SUB CX,x1
  INC CX
  ADD DI,DX
  ROR EBX,16
  XCHG EBX,ESI
  INC y1
  MOV AX,y2
  CMP y1,AX
  JBE DrawConsole
  RET
RTEconsole ENDP


COMMENT \ 
  RTEprint Procedure
  - Prints a string at specified position, using current font
\ 
RTEprint PROC USES DS ES FS,VideoSeg:WORD,x:WORD,y:WORD,StrSeg:WORD,StrOff:WORD,Col:WORD
  MOV AX,VideoSeg
  MOV ES,AX
  MOV BX,StrSeg
  MOV FS,BX
  MOV SI,StrOff
DrawString:
  MOV AL,FS:[SI]
  .IF AL == 0
    RET
  .ENDIF
  MOV DI,y
  MOV BX,DI
  SHL BX,6
  SHL DI,8
  ADD DI,BX
  ADD DI,x
  MOV BL,AL
  XOR BH,BH
  MOV AL,CurFont[2048+BX]
  XOR AH,AH
  SHL BX,3
  MOV CH,CurFont[2304]
DrawChar:
  MOV DX,y
  CMP DX,Settings.y1
  JL SkipCharLine
  CMP DX,Settings.y2
  JG SkipCharLine
  MOV CL,128
DrawCharLine:
  .IF CurFont[BX] & CL
    MOV DX,x
    CMP DX,Settings.x1
    JL SkipCharPixel
    CMP DX,Settings.x2
    JG SkipCharPixel
    MOV DX,Col
    MOV ES:[DI],DL
  .ENDIF
SkipCharPixel:
  INC x
  INC DI
  SHR CL,1
  JNZ DrawCharLine
  SUB DI,8
  SUB x,8
SkipCharLine:
  ADD DI,320
  INC BX
  INC y
  DEC CH
  JNZ DrawChar
  MOV BL,CurFont[2304]
  XOR BH,BH
  SUB y,BX
  ADD x,AX
  INC SI
  JMP DrawString
RTEprint ENDP


COMMENT \ 
  RTEloadFont Procedure
  - Loads a DQB-compatible font in memory and sets it as current one
\ 
RTEsetFont PROC USES DS ES,FontSeg:WORD,FontOff:WORD
  MOV AX,@DATA
  MOV ES,AX
  MOV DI,OFFSET CurFont
  MOV BX,FontSeg
  MOV DS,BX
  MOV SI,FontOff
  MOV CX,576
  REP MOVSD
  MOVSB
  RET
RTEsetFont ENDP


COMMENT \ 
  RTEsetSky Procedure
  - Loads a new sky picture into XMS
\ 
RTEsetSky PROC USES DS ES,SkySeg:WORD,SkyOff:WORD
  MOV XMSmove.Len,64000
  MOV XMSmove.SourceHdl,0
  MOV BX,SkySeg
  SHL EBX,16
  MOV BX,SkyOff
  MOV XMSmove.SourceOff,EBX
  MOV DX,XMShdl
  MOV XMSmove.DestHdl,DX
  MOV XMSmove.DestOff,0
  MOV SI,OFFSET XMSmove
  MOV AH,0Bh
  CALL [XMSfunc]
  RET
RTEsetSky ENDP


COMMENT \ 
  RTEmouseInit Procedure
  - Returns true if mouse is available
  - Initializes mouse
\ 
RTEmouseInit PROC USES DS ES
  XOR AX,AX
  INT 033h
  TEST AX,AX
  JE @F
  MOV CX,31
  MOV DX,OFFSET MouseISR
  MOV AX,SEG MouseISR
  MOV ES,AX
  MOV AX,0Ch
  INT 033h
  MOV AX,0FFFFh
  RET
@@:
  XOR AX,AX
  RET
MouseISR:
  PUSH BP
  PUSH DS
  MOV AX,@DATA
  MOV DS,AX
  SHR CX,1
  MOV MouseX,CX
  MOV MouseY,DX
  MOV MouseBut,BL
  RET
RTEmouseInit ENDP


COMMENT \ 
  RTEmouseX Procedure
  - Returns current mouse x position
\ 
RTEmouseX PROC USES DS
  MOV AX,MouseX
  RET
RTEmouseX ENDP


COMMENT \ 
  RTEmouseY Procedure
  - Returns current mouse y position
\ 
RTEmouseY PROC USES DS
  MOV AX,MouseY
  RET
RTEmouseY ENDP


COMMENT \ 
  RTEmouseLB Procedure
  - Returns current mouse left button status
\ 
RTEmouseLB PROC USES DS
  XOR AH,AH
  TEST MouseBut,1
  SETNZ AL
  NEG AX
  RET
RTEmouseLB ENDP


COMMENT \ 
  RTEmouseRB Procedure
  - Returns current mouse left button status
\ 
RTEmouseRB PROC USES DS
  XOR AH,AH
  TEST MouseBut,2
  SETNZ AL
  NEG AX
  RET
RTEmouseRB ENDP


COMMENT \ 
  RTEmouseShow Procedure
  - Returns current mouse left button status
\ 
RTEmouseShow PROC USES DS
  MOV AX,1
  INT 033h
  RET
RTEmouseShow ENDP


COMMENT \ 
  RTEmouseHide Procedure
  - Returns current mouse left button status
\ 
RTEmouseHide PROC USES DS
  MOV AX,2
  INT 033h
  RET
RTEmouseHide ENDP


COMMENT \ 
  RTEsetMouseShape Procedure
  - Sets mouse shape and hotspot position
\ 
RTEsetMouseShape PROC USES DS,ShapeSeg:WORD,ShapeOff:WORD,HotX:WORD,HotY:WORD
  MOV BX,HotX
  SHL BX,1
  MOV CX,HotY
  MOV AX,ShapeSeg
  MOV ES,AX
  MOV DX,ShapeOff
  MOV AX,9
  INT 033h
  RET
RTEsetMouseShape ENDP


COMMENT \ 
  RTEsetMousePos Procedure
  - Sets mouse position
\ 
RTEsetMousePos PROC USES DS,NewX:WORD,NewY:WORD
  MOV CX,NewX
  MOV MouseX,CX
  SHL CX,1
  MOV DX,NewY
  MOV MouseY,DX
  MOV AX,04h
  INT 033h
  RET
RTEsetMousePos ENDP


COMMENT \ 
  RTEput Procedure
  - Draws a 64x64 sprite stored in XMS, scaling it with a specified factor
\ 
RTEput PROC USES DS ES,VideoSeg:WORD,SpriteId:WORD,x:WORD,y:WORD,Scale:WORD

LOCAL xa:WORD,ya:WORD

  MOV AX,VideoSeg
  MOV ES,AX
  MOV XMSmove.Len,4096
  MOV DX,XMShdl
  MOV XMSmove.SourceHdl,DX
  XOR EBX,EBX
  MOV BX,SpriteId
  SHL EBX,12
  ADD EBX,64000
  MOV XMSmove.SourceOff,EBX
  MOV XMSmove.DestHdl,0
  MOV BX,SEG SpriteBuf
  SHL EBX,16
  MOV BX,OFFSET SpriteBuf
  MOV XMSmove.DestOff,EBX
  MOV SI,OFFSET XMSmove
  MOV AH,0Bh
  CALL [XMSfunc]
  MOV xa,1
  MOV CX,Scale
  DEC CX
  MOV DX,64
  SHR DX,CL
  SHL xa,CL
  MOV AX,xa
  DEC AX
  SHL AX,6
  MOV ya,AX
  MOV CX,DX
  MOV DH,DL
  MOV SI,OFFSET SpriteBuf
  MOV DI,y
  MOV AX,DI
  SHL AX,6
  SHL DI,8
  ADD DI,AX
  ADD DI,x
PutY:
  MOV AX,y
  CMP AX,Settings.y1
  JL SkipLine
  CMP AX,Settings.y2
  JG EndPut
PutX:
  MOV AX,x
  CMP AX,Settings.x1
  JL @F
  CMP AX,Settings.x2
  JG @F
  MOV AL,[SI]
  OR AL,AL
  JZ @F
  MOV ES:[DI],AL
@@:
  INC DI
  ADD SI,xa
  INC x
  DEC DL
  JNZ PutX
  SUB DI,CX
  SUB x,CX
SkipLine:
  MOV DL,CL
  ADD DI,320
  INC y
  ADD SI,ya
  DEC DH
  JNZ PutY
EndPut:
  MOV OldTile,0FFh
  RET
RTEput ENDP


COMMENT \ 
  RTEsetView Procedure
  - Sets projection plane height 
\ 
RTEsetViewHeight PROC USES DS,View:WORD
  CMP View,30
  JGE @F
  MOV View,30
@@:
  CMP View,170
  JLE @F
  MOV View,170
@@:
  MOV AX,View
  MOV PlaneHeight,AX
  RET
RTEsetViewHeight ENDP


COMMENT \ 
  RTEsetHeight Procedure
  - Sets eye height
  - Updates floor/ceiling pixel distance lookup tables
\ 
RTEsetPlayerHeight PROC USES DS,Plane:WORD
  CMP Plane,1
  JGE @F
  MOV Plane,1
@@:
  CMP Plane,63
  JLE @F
  MOV Plane,63
@@:
  MOV AX,Plane
  MOV EyeHeight,AX
  MOV AX,64
  SUB AX,EyeHeight
  CWDE
  MOV ECX,18161873
  MUL ECX
  MOV EBX,EAX
  MOV ESI,1
@@:
  MOV EAX,EBX
  CDQ
  DIV ESI
  SHR EAX,16
  SHL ESI,1
  MOV CeilingDist[SI],AX
  SHR ESI,1
  INC ESI
  CMP ESI,200
  JB @B
  MOV AX,EyeHeight
  CWDE
  MOV ECX,18161873
  MUL ECX
  MOV EBX,EAX
  MOV ESI,1
@@:
  MOV EAX,EBX
  CDQ
  DIV ESI
  SHR EAX,16
  SHL ESI,1
  MOV FloorDist[SI],AX
  SHR ESI,1
  INC ESI
  CMP ESI,200
  JB @B
  RET
RTEsetPlayerHeight ENDP


END
