' RTE Demo program v1.0
' uses RTE v0.9
' by Enhanced Creations 1999

DEFINT A-Z
'$INCLUDE: 'RTE.BI'
'$DYNAMIC

DECLARE SUB InitDemo ()
DECLARE SUB cPrint (Text$, x, y)
DECLARE SUB AddMessage (Text$)
DECLARE SUB HandleConsole ()
DECLARE SUB CommandHelp (What$)
DECLARE SUB QuitDemo ()

d& = SETMEM(-83000)
DIM SHARED buf%(4095), B AS STRING * 1, wall%(2049), Video%(31999), Pal%(383)
DIM SHARED x AS INTEGER, y AS INTEGER, a AS INTEGER
DIM SHARED StartTimer AS DOUBLE, FinalTimer AS DOUBLE, TypeDelay AS DOUBLE
DIM SHARED frames AS LONG, Door(127) AS RTEdoor, Object(255) AS RTEobject
DIM SHARED Settings AS RTEsettings, Font AS STRING * 2305, col, player, red
DIM SHARED cMessage$(7), cOffset, cOffsetAdd, map, FPS, NumSprites, solid
DIM SHARED fog, keyshift AS STRING * 128, keynoshift AS STRING * 128
DIM SHARED keymap AS STRING * 128, cmd$, LastCmd$

InitDemo

cOffset = 0: cOffsetAdd = 4
map = 1: FPS = 0

x = 2079: y = 2079: a = 0
frames = 0: speed = 0: stepspeed = 0
plane = 32: eye = 100
RTEsetPlayerHeight plane
RTEsetMousePos 160, 100

TypeDelay = 0
StartTimer = TIMER
DO
  frames = frames + 1: FinalTimer = TIMER
 
  ' Draws a new frame onto the offscreen buffer
  RTEdoFrame VARSEG(Video%(0)), x, y, a, VARSEG(Door(0)), VARSEG(Object(0))
 
  IF map <> 0 THEN
    ' Draws player's visited level areas map
    RTEdrawMap VARSEG(Video%(0)), 2, 2
    mx = 2 + (x \ 64)
    my = 2 + (y \ 64)
    DEF SEG = VARSEG(Video%(0))
    POKE (my * 320) + mx, player
    DEF SEG
  END IF
 

  IF FPS THEN
    s$ = "FPS:" + STR$(INT(frames / (FinalTimer - StartTimer - TypeDelay))) + CHR$(0)
    RTEprint VARSEG(Video%(0)), 260, 4, VARSEG(s$), SADD(s$), red
  END IF

  HandleConsole

  ' Copies contents of buffer to screen (double buffering)
  RTEtoScreen VARSEG(Video%(0))
 
  ' Updates doors status
  RTEupdateDoors x, y, VARSEG(Door(0)), VARSEG(Object(0))

  IF speed > 0 THEN speed = speed - 2
  IF speed < 0 THEN speed = speed + 2
  IF stepspeed > 0 THEN stepspeed = stepspeed - 2
  IF plane < 32 THEN nplane = plane + 4
  IF plane > 32 THEN nplane = plane - 4

  ' Processes player input
 
  IF RTEkey(16) THEN nplane = plane + 8
  IF RTEkey(18) THEN nplane = plane - 8
 
  IF RTEkey(30) THEN eye = eye + 10
  IF RTEkey(44) THEN eye = eye - 10
 
  eye = RTEmouseY

  ax = RTEmouseX
  IF ax <> 160 THEN
    RTEsetMousePos 160, RTEmouseY
    a = a + (ax - 160)
    IF a >= 1920 THEN a = a - 1920
    IF a < 0 THEN a = a + 1920
  END IF

  IF nplane < 8 THEN nplane = 8
  IF nplane > 56 THEN nplane = 56
  RTEsetViewHeight eye
  IF nplane <> plane THEN plane = nplane: RTEsetPlayerHeight plane

  IF RTEkey(17) THEN
    speed = speed + 8
    IF speed > 16 THEN speed = 16
  END IF

  IF RTEkey(31) THEN
    speed = speed - 8
    IF speed < -16 THEN speed = -16
  END IF
 
  nx = x + (COS(a / 306 - 1.57) * speed)
  ny = y + (SIN(a / 306 - 1.57) * speed)

  IF RTEkey(30) THEN
    IF RTEkey(56) THEN
      stepspeed = stepspeed + 6
      IF stepspeed > 12 THEN stepspeed = 12
      sidea = a - 480
      IF sidea < 0 THEN sidea = sidea + 1920
    ELSE
      a = a - 20
      IF a < 0 THEN a = a + 1920
    END IF
  END IF
 
  IF RTEkey(32) THEN
    IF RTEkey(56) THEN
      stepspeed = stepspeed + 6
      IF stepspeed > 12 THEN stepspeed = 12
      sidea = a + 480
      IF sidea > 1919 THEN sidea = sidea - 1920
    ELSE
      a = a + 20
      IF a >= 1920 THEN a = a - 1920
    END IF
  END IF
 
  nx = nx + (COS(sidea / 306 - 1.57) * stepspeed)
  ny = ny + (SIN(sidea / 306 - 1.57) * stepspeed)

  IF RTEkey(KEYSPACE) THEN
    ' Check if a door is in front of the player
    d = RTEfindDoor(x, y, a)

    ' If a door was found, open it
    IF d THEN RTEopenDoor d, 100, VARSEG(Door(0))
  END IF

  IF RTEkey(KEYESC) THEN
    WHILE RTEkey(KEYESC): WEND
    IF cOffsetAdd > 0 THEN
      cOffsetAdd = -4
    ELSEIF cOffsetAdd < 0 THEN
      cOffsetAdd = 4
    END IF
    IF cOffset = 0 THEN cOffsetAdd = 4
    IF cOffset = 64 THEN cOffsetAdd = -4
  END IF

  ' Moves player from (x,y) to (nx,ny), fixing coordinates to avoid
  ' collisions with doors or solid objects
  RTEwalk x, y, nx, ny, VARSEG(Door(0)), VARSEG(Object(0))

LOOP


' Default key maps (shift off/shift on)
DATA " 1234567890-=  qwertyuiop[]  asdfghjkl;'` \zxcvbnm,./ *               789-456+1230.                                             "
DATA " !@#$%^&*()_+  QWERTYUIOP{}  ASDFGHJKL:c~ |ZXCVBNM<>?                    - 5 +                                                  "


' 64*64 map wall data:
DATA 1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,141,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,132,6,133,7,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,0,0,0,135,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,0,0,0,137,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,138,6,139,7,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,140,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,0,0,0,0,0,0,4,0,3,2,4,2,4,2,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,0,0,0,3,2,2,2,2,2,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,0,3,0,0,0,0,0,0,3,0,7,0,4,6,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,3,0,0,0,0,0,0,3,0,7,0,0,6,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,2,2,2,2,2,2,2,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,1,1,129,1,1,1,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,4,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,6,0,7,0,17,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,131,0,130,0,128,0,0,0,0,0,0,0,0,0,4,0,3,0,3,0,4,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,6,0,7,0,18,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,0,0,0,0,0,0,0,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,0,0,0,0,0,0,0,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

' Floor/ceiling level data
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,245,245,245,245,245,245,245,245,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

REM $STATIC
SUB AddMessage (Text$)
'
FOR i = 0 TO 6: cMessage$(i) = cMessage$(i + 1): NEXT
cMessage$(7) = Text$

END SUB

SUB CommandHelp (What$)
'
SELECT CASE What$
CASE "FPS"
  AddMessage "Command: FPS    Alias: none"
  AddMessage ""
  AddMessage "Toggles on and off a frames per second"
  AddMessage "counter in the upper-right corner of the"
  AddMessage "screen; this shows the average FPS rate"
  AddMessage "from the start of the demo."
  AddMessage ""
CASE "MAP", "M"
  AddMessage "Command: MAP    Alias: M"
  AddMessage ""
  AddMessage "Shows the player's visited areas map on"
  AddMessage "the upper-left corner of the screen. Send"
  AddMessage "this command several times to cycle through"
  AddMessage "no map/transparent map/solid map."
  AddMessage ""
CASE "QUIT", "EXIT", "Q"
  AddMessage "Command: QUIT    Aliases: Q, EXIT"
  AddMessage ""
  AddMessage "Istantly quits the demo program."
  AddMessage ""
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "FLOOR", "F"
  AddMessage "Command: FLOOR    Alias: F"
  AddMessage ""
  AddMessage "Toggles on/off floor texturing; you can"
  AddMessage "gain more FPS by turning floor off."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "CEILING", "C"
  AddMessage "Command: CEILING    Alias: C"
  AddMessage ""
  AddMessage "Toggles on/off ceiling texturing; you can"
  AddMessage "gain more FPS by turning ceiling off."
  AddMessage "When ceiling is off, you'll be able to see"
  AddMessage "the whole sky (if on)"
  AddMessage ""
CASE "LIGHT", "L"
  AddMessage "Command: LIGHT    Alias: L"
  AddMessage ""
  AddMessage "Toggles on/off light-shading; normally you"
  AddMessage "should not gain more FPS by disabling this."
  AddMessage "Light-shading must be on to see the fog"
  AddMessage "effect, if it is active"
  AddMessage ""
CASE "VSYNC", "V"
  AddMessage "Command: VSYNC    Alias: V"
  AddMessage ""
  AddMessage "Toggles on/off vertical sync. If on, it will"
  AddMessage "slow down the engine quite a bit, but it's"
  AddMessage "useful on old machines to avoid flickering."
  AddMessage "You can turn this off on modern computers."
  AddMessage ""
CASE "+SIGHT", "+S"
  AddMessage "Command: +SIGHT    Alias: +S"
  AddMessage ""
  AddMessage "Increases sight range; sight is affected"
  AddMessage "only if light-shading is on."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "-SIGHT", "-S"
  AddMessage "Command: -SIGHT    Alias: -S"
  AddMessage ""
  AddMessage "Decreases sight range; sight is affected"
  AddMessage "only if light-shading is on."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "HELP", "H"
  AddMessage "Command: HELP    Alias: H"
  AddMessage ""
  AddMessage "Shows a list of all known console commands."
  AddMessage ""
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "VERSION", "VER", "V"
  AddMessage "Command: VERSION    Alias: VER, V"
  AddMessage ""
  AddMessage "Shows demo version and RTE version numbers."
  AddMessage ""
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "SOLIDOBJECTS", "SO"
  AddMessage "Command: SOLIDOBJECTS    Alias: SO"
  AddMessage ""
  AddMessage "Toggles on/off solid objects switch. When on"
  AddMessage "all the objects that will be successfully"
  AddMessage "created with the +OBJECT command, will be"
  AddMessage "unpassable by player."
  AddMessage ""
CASE "+OBJECT", "+O"
  AddMessage "Command: +OBJECT    Alias: +O"
  AddMessage ""
  AddMessage "Adds a new object and places it randomly on"
  AddMessage "the level map. Up to 256 objects are allowed"
  AddMessage "at once."
  AddMessage ""
  AddMessage ""
CASE "-OBJECT", "-O"
  AddMessage "Command: -OBJECT    Alias: -O"
  AddMessage ""
  AddMessage "Removes from level map the last object that"
  AddMessage "was created."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "TAKESHOT"
  AddMessage "Command: TAKESHOT    Alias: none"
  AddMessage ""
  AddMessage "Saves a screenshot in bsave file format"
  AddMessage "with attached palette, into RTESHOT.BSV"
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "+FOG"
  AddMessage "Command: +FOG    Alias: +F"
  AddMessage ""
  AddMessage "Increases fog intensity; this will be"
  AddMessage "affected only if light-shading is on."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "-FOG"
  AddMessage "Command: -FOG    Alias: -F"
  AddMessage ""
  AddMessage "Decreases fog intensity; this will be"
  AddMessage "affected only if light-shading is on."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE "SKY"
  AddMessage "Command: SKY    Alias: none"
  AddMessage ""
  AddMessage "Turns background scrolling sky on/off."
  AddMessage "On modern computers, turning sky off"
  AddMessage "should not affect the FPS rate too much."
  AddMessage ""
  AddMessage ""
CASE "INFO", "I"
  AddMessage "Command: INFO    Alias: I"
  AddMessage ""
  AddMessage "Shows some info on current player's"
  AddMessage "position and view angle, engine"
  AddMessage "settings and more."
  AddMessage ""
  AddMessage ""
CASE "RESET"
  AddMessage "Command: RESET    Alias: none"
  AddMessage ""
  AddMessage "Resets all the engine settings to their"
  AddMessage "default values (as at demo startup)."
  AddMessage ""
  AddMessage ""
  AddMessage ""
CASE ELSE
  AddMessage "Cannot display help on " + CHR$(34) + What$ + CHR$(34) + ";"
  AddMessage "Command is unknown"
END SELECT
END SUB

SUB cPrint (Text$, x, y)
'
t$ = Text$ + CHR$(0)
RTEprint VARSEG(Video%(0)), x, y, VARSEG(t$), SADD(t$), col

END SUB

SUB HandleConsole
'
ConsoleDelay# = TIMER
cOffset = cOffset + cOffsetAdd
IF cOffset = 0 THEN cOffsetAdd = 0: EXIT SUB
IF cOffset = 64 THEN cOffsetAdd = 0
IF cOffset <> 0 THEN
  RTEconsole VARSEG(Video%(0)), 0, 0, 319, cOffset
  cMessage$(7) = "#" + cmd$ + "_"
  FOR i = 8 TO 1 STEP -1
    cPrint cMessage$(8 - i), 5, cOffset - (i * 8)
  NEXT i
  IF cOffset = 64 THEN
    IF RTEkey(KEYESC) THEN
      WHILE RTEkey(KEYESC): WEND
      cOffsetAdd = -4
    ELSE
      FOR i = 2 TO 127
        IF RTEkey(54) OR RTEkey(42) THEN keymap = keyshift ELSE keymap = keynoshift
        IF i <> 54 AND i <> 42 AND i <> 56 AND i <> KEYUP AND i <> KEYDOWN AND i <> KEYLEFT AND i <> KEYRIGHT THEN
          IF RTEkey(i) THEN
            WHILE RTEkey(i): WEND
            IF i = 14 THEN
              IF cmd$ <> "" THEN cmd$ = LEFT$(cmd$, LEN(cmd$) - 1)
            ELSEIF i <> KEYENTER THEN
              cmd$ = cmd$ + MID$(keymap, i, 1)
            ELSE
              IF RTRIM$(cmd$) = "" THEN cmd$ = LastCmd$
              cMessage$(7) = "#" + cmd$
              IF LEFT$(RTRIM$(LTRIM$(cmd$)), 2) = "? " THEN
                cmd$ = RTRIM$(LTRIM$(cmd$))
                CommandHelp RIGHT$(cmd$, LEN(cmd$) - 2)
              ELSE
                SELECT CASE RTRIM$(LTRIM$(UCASE$(cmd$)))
                CASE ""
                CASE "HELP", "H"
                  AddMessage "Known commands (not in order):"
                  AddMessage "FPS, MAP, QUIT, EXIT, FLOOR, CEILING, LIGHT,"
                  AddMessage "VSYNC, +SIGHT, -SIGHT, HELP, VERSION, VER,"
                  AddMessage "SOLIDOBJECTS, +OBJECT, -OBJECT, TAKESHOT,"
                  AddMessage "+FOG, -FOG, SKY, INFO, RESET."
                  AddMessage ""
                  AddMessage "Type '? CMD' for details on command CMD"
                CASE "RESET"
                  Settings.Detail = 0
                  Settings.Detail = FLOOR OR CEILING OR SHADING OR VSYNC OR SKY
                  Settings.Sight = 1024
                  RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  map = 0: fog = 0: solid = 0
                  FOR ii = 1 TO 255: Object(i).Texture = -1: NEXT ii
                  Object(0).Texture = 8
                  Object(0).x = 32 + 64 * 10
                  Object(0).y = 32 + 64 * 30
                  Object(0).Flags = 0
                  RTEbuildLightMap VARSEG(Pal%(0)), RTEfindCol(VARSEG(Pal%(0)), 0, 0, 0)
                  AddMessage "Engine settings have been reset to default"
                CASE "FPS"
                  FPS = FPS XOR 1
                  IF FPS THEN s$ = "on" ELSE s$ = "off"
                  AddMessage "Average FPS counter is now " + s$
                CASE "MAP", "M"
                  map = (map + 1) MOD 3
                  IF map = 1 THEN Settings.MapBackColor = 0: RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  IF map = 2 THEN Settings.MapBackColor = RTEfindCol(VARSEG(Pal%(0)), 0, 16, 0): RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  SELECT CASE map
                  CASE 0: AddMessage "Player map disabled"
                  CASE 1: AddMessage "Transparent player map enabled"
                  CASE 2: AddMessage "Solid player map enabled"
                  END SELECT
                CASE "+FOG", "+F"
                  IF fog < 50 THEN
                    fog = fog + 5
                    RTEbuildLightMap VARSEG(Pal%(0)), RTEfindCol(VARSEG(Pal%(0)), fog, fog, fog)
                    AddMessage "Fog intensity increased"
                  ELSE
                    AddMessage "Fog intensity already at maximum"
                  END IF
                CASE "-FOG", "-F"
                  IF fog > 0 THEN
                    fog = fog - 5
                    RTEbuildLightMap VARSEG(Pal%(0)), RTEfindCol(VARSEG(Pal%(0)), fog, fog, fog)
                    IF fog = 0 THEN
                      AddMessage "Fog is now off"
                    ELSE
                      AddMessage "Fog intensity decreased"
                    END IF
                  ELSE
                    AddMessage "Fog intensity already at minimum"
                  END IF
                CASE "QUIT", "Q", "EXIT"
                  QuitDemo
                CASE "+SIGHT", "+S"
                  IF Settings.Sight < 16384 THEN
                    Settings.Sight = Settings.Sight * 2
                    RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                    AddMessage "Sight range increased"
                  ELSE
                    AddMessage "Sight range already at maximum"
                  END IF
                CASE "-SIGHT", "-S"
                  IF Settings.Sight > 128 THEN
                    Settings.Sight = Settings.Sight \ 2
                    RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                    AddMessage "Sight range decreased"
                  ELSE
                    AddMessage "Sight range already at minimum"
                  END IF
                CASE "FLOOR", "F"
                  Settings.Detail = Settings.Detail XOR FLOOR
                  RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  IF Settings.Detail AND FLOOR THEN s$ = "on" ELSE s$ = "off"
                  AddMessage "Floor texturing is now " + s$
                CASE "CEILING", "C"
                  Settings.Detail = Settings.Detail XOR CEILING
                  RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  IF Settings.Detail AND CEILING THEN s$ = "on" ELSE s$ = "off"
                  AddMessage "Ceiling texturing is now " + s$
                CASE "VSYNC", "V"
                  Settings.Detail = Settings.Detail XOR VSYNC
                  RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  IF Settings.Detail AND VSYNC THEN s$ = "on" ELSE s$ = "off"
                  AddMessage "Vertical sync is now " + s$
                CASE "LIGHT", "L"
                  Settings.Detail = Settings.Detail XOR SHADING
                  RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  IF Settings.Detail AND SHADING THEN s$ = "on" ELSE s$ = "off"
                  AddMessage "Light shading is now " + s$
                CASE "SKY"
                  Settings.Detail = Settings.Detail XOR SKY
                  RTEsetOptions VARSEG(Settings), VARPTR(Settings)
                  IF Settings.Detail AND SKY THEN s$ = "on" ELSE s$ = "off"
                  AddMessage "Sky is now " + s$
                CASE "SOLIDOBJECTS", "SO"
                  solid = solid XOR 1
                  IF solid THEN s$ = "solid" ELSE s$ = "passable"
                  AddMessage "New objects will now be " + s$
                CASE "+OBJECT", "+O"
                  IF NumSprites < 256 THEN
                    Object(NumSprites).Texture = INT(RND * 8)
                    DO
                      RANDOMIZE TIMER
                      ox = INT(RND * 64)
                      oy = INT(RND * 64)
                      RTEgetMap ox, oy, block, dummy, dummy
                      IF block = 0 THEN EXIT DO
                    LOOP
                    Object(NumSprites).x = ox * 64 + 32
                    Object(NumSprites).y = oy * 64 + 32
                    Object(NumSprites).Flags = solid
                    NumSprites = NumSprites + 1
                    AddMessage "New object added (now" + STR$(NumSprites) + ")"
                  ELSE
                    AddMessage "Cannot handle more than 256 objects!"
                  END IF
                CASE "-OBJECT", "-O"
                  IF NumSprites > 0 THEN
                    NumSprites = NumSprites - 1
                    Object(NumSprites).Texture = -1
                    AddMessage "One object removed (now" + STR$(NumSprites) + ")"
                  ELSE
                    AddMessage "No objects to remove!"
                  END IF
                CASE "TAKESHOT"
                  RTEdoFrame VARSEG(Video%(0)), x, y, a, VARSEG(Door(0)), VARSEG(Object(0))
                  RTEtoScreen VARSEG(Video%(0))
                  DEF SEG = &HA000
                  BSAVE "RTESHOT.BSV", 0, 64000
                  OPEN "DEMOTEXT.BSV" FOR BINARY AS #1
                  OPEN "RTESHOT.BSV" FOR BINARY AS #2
                  SEEK #1, 64008: SEEK #2, 64008
                  FOR ii = 0 TO 767: GET #1, , B: PUT #2, , B: NEXT ii
                  CLOSE #1: CLOSE #2
                  AddMessage "Screenshot saved as RTESHOT.BSV"
                CASE "INFO", "I"
                  AddMessage "Last settings:"
                  AddMessage "X:" + STR$(x) + "  Y:" + STR$(y) + "  Angle:" + STR$(INT(a / 5.333333)) + " degrees"
                  s$ = ""
                  IF Settings.Detail AND FLOOR THEN s$ = "floor"
                  IF Settings.Detail AND CEILING THEN s$ = s$ + ", ceiling"
                  IF Settings.Detail AND SKY THEN s$ = s$ + ", sky"
                  IF Settings.Detail AND SHADING THEN s$ = s$ + ", light"
                  IF Settings.Detail AND VSYNC THEN s$ = s$ + ", vsync"
                  IF s$ = "" THEN s$ = "all off"
                  IF LEFT$(s$, 1) = "," THEN s$ = RIGHT$(s$, LEN(s$) - 2)
                  AddMessage "Details on: " + s$
                  AddMessage "Sight:" + STR$(Settings.Sight) + "  Fog:" + STR$(fog) + "  Object(s):" + STR$(NumSprites)
                  AddMessage "Average FPS:" + STR$(frames / (FinalTimer - StartTimer - TypeDelay))
                  AddMessage "Free memory:" + STR$(FRE(-1)) + " bytes"
                  AddMessage ""
                CASE "VER", "VERSION", "V"
                  AddMessage ""
                  AddMessage "----------------------------------------"
                  AddMessage "RT Engine version 0.9"
                  AddMessage "Demo program version 1.0"
                  AddMessage "by Enhanced Creations 1999"
                  AddMessage "----------------------------------------"
                  AddMessage ""
                CASE ELSE
                  AddMessage "Unknown command " + CHR$(34) + LTRIM$(RTRIM$(cmd$)) + CHR$(34)
                  AddMessage "Type 'HELP' for a list of known commands"
                END SELECT
              END IF
              AddMessage "#_"
              LastCmd$ = cmd$
              cmd$ = ""
            END IF
          END IF
        END IF
      NEXT i
    END IF
  END IF
END IF
TypeDelay = TypeDelay + TIMER - ConsoleDelay#

END SUB

SUB InitDemo
'
READ keynoshift, keyshift

Ofs% = 0
DEF SEG = VARSEG(buf%(0))
FOR readmap% = 1 TO 8192
   READ mapentry%
   POKE Ofs%, mapentry%
   Ofs% = Ofs% + 1
NEXT readmap%

IF NOT RTEmouseInit THEN
  PRINT "This program requires a mouse to run!"
  END
END IF

'r = RTEinit(2000)
r = RTEinit(10, 2000)
IF r <> 0 THEN
  PRINT "RT Engine failed to initialize: ": PRINT SPC(2);
  SELECT CASE r
    CASE 1: PRINT "extended memory manager not found (HIMEM.SYS)"
    CASE 2: PRINT "old extended memory manager not supported"
    CASE 3: PRINT "not enough free XMS memory available"
    CASE 4: PRINT "error allocating XMS memory"
    CASE 5: PRINT "error allocating base memory"
    CASE 6: PRINT "error loading resource file (RESOURCE.RTE)"
    CASE ELSE: PRINT "unknown error"
  END SELECT
  END
END IF

OPEN "HITECH.FNT" FOR BINARY AS #1
GET #1, , Font: CLOSE #1
RTEsetFont VARSEG(Font), VARPTR(Font)

RTEloadMap VARSEG(buf%(0)), VARSEG(Door(0)), VARSEG(Object(0))

SCREEN 13
OUT &H3C8, 0
FOR i = 0 TO 767: OUT &H3C9, 0: NEXT i

DEF SEG = &HA000
BLOAD "DEMOTEXT.BSV", 0
OPEN "DEMOTEXT.BSV" FOR BINARY AS #1
SEEK #1, 64008
DEF SEG = VARSEG(Pal%(0))
FOR i = 0 TO 767
  GET #1, , B
  POKE i, ASC(B)
NEXT i
CLOSE #1
DEF SEG

Settings.Detail = FLOOR OR CEILING OR VSYNC OR SHADING OR 16
Settings.FloorColor = RTEfindCol(VARSEG(Pal%(0)), 12, 12, 12)
Settings.CeilingColor = RTEfindCol(VARSEG(Pal%(0)), 0, 44, 34)
Settings.MapBackColor = 0
Settings.MapWallColor = RTEfindCol(VARSEG(Pal%(0)), 63, 0, 0)
Settings.MapDoorColor = RTEfindCol(VARSEG(Pal%(0)), 63, 63, 0)
Settings.MapVisitedColor = RTEfindCol(VARSEG(Pal%(0)), 32, 0, 0)
Settings.Sight = 1024
Settings.ClipX1 = 0
Settings.ClipY1 = 0
Settings.ClipX2 = 319
Settings.ClipY2 = 199

RTEsetOptions VARSEG(Settings), VARPTR(Settings)

fog = 0
RTEbuildLightMap VARSEG(Pal%(0)), RTEfindCol(VARSEG(Pal%(0)), fog, fog, fog)

GET (0, 0)-(63, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 4
RTEstoreTexture VARSEG(wall%(0)), 4
GET (64, 0)-(127, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 1
RTEstoreTexture VARSEG(wall%(0)), 1
GET (128, 0)-(191, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 6
RTEstoreTexture VARSEG(wall%(0)), 6
GET (192, 0)-(255, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 5
RTEstoreTexture VARSEG(wall%(0)), 5
GET (256, 0)-(319, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 0
RTEstoreTexture VARSEG(wall%(0)), 0
GET (0, 64)-(63, 127), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 2
RTEstoreTexture VARSEG(wall%(0)), 2
GET (64, 64)-(127, 127), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 3
RTEstoreTexture VARSEG(wall%(0)), 3
GET (128, 64)-(191, 127), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 8
RTEstoreTexture VARSEG(wall%(0)), 8
CLS
FOR i = 0 TO 3
  LINE (7 + (i * 16), 0)-(7 + (i * 16), 63), RTEfindCol(VARSEG(Pal%(0)), 48, 48, 48)
  LINE (8 + (i * 16), 0)-(8 + (i * 16), 63), RTEfindCol(VARSEG(Pal%(0)), 32, 32, 32)
  LINE (9 + (i * 16), 0)-(9 + (i * 16), 63), RTEfindCol(VARSEG(Pal%(0)), 22, 22, 22)
NEXT i
GET (0, 0)-(63, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 7
RTEstoreTexture VARSEG(wall%(0)), 7


CLS
COLOR RTEfindCol(VARSEG(Pal%(0)), 63, 0, 0)
LOCATE 3, 1: PRINT "RTengine"
COLOR RTEfindCol(VARSEG(Pal%(0)), 63, 63, 63)
LOCATE 4, 1: PRINT "  DEMO"
COLOR RTEfindCol(VARSEG(Pal%(0)), 63, 63, 0)
LOCATE 5, 1: PRINT " I am a"
LOCATE 6, 1: PRINT "Sprite!!"
c = RTEfindCol(VARSEG(Pal%(0)), 63, 0, 63)
LINE (0, 14)-(63, 49), c, B
LINE (30, 49)-(33, 63), c, BF
GET (0, 0)-(63, 63), wall%(0)
RTEstoreSprite VARSEG(wall%(0)), 8
RTEstoreTexture VARSEG(wall%(0)), 8


DEF SEG = VARSEG(Door(0))
FOR i = 128 TO 140
  POKE ((i - 128) * 8) + 6, 7
NEXT i
POKE 6 + 8, 2
POKE 6 + 96, 4

CLS
DEF SEG

solid = 0
NumSprites = 1
Object(0).Texture = 8
Object(0).x = 32 + 64 * 10
Object(0).y = 32 + 64 * 30
Object(0).Flags = solid

DEF SEG = &HA000: BLOAD "DEMOSKY.BSV", 0
RTEsetSky &HA000, 0


CLS

OUT &H3C8, 0
DEF SEG = VARSEG(Pal%(0))
FOR i = 0 TO 767: OUT &H3C9, PEEK(i): NEXT i
DEF SEG

red = RTEfindCol(VARSEG(Pal%(0)), 63, 0, 0)
col = RTEfindCol(VARSEG(Pal%(0)), 43, 43, 43)
player = RTEfindCol(VARSEG(Pal%(0)), 63, 63, 63)

AddMessage "RT Engine (RTE) Demo v1.0"
AddMessage "by Enhanced Creations 1999"
AddMessage LTRIM$(STR$(FRE(-1))) + " bytes free"
AddMessage ""
AddMessage "Welcome to the RTE demo console!"
AddMessage "Press ESC to toggle console on/off"
AddMessage "Type 'HELP' for a list of known commands"
AddMessage ">_"
cmd$ = ""



END SUB

SUB QuitDemo
'
SCREEN 0: WIDTH 80
mem& = FRE(-1)
RTEclose
d& = SETMEM(33000)
COLOR 15, 1
LOCATE 1, 1: PRINT SPACE$(80): LOCATE 1, 1
PRINT " RTE Demo v1.0, currently using RTEngine v0.9  by Enhanced Creations 1999"
COLOR 7, 0
PRINT
PRINT "Last engine settings and performances:"
PRINT
PRINT "Player was at:  ";
PRINT USING "x:####  y:####  angle:###"; x; y; (a / 5.333333)
PRINT "Floor texturing: ";
IF Settings.Detail AND FLOOR THEN PRINT "on" ELSE PRINT "off"
PRINT "Ceiling texturing: ";
IF Settings.Detail AND CEILING THEN PRINT "on" ELSE PRINT "off"
PRINT "Light shading: ";
IF Settings.Detail AND SHADING THEN PRINT "on" ELSE PRINT "off"
PRINT "Vertical sync: ";
IF Settings.Detail AND VSYNC THEN PRINT "on" ELSE PRINT "off"
PRINT "Sky: ";
IF Settings.Detail AND SKY THEN PRINT "on" ELSE PRINT "off"
PRINT "Sight:" + STR$(Settings.Sight)
PRINT "Fog level:";
IF fog = 0 THEN PRINT " fog disabled" ELSE PRINT STR$(fog / 5) + "/10"
PRINT "Number of objects on level:" + STR$(NumSprites)
PRINT STRING$(50, "-")
PRINT "Average frames per second:" + STR$(frames / (FinalTimer - StartTimer - TypeDelay))
PRINT "Free memory:" + STR$(mem&)
PRINT
PRINT "Write your comments to the wwwboard at the Enhanced Creations homepage:"
COLOR 14: PRINT "http://ec.quickbasic.com": COLOR 7
PRINT "or send an email directly to the authors:"
COLOR 14
PRINT "Angelo Mottola:   angelillo@bigfoot.com"
PRINT "Petter Holmberg:  petter.holmberg@usa.net"
COLOR 7
PRINT "Stay tuned for the final release of RTE!!"
END

END SUB

