.386
.model flat, stdcall
option casemap: none

include \masm32\include\windows.inc
include \masm32\include\masm32.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\macros\macros.asm
include tinyptc.inc

includelib \masm32\lib\masm32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\uuid.lib
includelib \masm32\lib\msvcrt.lib
includelib tinyptc.lib

.data

    dwWidth             dd 320
    dwHeight            dd 240
    szTitle             db "ASMCast by Chris Adams (Lithium)", 0
    szWelcomeTitle      db "Welcome to ASMCast...", 0
    szWelcomeText       db "The MASM32 Raycaster!", 0
    szGoodbyeTitle      db "Seeya...", 0
    szGoodbyeText       db "Later!", 0

    dwERRORALLOC        dd 0
    dwERRORPTC          dd 1
    dwERRORMAPFILE      dd 2
    dwERRORLUTFILE      dd 3
    szError             db "Error", 0
    szErrorAlloc        db "Unable to Allocate Memory", 0
    szErrorPtc          db "Unable to Initialze TinyPTC", 0
    szErrorMapFile      db "Unable to Load Map File", 0
    szErrorLutFile      db "Unable to Load TrigLut File", 0
    szMapFile           db "testmap.dat", 0
    szTrigLutFile       db "triglut.dat", 0
    
    dbMapWidth          db 0
    dbMapHeight         db 0
    MAP                 dd 0
    MAPROW              dd 128 dup(0)

    dwPosition          dd 5*256, 5*256, 0, 0 ; X, Y, Angle (Left/Right), Look (Up/Down)

    COS                 dd 256 dup(?)
    SIN                 dd 256 dup(?)
    COS16               dd 1024 dup(?)
    SIN16               dd 1024 dup(?)

    BUFVSIZE            dd 320*240
    BUFSIZE             dd 320*240*4
    BUF                 dd 0

.code

    deinit          PROTO
    doerror         PROTO :DWORD
    load_lut        PROTO
    load_map        PROTO :DWORD
    clear_buffer    PROTO :DWORD
    draw_minimap    PROTO :DWORD, :DWORD
    cast_ray        PROTO :DWORD, :DWORD, :DWORD, :DWORD,  :DWORD, :DWORD
    get_map         PROTO :DWORD, :DWORD
    render_scene    PROTO
    draw_wall_slice PROTO :DWORD, :DWORD, :DWORD

main proc

    LOCAL x :DWORD, y :DWORD
    LOCAL framestart :DWORD

    invoke MessageBox, 0, ADDR szWelcomeText, ADDR szWelcomeTitle, MB_OK 

    ; // All memory to be deallocated at exit must be allocated before ptc_open() is called.
    invoke load_lut

    invoke load_map, ADDR szMapFile

    invoke Alloc, BUFSIZE
    mov BUF, eax
    .IF eax == 0
        invoke doerror, dwERRORALLOC
    .ENDIF
  
    invoke ptc_open, addr szTitle, dwWidth, dwHeight
    .IF eax == 0
        invoke doerror, dwERRORPTC
    .ENDIF

loop1:

    invoke GetTickCount
    mov framestart, eax

    ; input

    mov ebx, offset dwPosition
    add ebx, 8
    mov edx, dword ptr [ebx]

    push edx
    invoke GetAsyncKeyState, VK_LEFT
    pop edx
    and eax, 8000h

    cmp eax, 8000h
    jne skipTurnLeft
    add edx, 1020
    and edx, 1023
skipTurnLeft:

    push edx
    invoke GetAsyncKeyState, VK_RIGHT
    pop edx
    and eax, 8000h

    cmp eax, 8000h
    jne skipTurnRight
    add edx, 4
    and edx, 1023
skipTurnRight:

    mov dword ptr [ebx], edx


    ; render

    invoke clear_buffer, 0h
    invoke render_scene
    invoke draw_minimap, 15, 15

    invoke ptc_update, BUF

frame_lock:
    invoke GetTickCount
    sub eax, framestart
    cmp eax, 16
    jle frame_lock

  jmp loop1

    ; // Only called if we decide to exit manually...

normalExit:
    invoke ptc_close
    invoke ExitProcess, 0
    
    ret

main endp

deinit proc

    ; // Called by TinyPTC on Window Close.

    invoke Free, BUF
    invoke Free, MAP
    invoke MessageBox, 0, ADDR szGoodbyeText, ADDR szGoodbyeTitle, MB_OK 

    ret

deinit endp

render_scene proc

    LOCAL x :DWORD
    LOCAL angdiff :SDWORD
    LOCAL raydist :DWORD
    LOCAL rx :DWORD, ry :DWORD
    LOCAL px :DWORD, py :DWORD, pa :DWORD
    LOCAL tmp :DWORD

    mov eax, offset dwPosition
    mov ebx, dword ptr [eax]
    mov px, ebx
    add eax, 4
    mov ebx, dword ptr [eax]
    mov py, ebx
    add eax, 4
    mov ebx, dword ptr [eax]
    mov pa, ebx


    mov eax, dwWidth
    mov x, eax
    dec x

 xloop:

    ; calculate angle difference for this x
    mov eax, x
    mov ecx, dwWidth
    shr ecx, 1
    sub eax, ecx
    imul eax, 128
    mov ebx, eax
    mov ebx, dwWidth
    cdq
    idiv ebx
    mov angdiff, eax

    ; calculate new ray angle
    mov eax, pa
    add eax, angdiff
    add eax, 1024
    and eax, 1023

    shl eax, 2

    ; find cos/sin (vx/vy) -> (edx, ebx) of this angle, and cast a ray
    mov ecx, offset COS16
    add ecx, eax
    mov edx, dword ptr [ecx]
    mov ecx, offset SIN16
    add ecx, eax
    mov ebx, dword ptr [ecx]

    invoke cast_ray, px, py, edx, ebx, addr rx, addr ry
    
    ; calculate distance

    mov eax, px
    mov ebx, rx
    sub ebx, eax
    mov ecx, ebx
    mov eax, py
    mov ebx, ry
    sub ebx, eax
    
    imul ecx, ecx
    imul ebx, ebx
    add ecx, ebx
    invoke IntSqrt, ecx
    mov raydist, eax

    ; correct distance (should be) [raydist *= cos(atan(dx))]  (is) [raydist *= cos(angdiff)]

    mov ebx, angdiff
    add ebx, 1024
    and ebx, 1023

    shl ebx, 2

    mov ecx, offset COS16
    add ecx, ebx
    mov edx, dword ptr [ecx]

;    cmp edx, 0
;    jge skipAbsSin
;    neg edx
;skipAbsSin:

    mov eax, raydist
    imul eax, edx
    shr eax, 16
    mov raydist, eax   

    ; draw wall slice

    invoke get_map, rx, ry
    mov bl, byte ptr [eax]
    and ebx, 0ffh
    invoke draw_wall_slice, x, raydist, ebx ; // x coordinate, distance too wall, wallblock id (from map grid)    

    ; loop...

    dec x
    cmp x, 0
    jge xloop

    ret

    ;mov eax, offset COS
    ;mov edx, dword ptr [eax]
    ;mov eax, offset SIN
    ;mov ebx, dword ptr [eax]

    ;invoke cast_ray, 4*256, 4*256, edx, ebx, addr x, addr y
    ;invoke get_map, x, y
    ;mov byte ptr [eax], 011h
    
render_scene endp

draw_wall_slice proc x :DWORD, dist :DWORD, tile :DWORD

    LOCAL height :DWORD
    LOCAL starty :DWORD, endy :DWORD
    LOCAL cstarty :DWORD, cendy :DWORD
    LOCAL clr :DWORD
    LOCAL bfrinc :DWORD

    ; calculate wall height
    mov eax, dwHeight
    shl eax, 9
    xor edx, edx
    mov ebx, dist
    idiv ebx
    mov height, eax
    
    ; calculate y start/end positions
    mov eax, height
    shr eax, 1
    mov ebx, dwHeight
    shr ebx, 1
    sub ebx, eax
    mov starty, ebx
    add ebx, height
    mov endy, ebx

    ; calculate clipped positions
    mov ebx, starty
    cmp ebx, 0
    jge skipClipStart
    xor ebx, ebx
skipClipStart:
    mov cstarty, ebx

    mov ebx, endy
    mov ecx, dwHeight
    cmp ebx, ecx
    jl skipClipEnd
    dec ecx
    mov ebx, ecx
skipClipEnd:
    mov cendy, ebx

    ; get colour
    mov ebx, tile
    shl ebx, 4
    mov clr, ebx

    ; render

    mov eax, dwWidth
    shl eax, 2
    mov bfrinc, eax

    mov ecx, cstarty

    mov eax, cstarty
    mov ebx, bfrinc
    imul eax, ebx

    mov ebx, x
    shl ebx, 2
    add ebx, BUF
    add ebx, eax

    ; ecx y counter
    ; ebx buffer offset
    ; eax clr

    mov eax, clr    

wallLoop:

    mov [ebx], eax

    inc ecx
    mov edx, bfrinc
    add ebx, edx

    mov edx, cendy
    cmp ecx, edx
    
    jle wallLoop
    
    ret

draw_wall_slice endp

cast_ray proc x :DWORD, y :DWORD, vx :DWORD, vy :DWORD,  rx :DWORD, ry :DWORD

    ;LOCAL hitx :DWORD, hity :DWORD
    LOCAL sgnx :SDWORD, sgny :SDWORD
    LOCAL tx :DWORD, ty :DWORD

    LOCAL errort :DWORD

    mov eax, vx
    mov ebx, vy

    mov edx, 1
    mov sgnx, edx
    cmp eax, 0
    jge dxpos
    neg edx
    mov sgnx, edx
    neg eax
 dxpos:

    mov edx, 1
    mov sgny, edx
    cmp ebx, 0
    jge dypos
    neg edx
    mov sgny, edx
    neg ebx

 dypos:

    xor edx, edx
    mov errort, edx

    cmp eax, ebx
    jl dygreater


; eax: abs(dx)
; ebx: abs(dy)

dxgreater:

  dxgloop:  

    mov edx, errort
    add edx, ebx
    
    cmp edx, eax
    jl skipIncY
    mov ecx, sgny
    add y, ecx
    sub edx, eax
skipIncY:
    mov ecx, sgnx
    add x, ecx
    mov errort, edx

    mov edx, y
    shr edx, 8
    shl edx, 2
    mov ecx, offset MAPROW
    add ecx, edx
    mov ecx, dword ptr [ecx]
    mov edx, x
    shr edx, 8
    add edx, ecx
    mov cl, byte ptr [edx]
    and ecx, 0ffh
    cmp ecx, 0
    je dxgloop

    jmp final

dygreater:

  dygloop:  

    mov edx, errort
    add edx, eax
    
    cmp edx, ebx
    jl skipIncX
    mov ecx, sgnx
    add x, ecx
    sub edx, ebx
skipIncX:
    mov ecx, sgny
    add y, ecx
    mov errort, edx

    mov edx, y
    shr edx, 8
    shl edx, 2
    mov ecx, offset MAPROW
    add ecx, edx
    mov ecx, dword ptr [ecx]
    mov edx, x
    shr edx, 8
    add edx, ecx
    mov cl, byte ptr [edx]
    and ecx, 0ffh
    cmp ecx, 0
    je dygloop

    jmp final


    ;push eax
    ;invoke MessageBox, 0, str$(x), str$(y), MB_OK
    ;pop eax


final:

    mov eax, rx
    mov ebx, x
    mov dword ptr [eax], ebx
    mov eax, ry
    mov ebx, y
    mov dword ptr [eax], ebx

    ret

cast_ray endp

clear_buffer proc clr :DWORD

    mov ecx, BUFVSIZE
    mov ebx, BUF
    mov eax, clr

clear_loop:

    mov dword ptr [ebx], eax
    add ebx, 4
    dec ecx
    cmp ecx, 0
    jne clear_loop

    ret

clear_buffer endp

draw_minimap proc x :DWORD, y :DWORD

    LOCAL bptr :DWORD
    LOCAL mapsize :DWORD
    LOCAL onedown :DWORD

    xor ecx, ecx
    mov cl, dbMapWidth
    mov eax, dwWidth
    sub eax, ecx
    shl eax, 2
    mov onedown, eax

    mov edx, dwWidth
    mov eax, y
    imul edx, eax
    mov eax, x
    add edx, eax
    shl edx, 2
    add edx, BUF
    mov bptr, edx
    
    xor edx, edx
    mov dl, dbMapWidth
    xor eax, eax
    mov al, dbMapHeight
    imul edx, eax
    mov mapsize, edx

    mov ecx, 0
    mov eax, 0
    mov edx, bptr

the_loop:

    add eax, MAP
    xor ebx, ebx
    mov bl, byte ptr [eax]
    sub eax, MAP
    shl ebx, 4
    mov dword ptr[edx], ebx

    add edx, 4
    inc ecx
    xor ebx, ebx
    mov bl, dbMapWidth
    cmp ecx, ebx
    jl notNextLine
    add edx, onedown
    mov ecx, 0
notNextLine:

    inc eax
    cmp eax, mapsize

    jl the_loop

    ret

draw_minimap endp

load_lut proc

    LOCAL FH :DWORD
    LOCAL dwRval :DWORD

    mov FH, fopen(addr szTrigLutFile)

    mov eax, FH
    .IF eax == 0
        invoke doerror, dwERRORLUTFILE
        ret
    .ENDIF

    mov dwRval, fread(FH, addr COS, 256*4)
    mov dwRval, fread(FH, addr SIN, 256*4)
    mov dwRval, fread(FH, addr COS16, 1024*4)
    mov dwRval, fread(FH, addr SIN16, 1024*4)

    fclose(FH)

    ret

load_lut endp

load_map proc szFileName :DWORD

    LOCAL FH :DWORD
    LOCAL dwRval :DWORD
    LOCAL wSize :DWORD

    mov FH, fopen(szFileName)
    mov eax, FH
    .IF eax == 0
        invoke doerror, dwERRORMAPFILE
        ret
    .ENDIF

    mov wSize, fsize(FH)

    invoke Alloc, wSize
    mov MAP, eax
    .IF eax == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF

    mov dwRval, fread(FH, MAP, wSize)
    fclose(FH)

    invoke IntSqrt, wSize
    mov dbMapWidth, al
    mov dbMapHeight, al

    mov ecx, MAP
    mov edx, offset MAPROW
    mov ebx, eax

maprowloop:
    mov dword ptr [edx], ecx
    add edx, 4
    add ecx, eax
    dec ebx
    cmp ebx, 0
  jne maprowloop
  
    ret

load_map endp

get_map proc x :DWORD, y :DWORD

    push edx
    push ecx

    mov edx, y
    shr edx, 8
    shl edx, 2
    mov ecx, offset MAPROW
    add ecx, edx
    mov ecx, dword ptr [ecx]
    mov edx, x
    shr edx, 8
    add ecx, edx    
    mov eax, ecx

    pop edx
    pop ecx

    ret

get_map endp

doerror proc dwCode :DWORD

    mov eax, dwCode

    cmp eax, dwERRORALLOC
    je errorAlloc

    cmp eax, dwERRORPTC
    je errorPtc

    cmp eax, dwERRORMAPFILE
    je errorMapFile

    cmp eax, dwERRORLUTFILE
    je errorLutFile
    
    invoke ExitProcess, 0

errorLutFile:
    invoke MessageBox, 0, ADDR szErrorLutFile, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorMapFile:
    invoke MessageBox, 0, ADDR szErrorMapFile, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorAlloc:
    invoke MessageBox, 0, ADDR szErrorAlloc, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorPtc:
    invoke deinit
    invoke MessageBox, 0, ADDR szErrorPtc, ADDR szError, MB_OK 
    invoke ExitProcess, 0

doerror endp

END