.386
.model flat, stdcall
option casemap: none

include \masm32\include\windows.inc
include \masm32\include\masm32.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\msvcrt.inc

include \masm32\macros\macros.asm
include tinyptc.inc

includelib \masm32\lib\masm32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\uuid.lib
includelib \masm32\lib\msvcrt.lib
includelib tinyptc.lib

.data 

    dwWidth             dd 320
    dwHeight            dd 240
    szTitle             db "ASMCast by Chris Adams (Lithium)", 0
    szWelcomeTitle      db "Welcome to ASMCast...", 0
    szWelcomeText       db "The MASM32 Raycaster!", 0
    szGoodbyeTitle      db "Seeya...", 0
    szGoodbyeText       db "Later!", 0

    dwERRORALLOC        dd 0
    dwERRORPTC          dd 1
    dwERRORMAPFILE      dd 2
    dwERRORLUTFILE      dd 3
    dwERRORBMPFILE      dd 4
    szError             db "Error", 0
    szErrorAlloc        db "Unable to Allocate Memory", 0
    szErrorPtc          db "Unable to Initialze TinyPTC", 0
    szErrorMapFile      db "Unable to Load Map File", 0
    szErrorLutFile      db "Unable to Load TrigLut File", 0
    szErrorBMPFile      db "Unable to Load Bitmap File", 0
    szMapFile           db "testmap.dat", 0
    szTrigLutFile       db "triglut.dat", 0

    szTextureFile       db "textures\a0.bmp", 0 ; offset 9, 10
    dwTextureCount      dd 3
    dwTextureSize       dd 64
    dwTextureSizeBits   dd 6
    dwTextures          dd 256 dup(0)
    dbBmpHeader         db 54 dup(0)

    dbMapWidth          db 0
    dbMapHeight         db 0
    MAP                 dd 0
    MAPROW              dd 128 dup(0)

    dwPosition          dd 5*2048, 5*2048, 0, 0 ; X, Y, Angle (Left/Right), Look (Up/Down)

    COS                 dd 0
    SIN                 dd 0
    COS16               dd 0
    SIN16               dd 0

    BUFVSIZE            dd ?
    BUFSIZE             dd ?
    BUF                 dd 0

.code

    main                    PROTO
    deinit                  PROTO
    doerror                 PROTO :DWORD
    load_lut                PROTO
    load_map                PROTO :DWORD
    load_textures           PROTO
    load_bmp                PROTO :DWORD
    clear_buffer            PROTO :DWORD
    draw_bmp                PROTO :DWORD, :DWORD, :DWORD
    draw_minimap            PROTO :DWORD, :DWORD
    cast_ray                PROTO :DWORD, :DWORD, :DWORD, :DWORD,  :DWORD, :DWORD, :DWORD
    get_map                 PROTO :DWORD, :DWORD
    render_scene            PROTO
    draw_wall_slice         PROTO :DWORD, :DWORD, :DWORD
    get_texture_address     PROTO :DWORD, :DWORD, :DWORD

mainCRTStartup proc

    invoke main
    ret

mainCRTStartup endp

main proc

    LOCAL x :DWORD, y :DWORD
    LOCAL xinc :SDWORD, yinc :SDWORD
    LOCAL framestart :DWORD
    LOCAL move :SDWORD

    invoke MessageBox, 0, ADDR szWelcomeText, ADDR szWelcomeTitle, MB_OK 

    invoke IntMul, dwWidth, dwHeight
    mov BUFVSIZE, eax
    shl eax, 2
    mov BUFSIZE, eax

    ; // All memory to be deallocated at exit must be allocated before ptc_open() is called.
    invoke load_lut

    invoke load_textures

    invoke load_map, ADDR szMapFile

    invoke crt_malloc, BUFSIZE
    mov BUF, eax
    .IF BUF == 0
        invoke doerror, dwERRORALLOC
    .ENDIF
  
    invoke ptc_open, addr szTitle, dwWidth, dwHeight
    .IF eax == 0
        invoke doerror, dwERRORPTC
    .ENDIF

loop1:

    invoke GetTickCount
    mov framestart, eax

    ;
    ; input
    ;

    ; left/right

    mov ebx, offset dwPosition
    add ebx, 8
    mov edx, dword ptr [ebx]

    push edx
    invoke GetAsyncKeyState, VK_LEFT
    pop edx
    and eax, 8000h

    cmp eax, 8000h
    jne skipTurnLeft
    add edx, 8192-64
    and edx, 8191
skipTurnLeft:

    push edx
    invoke GetAsyncKeyState, VK_RIGHT
    pop edx
    and eax, 8000h

    cmp eax, 8000h
    jne skipTurnRight
    add edx, 64
    and edx, 8191
skipTurnRight:

    mov dword ptr [ebx], edx

    ; forward/backward

    sub ebx, 8
    mov eax, dword ptr [ebx]
    mov x, eax
    add ebx, 4
    mov eax, dword ptr [ebx]
    mov y, eax

    xor eax, eax
    mov move, eax

    push edx
    invoke GetAsyncKeyState, VK_UP
    pop edx   
    and eax, 8000h

    .IF eax == 8000h
        inc move
    .ENDIF

    push edx
    invoke GetAsyncKeyState, VK_DOWN
    pop edx   
    and eax, 8000h

    .IF eax == 8000h
        dec move
    .ENDIF

    mov eax, move
    cmp eax, 0

    je skipMove

    mov eax, COS16
    shl edx, 2
    add eax, edx
    mov eax, dword ptr [eax]
    mov xinc, eax
    ;
    mov eax, SIN16
    add eax, edx
    mov eax, dword ptr [eax]
    mov yinc, eax
    shr edx, 2

    push edx
    push ebx

    mov eax, xinc
    cdq
    mov ebx, 10
    idiv ebx
    mov xinc, eax
    .IF move == 1
        add x, eax
    .ELSE
        sub x, eax
    .ENDIF

    mov eax, yinc
    cdq
    mov ebx, 15
    idiv ebx
    mov yinc, eax
    .IF move == 1
        add y, eax
    .ELSE
        sub y, eax
    .ENDIF

    pop ebx
    pop edx
    
skipMove:

    mov eax, y
    mov dword ptr [ebx], eax
    sub ebx, 4
    mov eax, x
    mov dword ptr [ebx], eax

    ;
    ; render
    ;

    invoke clear_buffer, 0h
    invoke render_scene
    invoke draw_minimap, 15, 15


    ;mov ebx, offset dwTextures
    ;mov ebx, dword ptr [ebx]

    ;invoke draw_bmp, 100, 15, ebx

    invoke ptc_update, BUF

frame_lock:
    invoke GetTickCount
    sub eax, framestart
    cmp eax, 16
    jle frame_lock

  jmp loop1

    ; // Only called if we decide to exit manually...

normalExit:
    invoke ptc_close
    invoke ExitProcess, 0
    
    ret

main endp

deinit proc

    ; // Called by TinyPTC on Window Close.

    invoke crt_free, BUF
    invoke crt_free, MAP
    invoke crt_free, COS
    invoke crt_free, SIN
    invoke crt_free, COS16
    invoke crt_free, SIN16

    ; Free Textures
    mov ebx, offset dwTextures
    mov ecx, dwTextureCount
 goodbye_tex:
    mov edx, dword ptr [ebx]
    push ebx
    push ecx
    invoke crt_free, edx
    pop ecx
    pop ebx
    add ebx, 4
    dec ecx
    cmp ecx, 0
    jg goodbye_tex

    invoke MessageBox, 0, ADDR szGoodbyeText, ADDR szGoodbyeTitle, MB_OK 

    ret

deinit endp

render_scene proc

    LOCAL x :DWORD
    LOCAL angdiff :SDWORD
    LOCAL raydist :DWORD, lastdist :SDWORD
    LOCAL rx :DWORD, ry :DWORD
    LOCAL px :DWORD, py :DWORD, pa :DWORD
    LOCAL tmp :DWORD, stmp :SDWORD
    LOCAL hitType :DWORD

    mov eax, offset dwPosition
    mov ebx, dword ptr [eax]
    mov px, ebx
    add eax, 4
    mov ebx, dword ptr [eax]
    mov py, ebx
    add eax, 4
    mov ebx, dword ptr [eax]
    mov pa, ebx


    mov eax, dwWidth
    mov x, eax
    dec x

 xloop:

    ; calculate angle difference for this x
    mov eax, x
    mov ecx, dwWidth
    shr ecx, 1
    sub eax, ecx
    imul eax, 192*8
    mov ebx, eax
    mov ebx, dwWidth
    cdq
    idiv ebx
    mov angdiff, eax

    ; calculate new ray angle
    mov eax, pa
    add eax, angdiff
    add eax, 8192
    and eax, 8191

    shl eax, 2

    ; find cos/sin (vx/vy) -> (edx, ebx) of this angle, and cast a ray
    mov ecx, COS16
    add ecx, eax
    mov edx, dword ptr [ecx]
    mov ecx, SIN16
    add ecx, eax
    mov ebx, dword ptr [ecx]

    ;push edx
    ;push ebx    
    ;print str$(x), ": "
    ;pop ebx
    ;pop edx

    invoke cast_ray, px, py, edx, ebx, addr rx, addr ry, addr hitType
    
    ; calculate distance

    mov eax, px
    mov ebx, rx
    shr eax, 4
    shr ebx, 4
    sub ebx, eax
    mov ecx, ebx
    mov eax, py
    mov ebx, ry
    shr eax, 4
    shr ebx, 4
    sub ebx, eax
    
    imul ecx, ecx
    imul ebx, ebx
    add ecx, ebx
    invoke IntSqrt, ecx
    mov raydist, eax
    ;shl raydist, 4

    ; correct distance (should be) [raydist *= cos(atan(dx))]  (is) [raydist *= cos(angdiff)]

    mov ecx, angdiff
    .IF angdiff >= 0
        mov ebx, 256*8
        sub ebx, ecx
    .ELSE
        mov ebx, 256*8
        neg ecx
        sub ebx, ecx
    .ENDIF
    ;print str$(ecx), " ebx: "
    ;print str$(ebx), 13, 10
    add ebx, 8192
    and ebx, 8191

    shl ebx, 2

    mov ecx, SIN16
    add ecx, ebx
    mov edx, dword ptr [ecx]

;    cmp edx, 0
;    jge skipAbsSin
;    neg edx
;skipAbsSin:

    mov eax, raydist
    imul eax, edx
    shr eax, 11
    mov raydist, eax
    shl raydist, 4

    cmp eax, 0
    je skipWall

    ; draw wall slice

    invoke get_texture_address, rx, ry, hitType
    mov ebx, eax
    
    invoke draw_wall_slice, x, raydist, ebx ; // x coordinate, distance too wall, wallblock id (from map grid)    

    skipWall:

    ; loop...

    dec x
    cmp x, 0
    jge xloop

    ret

    ;mov eax, COS
    ;mov edx, dword ptr [eax]
    ;mov eax, SIN
    ;mov ebx, dword ptr [eax]

    ;invoke cast_ray, 4*256, 4*256, edx, ebx, addr x, addr y
    ;invoke get_map, x, y
    ;mov byte ptr [eax], 011h
    
render_scene endp

draw_wall_slice proc x :DWORD, dist :DWORD, texPtr :DWORD

    LOCAL height :DWORD
    LOCAL pheight :DWORD
    LOCAL starty :SDWORD, endy :SDWORD
    LOCAL cstarty :DWORD, cendy :DWORD
    LOCAL clr :DWORD
    LOCAL bfrinc :DWORD
    LOCAL texInc :DWORD
    LOCAL texShift :DWORD
    LOCAL texPos :DWORD

    ; calculate wall height
    mov eax, dwHeight
    shl eax, 22
    xor edx, edx
    mov ebx, dist
    idiv ebx
    mov pheight, eax
    shr eax, 11
    mov height, eax
   
    ; calculate y start/end positions
    mov eax, height
    shr eax, 1
    mov ebx, dwHeight
    shr ebx, 1
    sub ebx, eax
    mov starty, ebx
    add ebx, height
    mov endy, ebx

    ; calculate clipped positions
    mov ebx, starty
    cmp ebx, 0
    jge skipClipStart
    xor ebx, ebx
skipClipStart:
    mov cstarty, ebx

    mov ebx, endy
    mov ecx, dwHeight
    cmp ebx, ecx
    jl skipClipEnd
    dec ecx
    mov ebx, ecx
skipClipEnd:
    mov cendy, ebx

    ; get texture step
    mov eax, dwTextureSize
    shl eax, 22
    cdq
    mov ebx, pheight
    div ebx
    mov texInc, eax
    ; texInc = (2^22*dwTextureSize) / pheight
    mov ecx, dwTextureSizeBits
    add ecx, 2
    mov texShift, ecx
    ; texShift = dwTextureSizeBits + 2

    mov ebx, cstarty
    .IF starty < ebx
        mov eax, cstarty
        mov ebx, starty
        sub eax, ebx
        mov ebx, texInc
        mul ebx
        mov texPos, eax
    .ELSE
        xor ebx, ebx
        mov texPos, ebx
    .ENDIF
    
    ; render

    mov eax, dwWidth
    shl eax, 2
    mov bfrinc, eax

    mov ecx, cstarty

    mov eax, cstarty
    mov ebx, bfrinc
    imul eax, ebx

    mov ebx, x
    shl ebx, 2
    add ebx, BUF
    add ebx, eax

    ; ecx y counter
    ; ebx buffer offset
    ; eax clr

wallLoop:

    ; get pixel

    mov eax, texPos
    shr eax, 11
    push ecx
    mov ecx, texShift
    shl eax, cl
    pop ecx
    add eax, texPtr
    mov eax, dword ptr [eax]

    mov edx, texInc
    add texPos, edx

    ; set pixel

    mov dword ptr [ebx], eax

    inc ecx
    mov edx, bfrinc
    add ebx, edx

    mov edx, cendy
    cmp ecx, edx
    
    jle wallLoop
    
    ret

draw_wall_slice endp

cast_ray proc x :DWORD, y :DWORD, vx :DWORD, vy :DWORD,  rx :DWORD, ry :DWORD, hitType :DWORD

    LOCAL sgnx :SDWORD, sgny :SDWORD
    LOCAL uvx :DWORD, uvy :DWORD
    LOCAL mx :DWORD, my :DWORD      ; slope
    LOCAL rax :DWORD, ray :DWORD    ; remainder y
    LOCAL crax :DWORD, cray :DWORD  ; current remainders
    LOCAL tx1 :DWORD, ty1 :DWORD
    LOCAL tx2 :DWORD, ty2 :DWORD
    LOCAL oob1 :DWORD, oob2 :DWORD
    LOCAL overflag :DWORD
    LOCAL stmp :SDWORD

    xor eax, eax
    mov overflag, eax

    ;

    mov eax, vx
    mov ebx, vy

    mov edx, 1
    mov sgnx, edx
    cmp eax, 0
    jge dxpos
    neg edx
    mov sgnx, edx
    neg eax
 dxpos:
    mov uvx, eax

    mov edx, 1
    mov sgny, edx
    cmp ebx, 0
    jge dypos
    neg edx
    mov sgny, edx
    neg ebx
 dypos:
    mov uvy, ebx

    ; calculate ray-x (1)
    
    mov ebx, uvx
    cmp ebx, 0
    je skipRayx

    mov eax, uvy
    shl eax, 11
    xor edx, edx
    mov ebx, uvx
    div ebx
    add eax, 2
    mov mx, eax
    mov rax, edx
    xor edx, edx
    mov crax, edx

    mov ebx, x
    shr ebx, 11
    shl ebx, 11
    
    cmp sgnx, 0
    jge xpositive

 xnegative:
    mov ecx, x
    sub ecx, ebx
    mul ecx
    shr eax, 11
    sub ebx, 1 ; make sure we're in the right cell
    mov tx1, ebx ; set tx1

    mov edx, sgny
    cmp edx, 0
    jge ypositive11

    ; vy negative
    mov ecx, y
    sub ecx, eax
    mov ty1, ecx ; set ty1 (neg)    
    mov ebx, mx ; y inc
    neg ebx
    jmp skipypositive11
        
  ypositive11:
    ; vy positive
    mov ecx, y
    add ecx, eax
    mov ty1, ecx ; set ty1 (pos)
    mov ebx, mx ; y inc

  skipypositive11:

  loop1:
  
    mov eax, tx1
    mov ecx, ty1

    ;sub eax, 1024 ; make sure we're in the right cell
    shr eax, 11 ; too map unit
    shr ecx, 11

    ; test for out of bounds 
    xor edx, edx        ; x >= map width
    mov dl, dbMapWidth  
    cmp eax, edx
    jge exitLoop1OOB    
    xor edx, edx        ; y >= map height
    mov dl, dbMapHeight
    cmp ecx, edx
    jge exitLoop1OOB    
    cmp eax, 0          ; x < 0
    jl exitLoop1OOB     
    cmp ecx, 0          ; y < 0
    jl exitLoop1OOB     

    mov edx, offset MAPROW ; test for ray collision
    shl ecx, 2
    add edx, ecx
    mov edx, dword ptr [edx]
    add edx, eax
    mov dl, byte ptr [edx]
    and edx, 0ffh
    cmp edx, 0 ; if map location is not empty...
    jne exitLoop1    

    mov eax, tx1 ; increment position
    sub eax, 2048
    mov ecx, ty1
    add ecx, ebx

    ;
    ;push ebx
    ;mov ebx, rax
    ;mov edx, crax
    ;add edx, ebx
    ;mov ebx, uvx
    ;.IF edx >= ebx
    ;    sub edx, ebx
    ;    add ecx, sgny
    ;.ENDIF
    ;mov crax, edx
    ;pop ebx 
    ;

    mov tx1, eax
    mov ty1, ecx
   
    jmp loop1 ; loop...
    
  exitLoop1OOB:   ; set out of bounds flag
    mov eax, 1
    mov oob1, eax
    jmp endRayx
    
  exitLoop1:      ; set hit flag
    xor eax, eax
    mov oob1, eax
    jmp endRayx

    jmp skipxpositive
    
 xpositive:
    add ebx, 2048
    mov ecx, ebx
    mov edx, x
    sub ecx, edx
    mul ecx
    add ebx, 1 ; make sure we're in the right cell
    mov tx1, ebx ; set tx1

    shr eax, 11

    mov edx, sgny
    cmp edx, 0
    jge ypositive12

    ; vy negative
    mov ecx, y
    sub ecx, eax
    mov ty1, ecx ; set ty1 (neg)    
    mov ebx, mx ; y inc
    neg ebx
    jmp skipypositive12
        
  ypositive12:
    ; vy positive
    mov ecx, y
    add ecx, eax
    mov ty1, ecx ; set ty (pos)
    mov ebx, mx ; y inc

  skipypositive12:

  loop2:
  
    mov eax, tx1
    mov ecx, ty1

    ;add eax, 1024 ; make sure we're in the right cell
    shr eax, 11 ; too map unit
    shr ecx, 11

    ; test for out of bounds 
    xor edx, edx        ; x >= map width
    mov dl, dbMapWidth  
    cmp eax, edx
    jge exitLoop2OOB    
    xor edx, edx        ; y >= map height
    mov dl, dbMapHeight
    cmp ecx, edx
    jge exitLoop2OOB    
    cmp eax, 0          ; x < 0
    jl exitLoop2OOB     
    cmp ecx, 0          ; y < 0
    jl exitLoop2OOB     
    
    mov edx, offset MAPROW ; test for ray collision
    shl ecx, 2
    add edx, ecx
    mov edx, dword ptr [edx]
    add edx, eax
    mov dl, byte ptr [edx]
    and edx, 0ffh
    cmp edx, 0 ; if map location is not empty...
    jne exitLoop2    

    mov eax, tx1 ; increment position
    add eax, 2048
    mov ecx, ty1
    add ecx, ebx

    ;
    ;push ebx
    ;mov ebx, rax
    ;mov edx, crax
    ;add edx, ebx
    ;mov ebx, uvx
    ;.IF edx >= ebx
    ;    sub edx, ebx
    ;    add ecx, sgny
    ;.ENDIF
    ;mov crax, edx
    ;pop ebx 
    ;
    
    mov tx1, eax
    mov ty1, ecx
   
    jmp loop2 ; loop...
    
  exitLoop2OOB:   ; set out of bounds flag
    mov eax, 1
    mov oob1, eax
    jmp endRayx
    
  exitLoop2:      ; set hit flag
    xor eax, eax
    mov oob1, eax
    jmp endRayx
 
    
 skipxpositive:


skipRayx:

    mov eax, 1
    mov oob1, eax

endRayx:
    
    
    ; calculate ray-y (2)
    
    mov ebx, uvy
    cmp ebx, 0
    je skipRayy

    mov eax, uvx
    shl eax, 11
    xor edx, edx
    mov ebx, uvy
    div ebx
    add eax, 2
    mov my, eax
    mov ray, edx
    xor edx, edx
    mov cray, edx

    mov ebx, y
    shr ebx, 11
    shl ebx, 11
    
    cmp sgny, 0
    jge ypositive

 ynegative:
    mov ecx, y
    sub ecx, ebx
    mul ecx
    sub ebx, 1 ; make sure we're in the right cell
    mov ty2, ebx ; set ty2

    shr eax, 11

    mov edx, sgnx
    cmp edx, 0
    jge xpositive21

    ; vx negative
    mov ecx, x
    sub ecx, eax
    mov tx2, ecx ; set tx2 (neg)    
    mov ebx, my ; x inc
    neg ebx
    jmp skipxpositive21
        
  xpositive21:
    ; vx positive
    mov ecx, x
    add ecx, eax
    mov tx2, ecx ; set tx2 (pos)
    mov ebx, my ; x inc

  skipxpositive21:

  loop3:

    mov eax, tx2
    mov ecx, ty2

    ;sub ecx, 1024 ; make sure we're in the right cell
    shr eax, 11 ; too map unit
    shr ecx, 11

    ; test for out of bounds 
    xor edx, edx        ; x >= map width
    mov dl, dbMapWidth  
    cmp eax, edx
    jge exitLoop3OOB    
    xor edx, edx        ; y >= map height
    mov dl, dbMapHeight
    cmp ecx, edx
    jge exitLoop3OOB    
    cmp eax, 0          ; x < 0
    jl exitLoop3OOB     
    cmp ecx, 0          ; y < 0
    jl exitLoop3OOB     

    mov edx, offset MAPROW ; test for ray collision
    shl ecx, 2
    add edx, ecx
    mov edx, dword ptr [edx]
    add edx, eax
    mov dl, byte ptr [edx]
    and edx, 0ffh
    cmp edx, 0 ; if map location is not empty...
    jne exitLoop3

    mov ecx, ty2 ; increment position
    sub ecx, 2048
    mov eax, tx2
    add eax, ebx

    ;
    ;push ebx
    ;mov ebx, ray
    ;mov edx, cray
    ;add edx, ebx
    ;mov ebx, uvy
    ;.IF edx >= ebx
    ;    sub edx, ebx
    ;    add eax, sgny
    ;.ENDIF
    ;mov cray, edx
    ;pop ebx 
    ;

    mov ty2, ecx
    mov tx2, eax

    jmp loop3 ; loop...
    
  exitLoop3OOB:   ; set out of bounds flag
    mov eax, 1
    mov oob2, eax
    jmp endRayy
    
  exitLoop3:      ; set hit flag
    xor eax, eax
    mov oob2, eax
    jmp endRayy

    jmp skipypositive

 ypositive:
    add ebx, 2048
    mov ecx, ebx
    mov edx, y
    sub ecx, edx
    mul ecx
    add ebx, 1 ; make sure we're in the right cell
    mov ty2, ebx ; set ty2

    shr eax, 11

    mov edx, sgnx
    cmp edx, 0
    jge xpositive22

    ; vx negative
    mov ecx, x
    sub ecx, eax
    mov tx2, ecx ; set tx2 (neg)    
    mov ebx, my ; x inc
    neg ebx
    jmp skipxpositive22
        
  xpositive22:
    ; vx positive
    mov ecx, x
    add ecx, eax
    mov tx2, ecx ; set tx2 (pos)
    mov ebx, my ; x inc

  skipxpositive22:

  loop4:

    mov eax, tx2
    mov ecx, ty2

    ;add ecx, 1024 ; make sure we're in the right cell
    shr eax, 11 ; too map unit
    shr ecx, 11

    ; test for out of bounds 
    xor edx, edx        ; x >= map width
    mov dl, dbMapWidth  
    cmp eax, edx
    jge exitLoop4OOB    
    xor edx, edx        ; y >= map height
    mov dl, dbMapHeight
    cmp ecx, edx
    jge exitLoop4OOB    
    cmp eax, 0          ; x < 0
    jl exitLoop4OOB     
    cmp ecx, 0          ; y < 0
    jl exitLoop4OOB     

    mov edx, offset MAPROW ; test for ray collision
    shl ecx, 2
    add edx, ecx
    mov edx, dword ptr [edx]
    add edx, eax
    mov dl, byte ptr [edx]
    and edx, 0ffh
    cmp edx, 0 ; if map location is not empty...
    jne exitLoop4

    mov ecx, ty2 ; increment position
    add ecx, 2048
    mov eax, tx2
    add eax, ebx

    ;
    ;push ebx
    ;mov ebx, ray
    ;mov edx, cray
    ;add edx, ebx
    ;mov ebx, uvy
    ;.IF edx >= ebx
    ;    sub edx, ebx
    ;    add eax, sgny
    ;.ENDIF
    ;mov cray, edx
    ;pop ebx 
    ;
    
    mov ty2, ecx
    mov tx2, eax

    jmp loop4 ; loop...
    
  exitLoop4OOB:   ; set out of bounds flag
    mov eax, 1
    mov oob2, eax
    jmp endRayy
    
  exitLoop4:      ; set hit flag
    xor eax, eax
    mov oob2, eax
    jmp endRayy
    
 skipypositive:

skipRayy:

    mov eax, 1
    mov oob2, eax

endRayy:
 
    jmp final

overflow1:
    mov eax, 1
    mov overflag, eax
    ;print str$(eax), " overflow 1", 13, 10
    jmp final

overflow2:
    mov eax, 1
    mov overflag, eax
    ;print str$(eax), " overflow 1", 13, 10
    jmp final

final:

    .IF oob1 == 1
        mov eax, tx2
        mov x, eax
        mov eax, ty2
        mov y, eax
        ;print "oob1"
        mov eax, hitType
        mov ebx, 1
        mov dword ptr [eax], ebx
    .ELSEIF oob2 == 1
        mov eax, tx1
        mov x, eax
        mov eax, ty1
        mov y, eax
        ;print "oob2"    
        mov eax, hitType
        mov ebx, 0
        mov dword ptr [eax], ebx
    .ELSE
        .IF overflag == 0
            mov eax, tx1
            sub eax, x
            mov ebx, ty1
            sub ebx, y
            imul eax, eax
            jo overflow1
            imul ebx, ebx
            jo overflow1
            add eax, ebx

            mov ebx, tx2
            sub ebx, x
            mov ecx, ty2
            sub ecx, y
            imul ebx, ebx
            jo overflow2
            imul ecx, ecx
            jo overflow2
            add ebx, ecx
       .ELSE
            mov eax, tx1
            sub eax, x
            sar eax, 8
            mov ebx, ty1
            sub ebx, y
            sar ebx, 8
            imul eax, eax
            imul ebx, ebx
            add eax, ebx
            
            mov ebx, tx2
            sub ebx, x
            sar ebx, 8
            mov ecx, ty2
            sub ecx, y
            sar ecx, 8
            imul ebx, ebx
            imul ecx, ecx
            add ebx, ecx
        .ENDIF        
      
        .IF eax < ebx
            mov eax, tx1
            mov x, eax
            mov eax, ty1
            mov y, eax      
            ;print "ray-x less"
            mov eax, hitType
            mov ebx, 0
            mov dword ptr [eax], ebx
        .ELSE
            mov eax, tx2
            mov x, eax
            mov eax, ty2
            mov y, eax
            ;print "ray-y less"
            mov eax, hitType
            mov ebx, 1
            mov dword ptr [eax], ebx
        .ENDIF

        ;mov stmp, eax
        ;print str$(stmp), 13, 10
        ;mov stmp, ebx
        ;print str$(stmp), 13, 10
        ;print str$(overflag), 13, 10
       
    .ENDIF
    
    mov eax, rx
    mov ebx, x
    mov dword ptr [eax], ebx
    mov eax, ry
    mov ebx, y
    mov dword ptr [eax], ebx

    shr x, 11
    shr y, 11
    ;print str$(x), " "
    ;print str$(y), 13, 10
    ;print str$(sgnx), "(sx) "
    ;print str$(sgny), "(sy) ", 13, 10

    ;shr x, 16
    ;shr y, 16
    ;invoke MessageBox, 0, str$(x), str$(y), MB_OK

    ret

cast_ray endp

clear_buffer proc clr :DWORD

    mov ecx, BUFVSIZE
    mov ebx, BUF
    mov eax, clr

clear_loop:

    mov dword ptr [ebx], eax
    add ebx, 4
    dec ecx
    cmp ecx, 0
    jne clear_loop

    ret

clear_buffer endp

draw_minimap proc x :DWORD, y :DWORD

    LOCAL bptr :DWORD
    LOCAL mapsize :DWORD
    LOCAL onedown :DWORD

    xor ecx, ecx
    mov cl, dbMapWidth
    mov eax, dwWidth
    sub eax, ecx
    shl eax, 2
    mov onedown, eax

    mov edx, dwWidth
    mov eax, y
    imul edx, eax
    mov eax, x
    add edx, eax
    shl edx, 2
    add edx, BUF
    mov bptr, edx
    
    xor edx, edx
    mov dl, dbMapWidth
    xor eax, eax
    mov al, dbMapHeight
    imul edx, eax
    mov mapsize, edx

    mov ecx, 0
    mov eax, 0
    mov edx, bptr

the_loop:

    add eax, MAP
    xor ebx, ebx
    mov bl, byte ptr [eax]
    sub eax, MAP
    cmp ebx, 0
    je noPixel
    mov ebx, 0ffh
    mov dword ptr[edx], ebx
  noPixel:

    add edx, 4
    inc ecx
    xor ebx, ebx
    mov bl, dbMapWidth
    cmp ecx, ebx
    jl notNextLine
    add edx, onedown
    mov ecx, 0
notNextLine:

    inc eax
    cmp eax, mapsize

    jl the_loop

    ret

draw_minimap endp

draw_bmp proc x :DWORD, y :DWORD, bmp :DWORD

    LOCAL bptr :DWORD
    LOCAL imgsize :DWORD
    LOCAL onedown :DWORD
    LOCAL bmpWidth :DWORD, bmpHeight :DWORD

    mov eax, bmp
    mov ebx, dword ptr[eax]
    mov bmpWidth, ebx
    add eax, 4
    mov ebx, dword ptr[eax]
    mov bmpHeight, ebx

    mov ecx, bmpWidth
    mov eax, dwWidth
    sub eax, ecx
    shl eax, 2
    mov onedown, eax

    mov edx, dwWidth
    mov eax, y
    imul edx, eax
    mov eax, x
    add edx, eax
    shl edx, 2
    add edx, BUF
    mov bptr, edx
    
    mov edx, bmpWidth
    mov eax, bmpHeight
    imul edx, eax
    mov imgsize, edx

    mov ecx, 0
    mov eax, 0
    mov edx, bptr

the_loop:

    push eax
    shl eax, 2
    add eax, bmp
    add eax, 8
    mov ebx, dword ptr [eax]
    mov dword ptr[edx], ebx
    pop eax

    add edx, 4
    inc ecx
    mov ebx, bmpWidth
    cmp ecx, ebx
    jl notNextLine
    add edx, onedown
    mov ecx, 0
notNextLine:

    inc eax
    cmp eax, imgsize

    jl the_loop

    ret

draw_bmp endp

load_textures proc

    LOCAL curTex :DWORD

    xor eax, eax
    mov curTex, eax

ltLoop:

    invoke load_bmp, addr szTextureFile
    mov ebx, offset dwTextures
    mov ecx, curTex
    shl ecx, 2
    add ebx, ecx
    mov dword ptr [ebx], eax

    mov eax, offset szTextureFile
    add eax, 10

    xor ebx, ebx
    mov bl, byte ptr [eax]

    inc ebx
    cmp ebx, '9'
    jle skipIncLetter
    mov ebx, '0'
    dec eax
    xor ecx, ecx
    mov cl, byte ptr [eax]
    inc ecx
    mov byte ptr [eax], cl
    inc eax
skipIncLetter:
    mov byte ptr [eax], bl

    inc curTex
    mov eax, curTex
    cmp eax, dwTextureCount
    jl ltLoop

    ret

load_textures endp

load_bmp proc szFile :DWORD

    LOCAL FH :DWORD
    LOCAL dwRval :DWORD
    LOCAL bmpWidth :DWORD, bmpHeight :DWORD
    LOCAL tmpBuffer :DWORD, finalBuffer :DWORD
    LOCAL tmpSize :DWORD, finalSize :DWORD
    LOCAL tmpY :DWORD, finalY :DWORD, curX :DWORD
    LOCAL tmpYOff :DWORD, finalYOff :DWORD
    LOCAL tmpWidth :DWORD

    mov FH, fopen(szFile)

    .IF FH == 0
        invoke doerror, dwERRORBMPFILE
        ret
    .ENDIF

    mov dwRval, fread(FH, addr dbBmpHeader, 54)

    mov ebx, offset dbBmpHeader
    mov ax, word ptr[ebx]
    .IF ax != 19778
        invoke doerror, dwERRORBMPFILE
        ret
    .ENDIF

    mov ebx, offset dbBmpHeader
    add ebx, 28
    mov ax, word ptr[ebx]
    .IF ax != 24
        invoke doerror, dwERRORBMPFILE
        ret
    .ENDIF

    mov ebx, offset dbBmpHeader
    add ebx, 18
    mov eax, dword ptr[ebx]
    mov bmpWidth, eax
    add ebx, 4
    mov eax, dword ptr[ebx]
    mov bmpHeight, eax

    mov ecx, bmpWidth
    mov ebx, ecx
    add ecx, ebx
    add ecx, ebx
    mov ebx, ecx
    and ecx, 3
    .IF ecx > 0
        mov eax, 4
        sub eax, ecx
        add ebx, eax
        mov tmpWidth, ebx
    .ELSE
        mov tmpWidth, ebx
    .ENDIF

    invoke IntMul, tmpWidth, bmpHeight
    mov tmpSize, eax

    invoke IntMul, bmpWidth, bmpHeight
    add eax, 8
    mov finalSize, eax

    invoke IntMul, tmpSize, 3
    mov tmpSize, eax

    shl finalSize, 2 ; * 4

    invoke crt_malloc, tmpSize
    mov tmpBuffer, eax

    .IF tmpBuffer == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF    

    invoke crt_malloc, finalSize
    mov finalBuffer, eax

    .IF finalBuffer == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF

    mov dwRval, fread(FH, tmpBuffer, tmpSize)
  
    fclose(FH)
    
    ; set final header
    mov eax, finalBuffer
    mov ebx, bmpWidth
    mov dword ptr [eax], ebx
    add eax, 4
    mov ebx, bmpHeight
    mov dword ptr [eax], ebx

    ; convert pixels

    xor eax, eax
    mov tmpY, eax
    mov eax, bmpHeight
    dec eax
    mov finalY, eax

nexty:

    xor eax, eax
    mov curX, eax

    invoke IntMul, tmpY, tmpWidth
    mov tmpYOff, eax
    invoke IntMul, finalY, bmpWidth
    mov finalYOff, eax

  nextx:

    ; get pixel
    
    mov ebx, curX
    mov eax, ebx
    mov ecx, eax
    add eax, ecx
    add eax, ecx
    add eax, tmpYOff
    add eax, tmpBuffer

    xor ebx, ebx
    add eax, 2
    mov bl, byte ptr [eax] ; pixel stored in ebx
    shl ebx, 8
    dec eax
    mov bl, byte ptr [eax]
    shl ebx, 8
    dec eax
    mov bl, byte ptr [eax]

    mov eax, finalYOff
    mov ecx, curX
    add eax, ecx
    shl eax, 2
    add eax, finalBuffer
    add eax, 8

    mov dword ptr [eax], ebx

    ; set pixel

    add curX, 1
    mov eax, bmpWidth
    cmp curX, eax
    jl nextx

    sub finalY, 1
    add tmpY, 1
    xor eax, eax
    cmp finalY, eax
    jg nexty
   
    ;

    invoke crt_free, tmpBuffer

    mov eax, finalBuffer

    ret

load_bmp endp

load_lut proc

    LOCAL FH :DWORD
    LOCAL dwRval :DWORD

    mov FH, fopen(addr szTrigLutFile)

    mov eax, FH
    .IF eax == 0
        invoke doerror, dwERRORLUTFILE
        ret
    .ENDIF

    invoke crt_malloc, 256*4
    .IF eax == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF
    mov COS, eax

    invoke crt_malloc, 256*4
    .IF eax == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF
    mov SIN, eax

    invoke crt_malloc, 8192*4
    .IF eax == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF
    mov COS16, eax

    invoke crt_malloc, 8192*4
    .IF eax == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF   
    mov SIN16, eax
    
    mov dwRval, fread(FH, COS, 256*4)
    mov dwRval, fread(FH, SIN, 256*4)
    mov dwRval, fread(FH, COS16, 8192*4)
    mov dwRval, fread(FH, SIN16, 8192*4)

    fclose(FH)

    ret

load_lut endp

load_map proc szFileName :DWORD

    LOCAL FH :DWORD
    LOCAL dwRval :DWORD
    LOCAL wSize :DWORD

    mov FH, fopen(szFileName)
    mov eax, FH
    .IF eax == 0
        invoke doerror, dwERRORMAPFILE
        ret
    .ENDIF

    mov wSize, fsize(FH)

    invoke crt_malloc, wSize
    mov MAP, eax
    .IF eax == 0
        invoke doerror, dwERRORALLOC
        ret
    .ENDIF

    mov dwRval, fread(FH, MAP, wSize)
    fclose(FH)

    invoke IntSqrt, wSize
    mov dbMapWidth, al
    mov dbMapHeight, al

    mov ecx, MAP
    mov edx, offset MAPROW
    mov ebx, eax

maprowloop:
    mov dword ptr [edx], ecx
    add edx, 4
    add ecx, eax
    dec ebx
    cmp ebx, 0
  jne maprowloop
  
    ret

load_map endp

get_map proc x :DWORD, y :DWORD

    push edx
    push ecx

    mov edx, y
    shr edx, 11
    shl edx, 2
    mov ecx, offset MAPROW
    add ecx, edx
    mov ecx, dword ptr [ecx]
    mov edx, x
    shr edx, 11
    add ecx, edx    
    mov eax, ecx

    pop edx
    pop ecx

    ret

get_map endp

get_texture_address proc x :DWORD, y :DWORD, hitType :DWORD

    LOCAL texX :DWORD
    LOCAL texN :DWORD

    invoke get_map, x, y
    xor ebx, ebx
    mov bl, byte ptr [eax]
    dec ebx
    mov texN, ebx
    
    mov ecx, 11
    sub ecx, dwTextureSizeBits

    mov texX, ecx

    shr x, cl
    shr y, cl

    mov ecx, dwTextureSize
    dec ecx

    and x, ecx
    and y, ecx

    inc ecx
    shr ecx, 1
   
    .IF hitType == 0
        .IF x<ecx
            mov ebx, y
            mov texX, ebx
        .ELSE
            mov ebx, dwTextureSize
            dec ebx
            sub ebx, y
            mov texX, ebx
        .ENDIF
    .ELSE
        .IF y<ecx
            mov ebx, x
            mov texX, ebx
        .ELSE
            mov ebx, dwTextureSize
            dec ebx
            sub ebx, x
            mov texX, ebx
        .ENDIF
    .ENDIF

    mov eax, offset dwTextures
    mov ebx, texN
    shl ebx, 2
    add eax, ebx
    mov eax, dword ptr [eax]
    add eax, 8
    shl texX, 2
    add eax, texX

    ret

get_texture_address endp

doerror proc dwCode :DWORD

    mov eax, dwCode

    cmp eax, dwERRORALLOC
    je errorAlloc

    cmp eax, dwERRORPTC
    je errorPtc

    cmp eax, dwERRORMAPFILE
    je errorMapFile

    cmp eax, dwERRORLUTFILE
    je errorLutFile

    cmp eax, dwERRORBMPFILE
    je errorBMPFile
    
    invoke ExitProcess, 0

errorBMPFile:
    invoke MessageBox, 0, ADDR szErrorBMPFile, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorLutFile:
    invoke MessageBox, 0, ADDR szErrorLutFile, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorMapFile:
    invoke MessageBox, 0, ADDR szErrorMapFile, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorAlloc:
    invoke MessageBox, 0, ADDR szErrorAlloc, ADDR szError, MB_OK 
    invoke ExitProcess, 0

errorPtc:
    invoke deinit
    invoke MessageBox, 0, ADDR szErrorPtc, ADDR szError, MB_OK 
    invoke ExitProcess, 0

doerror endp

END