defdbl a-z

const texturesize = 64 ' ** do not change **
const onetexture = (texturesize * texturesize * 4) + 4
const maxsprites = 128
const maxdblocks = 128
const maxdoors = 128
const maxtextures = 128
const maxspriteimages = 128

const horizontal = 0
const vertical = 1

type spritetype
    
    inuse as integer
    x as double
    y as double
    sprite as integer
    collisionradius as double
    
end type

type door
    
    inuse as integer
    texture as integer
    locked as integer
    hORv as integer
    
end type

type dblock
    
    inuse as integer
    x as double
    y as double
    texture as integer
    
end type

dim shared spriteimages as integer, textures as integer
dim shared texturedata ( maxtextures * onetexture ) as ubyte
dim shared spritedata ( maxspriteimages * onetexture ) as ubyte
dim shared mapsizex as integer, mapsizey as integer
dim shared mapfile as string
dim shared map(0 to (128*128)) as integer
dim shared fmap(0 to (128*128)) as integer
dim shared cmap(0 to (128*128)) as integer
dim shared sprites(0 to maxsprites) as spritetype
dim shared doors(0 to maxdoors) as door
dim shared dblocks(0 to maxdblocks) as dblock

print "(N)ew or (L)oad?"

do
    k$ = inkey$
    
    if lcase$(k$) = "n" then
        
        line input "Filename to save as: ", mapfile
        
        line input "Texture/Imageset file: ", set$
        
        input "Map width in blocks: ", mapsizex
        input "Map height in blocks: ", mapsizey
        
        for x = 0 to mapsizex-1
            
            map(x) = 1
            map(x + (mapsizey-1)*128) = 1
            
        next x
        
        for y = 0 to mapsizey-1
            
            map(y*128) = 1
            map((mapsizex-1) + y*128) = 1
            
        next x
        
        for x = 0 to mapsizex-1
            for y = 0 to mapsizey-1
                
                fmap(x+y*128) = floortexture%
                cmap(x+y*128) = ceelingtexture%
                
            next y
        next x            

        playerx% = mapsizex \ 2
        playery% = mapsizey \ 2
        
        newflag% = 1

        exit do
        
    elseif lcase$(k$) = "l" then
        
        line input "File to load: ", mapfile
        
        f = freefile
        open mapfile for input as #f
        
            line input #f, set$
            input #f, mapsizex, mapsizey
            input #f, playerx%, playery%
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    input #f, map(x + y * 128)
                    
                next x
            next y
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    input #f, fmap(x + y * 128)
                    
                next x
            next y
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    input #f, cmap(x + y * 128)
                    
                next x
            next y
            
            input #f, spritecount%
            
            for i = 0 to spritecount%-1
                
                sprites(i).inuse = 1
                input #f, sprites(i).x, sprites(i).y, sprites(i).sprite, sprites(i).collisionradius
                
            next i

            input #f, doorcount%
            
            for i = 0 to doorcount%-1
                
                input #f, j
                
                doors(j).inuse = 1
                input #f, doors(j).texture, doors(j).locked, doors(j).hORv
                
            next i
            
            input #f, dblockcount%
            
            for i = 0 to dblockcount%-1
                
                dblocks(i).inuse = 1
                input #f, dblocks(i).x, dblocks(i).y
                input #f, dblocks(i).texture
                
            next i
            
        close #f
        
        newflag% = 0
        
        exit do
        
    end if
    
loop

screenres 640, 400, 32, 2, &h1
screenset 1, 0

f = freefile
open set$ for input as #f

    line input #f, texturepre$
    input #f, textures
    line input #f, spritepre$
    input #f, spriteimages
    input #f, floortexture%, ceelingtexture%

close #f

for i = 0 to textures-1
    
    file$ = texturepre$ + ltrim$(str$(i+1)) + ".bmp"
    bload file$, varptr(texturedata(onetexture * i))
    
next i

for i = 0 to spriteimages-1
    
    file$ = spritepre$ + ltrim$(str$(i+1)) + ".bmp"
    bload file$, varptr(spritedata(onetexture * i))
    
next i

if newflag% = 1 then
    for x = 0 to mapsizex-1
        for y = 0 to mapsizey-1
            
            fmap(x+y*128) = floortexture%
            cmap(x+y*128) = ceelingtexture%
            
        next y
    next x
end if    
    
scrollx = 0
scrolly = 0

walltex% = 1

level% = 0

do
    
    framestart = timer
    
    k$ = lcase$(inkey$)
    
    getmouse mousex%, mousey%, , buttons%
 
    if mousex% <= 5 then scrollx = scrollx - 10/30
    if mousey% <= 5 then scrolly = scrolly - 10/30
    if mousex% >= 635 then scrollx = scrollx + 10/30
    if mousey% >= 395 then scrolly = scrolly + 10/30
    
    if scrollx > (mapsizex-10) then scrollx = (mapsizex-10)
    if scrolly > (mapsizey-6.25) then scrolly = (mapsizey-6.25)

    if scrollx < 0 then scrollx = 0
    if scrolly < 0 then scrolly = 0

    cls
    
    selx% = fix(scrollx + (mousex% / 64))
    sely% = fix(scrolly + (mousey% / 64))
    
    for x% = -1 to 10
        for y% = -1 to 7
            
            mx% = x% + fix(scrollx)
            my% = y% + fix(scrolly)
            
            if mx% >= 0 and my% >= 0 and mx% < mapsizex and my% < mapsizey then
                
                mpos% = mx% + (my% * 128)
                if level% = 0 then
            
                    if map(mpos%) > 0 then
                        
                        texno% = map(mpos%) - 1
                        put(x%*64 - (fix(scrollx * 64) and 63), y%*64 - (fix(scrolly * 64) and 63)), texturedata(texno% * onetexture), pset
                        
                    elseif map(mpos%) < 0 then
                        
                        doorno% = -map(mpos%) - 1
                        put(x%*64 - (fix(scrollx * 64) and 63), y%*64 - (fix(scrolly * 64) and 63)), texturedata((doors(doorno%).texture-1) * onetexture), pset
                        
                        if doors(doorno%).hORv = horizontal then
                        
                            line(x%*64 - (fix(scrollx * 64) and 63), 32+y%*64 - (fix(scrolly * 64) and 63))-step(63, 0), rgb(0, 0, 255)
                        
                        else
                        
                            line(32+(x%*64) - (fix(scrollx * 64) and 63), (y%*64) - (fix(scrolly * 64) and 63))-step(0, 63), rgb(0, 0, 255)
                        
                        end if
                        
                    end if
                    
                elseif level% = -1 then ' floor
                    
                    texno% = fmap(mpos%) - 1
                    put(x%*64 - (fix(scrollx * 64) and 63), y%*64 - (fix(scrolly * 64) and 63)), texturedata(texno% * onetexture), pset
                    
                    if map(mpos%) then
                        
                        line (x%*64 - (fix(scrollx * 64) and 63), y%*64 - (fix(scrolly * 64) and 63))-step(63, 63), rgb(255, 255, 255), b
                        
                    end if
                    
                elseif level% = 1 then ' ceeling
                    
                    if cmap(mpos%) > 0 then
                    
                        texno% = cmap(mpos%) - 1
                        put(x%*64 - (fix(scrollx * 64) and 63), y%*64 - (fix(scrolly * 64) and 63)), texturedata(texno% * onetexture), pset
                        
                    end if
                    
                    if map(mpos%) then
                        
                        line (x%*64 - (fix(scrollx * 64) and 63), y%*64 - (fix(scrolly * 64) and 63))-step(63, 63), rgb(255, 255, 255), b
                        
                    end if
                    
                end if
                
            end if
            
        next y
    next x
    
    for i = 0 to maxsprites-1
        
        if sprites(i).inuse then
            
            sx = (sprites(i).x - scrollx) * 64
            sy = (sprites(i).y - scrolly) * 64
            
            if sx > -64 and sy > -64 and sx < 640 and sy < 480 then
                
                if level% = 0 then
            
                    put(sx, sy), spritedata((sprites(i).sprite-1) * onetexture), pset
                    
                else
                    
                    line(sx+16, sy+16)-step(32, 32), rgb(0, 255, 0), b
                    
                end if
            
            end if
            
        end if
        
    next i
    
    for i = 0 to maxdblocks-1
        
        if dblocks(i).inuse then
            
            dx = (dblocks(i).x - scrollx) * 64
            dy = (dblocks(i).y - scrolly) * 64

            if dx > -64 and dy > -64 and dx < 640 and dy < 480 then
                
                if level% = 0 then
                    
                    put(dx, dy), texturedata((dblocks(i).texture-1) * onetexture), pset
                    
                end if
                
                line(dx, dy)-step(63, 63), rgb(0, 0, 255), b
            
            end if
        
        end if
        
    next i

    put((selx% - scrollx) * 64, (sely% - scrolly) * 64), texturedata((walltex%-1) * onetexture), pset
    line ((selx% - scrollx) * 64, (sely% - scrolly) * 64)-step(63, 63), rgb(255, 255, 255), b

    px = (playerx% - scrollx) * 64
    py = (playery% - scrolly) * 64
    
    if px > -64 and py > -64 and px < 640 and py < 480 then
    
        line (px, py)-step(63, 63), rgb(0, 255, 0)
        line (px+63, py)-step(-63, 63), rgb(0, 255, 0)
    
    end if

    locate 1, 1: print selx%; ", "; sely%
    
    if k$ = "1" then level% = -1
    if k$ = "2" then level% = 0
    if k$ = "3" then level% = 1

    if k$ = "p" then
        playerx% = selx%
        playery% = sely%
    end if
    
    if k$ = "." then
        walltex% = walltex% + 1
        if walltex% > textures then walltex% = 1
    end if
    
    if k$ = "," then
        walltex% = walltex% - 1
        if walltex% < 1 then walltex% = textures
    end if
    
    if level% = -1 then
        
        if buttons% and 1 then
            
            fmap(selx% + sely% * 128) = walltex%
            
        end if
        
    elseif level% = 1 then
        
        if buttons% and 1 then
            
            cmap(selx% + sely% * 128) = walltex%
            
        end if
        
        if buttons% and 2 then
            
            cmap(selx% + sely% * 128) = 0
            
        end if
    
    elseif level% = 0 then
    
        if k$ = "b" then
            
            newdb = -1
            cancel = -1
            for i = 0 to maxdblocks
                
                if dblocks(i).inuse = 0 and newdb = -1 then newdb = i
                
                if dblocks(i).inuse and fix(dblocks(i).x) = selx% and fix(dblocks(i).y) = sely% then
                    
                    cancel = i
                    
                end if
                
            next i
            
            if newdb >= 0 and cancel = -1 then
                
                dblocks(newdb).inuse = 1
                dblocks(newdb).texture = walltex%
                dblocks(newdb).x = selx%
                dblocks(newdb).y = sely%
                
            elseif cancel >= 0 then
                
                dblocks(cancel).texture = walltex%
                
            end if
            
        end if
    
        if k$ = "h" then
            
            mpos% = selx% + sely% * 128
            
            if map(mpos%) < 0 then
                
                doors(-map(mpos%) - 1).hORv = horizontal
                
            end if
            
        end if
    
        if k$ = "v" then
            
            mpos% = selx% + sely% * 128
            
            if map(mpos%) < 0 then
                
                doors(-map(mpos%) - 1).hORv = vertical
                
            end if
            
        end if
    
        if k$ = "+" or k$ = "=" then
            
            for i = 0 to maxsprites-1
                
                if sprites(i).inuse and sprites(i).x = selx% and sprites(i).y = sely% then
                    
                    sprites(i).sprite = sprites(i).sprite + 1
                    if sprites(i).sprite > spriteimages then sprites(i).sprite = 1
                    
                end if
                
            next i
            
        end if
    
        if k$ = "-" then
            
            for i = 0 to maxsprites-1
                
                if sprites(i).inuse and sprites(i).x = selx% and sprites(i).y = sely% then
                    
                    sprites(i).sprite = sprites(i).sprite - 1
                    if sprites(i).sprite < 1 then sprites(i).sprite = spriteimages
                    
                end if
                
            next i
            
        end if
    
        if k$ = "n" then
            
            found% = 0
            for i = 0 to maxsprites-1
                
                if sprites(i).inuse and sprites(i).x = selx% and sprites(i).y = sely% then
                    
                    found% = 1
                    exit for
                    
                end if
                
            next i
            
            if found% = 0 then
            
                for i = 0 to maxsprites-1
                    
                    if sprites(i).inuse = 0 then
        
                        sprites(i).inuse = 1
                        sprites(i).x = selx%
                        sprites(i).y = sely%
                        sprites(i).collisionradius = 0
                        sprites(i).sprite = 1
                        
                        exit for
                    
                    end if
                    
                next i
            
            end if
            
        end if
    
        if k$ = "d" then
            
            if map(selx% + sely% * 128) >= 0 then
            
                for i = 0 to maxdoors-1
                    
                    if doors(i).inuse = 0 then
                        
                        doors(i).inuse = 1
                        doors(i).locked = 0
                        doors(i).hORv = 0
                        doors(i).texture = walltex%
                        
                        map(selx% + sely% * 128) = -(i+1)
                        
                        exit for
                        
                    end if
                    
                next i
                
            end if
                
        end if
        
        mpos% = selx% + sely% * 128
        
        if buttons% and 1 then
            
            if map(mpos%) >= 0 then
                
                map(mpos%) = walltex%
                
            else
                
                doors(-map(mpos%)-1).texture = walltex%
                
            end if
            
        end if
        
        if buttons% and 2 then
            
            if map(mpos%) > 0 then
                
                map(mpos%) = 0
                
            elseif map(mpos%) < 0 then
                
                doors(-map(mpos%)-1).inuse = 0
                map(mpos%) = 0
                
            end if
            
            for i = 0 to maxsprites
                
                if sprites(i).inuse = 1 and sprites(i).x = selx% and sprites(i).y = sely% then
                    
                    sprites(i).inuse = 0
                    
                end if
                
            next i
            
            for i = 0 to maxdblocks
                
                if dblocks(i).inuse = 1 and dblocks(i).x = selx% and dblocks(i).y = sely% then
                    
                    dblocks(i).inuse = 0
                    
                end if
                
            next i
            
        end if
        
    end if

    if k$ = "s" then
        
        f = freefile
        open mapfile for output as #f
        
            print #f, set$
            print #f, mapsizex, mapsizey
            print #f, playerx%, playery%
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    print #f, map(x + y * 128), "";
                    
                next x
                
                print #f, ""
            next y
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    print #f, fmap(x + y * 128), "";
                    
                next x
                
                print #f, ""
            next y
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    print #f, cmap(x + y * 128), "";
                    
                next x
                
                print #f, ""
            next y
            
            spritecount% = 0
            for i = 0 to maxsprites-1
                
                if sprites(i).inuse then spritecount% = spritecount% + 1
                
            next i
            
            print #f, spritecount%
            
            for i = 0 to maxsprites-1
                
                if sprites(i).inuse then
                    
                    print #f, sprites(i).x, sprites(i).y, sprites(i).sprite, sprites(i).collisionradius
                    
                end if
                
            next i

            doorcount% = 0
            for i = 0 to maxdoors-1
                
                if doors(i).inuse then doorcount% = doorcount% + 1
                
            next i
            
            print #f, doorcount%
            
            for i = 0 to maxdoors-1
                
                if doors(i).inuse then
                    
                    print #f, i, doors(i).texture, doors(i).locked, doors(i).hORv
                    
                end if
                
            next i
            
            dblockcount% = 0
            for i = 0 to maxdblocks
                
                if dblocks(i).inuse then dblockcount% = dblockcount% + 1
                
            next i

            print #f, dblockcount%
            
            for i = 0 to maxdblocks
                
                if dblocks(i).inuse then
                
                    print #f, dblocks(i).x, dblocks(i).y
                    print #f, dblocks(i).texture
                    
                end if
                
            next i

        close #f

    end if
    
    pcopy 1, 0
    
    while (timer-framestart) < (1/30): wend
    
loop until multikey(1)