    
    
    ''''''''''''''''''''''''''''''''''''
    '                                  '
    '   Raycasting Engine, version 8   '
    '   by Chris Adams (aka Lithium)   '
    '                                  '
    ''''''''''''''''''''''''''''''''''''
    
    '
    '   Please note
    '   -----------
    '
    '       - playerx (double), playery (double), playerangle (dobule)
    '         ALWAYS contain the position and angle of the viewport.
    '       - All angles are in radians
    '
    '       - 'loadMap' cannot be called until 'setScreenRes' is called
    '       - The lowercase filename (without directory and extension) of
    '         the current map in memory is stored in the variable 'currentMap'
    '         this can be used for scripting purposes.
    '  
    '       - The playerradius constant is used by the engine.
    '
    '       - This engine has a low-resolution problem fix (using a higher
    '         resolution, and stretching everything -- No for this to work
    '         seemlessly in your game, you must use the graphics functions
    '         provided, instead of fbgfx's -- (bufferPut & bufferPset)
    '

    defint a-z
    
    '$include: 'fbgfx.bi'
    
    ' Constants marked with a star are needed by the engine
    
    const pi = 3.141598 ' *
    const anglefix = pi/2 ' *
    const texturesize = 64 ' ** do not change **
    const onetexture = (texturesize * texturesize * 4) + 4 ' *
    const playerradius = 0.2 ' * now used
    
    const maxsprites = 128 ' *
    const maxdoors = 128 ' *
    const maxtextures = 128 ' *
    const maxspriteimages = 128 ' *
    const maxdblocks = 128 ' *
    
    const horizontal = 0 ' *
    const vertical = 1 ' *
    const opening = 1 ' *
    const closing = 0 ' *
    
    const dleft = 0
    const dright = 1
    const dtop = 2
    const dbottom = 3
    
    const totaljumptime = 1 ' seconds
    const gravity = -200 ' pixels/second/second
    const initialjumpvelocity = -totaljumptime * gravity
    
    const totalcrouchtime = 1
    const initialcrouchvelocity = -totalcrouchtime * -gravity
    
    type spritetype
        
        inuse as integer
        x as double
        y as double
        z as double
        sprite as integer
        collisionradius as double
        
    end type
    
    type dblock
        
        inuse as integer
        x as double
        y as double
        x1 as double
        y1 as double
        x2 as double
        y2 as double
        starttime as double
        movetime as double
        lasttime as double
        texture as integer
        presistant as integer
        
    end type
    
    type projectedsprite
        
        scrx as integer
        yoff as integer
        distance as integer
        sprite as integer
        show as integer
        
    end type
    
    type door
        
        inuse as integer
        amtopen as single
        texture as integer
        locked as integer
        hORv as integer
        oORc as integer
        
    end type
    
    ' loadConfiguration
    ' -----------------
    '
    ' Note: Must be called first
    '
    declare sub loadConfiguration ( )
    
    declare sub setScreenRes ( )

    ' renderFrame
    ' -----------
    '
    ' lookVertical: Angle by which to "rotate" the view along the Z axis (for looking up and down)
    '               -pi/2 is straight down, pi/2 is straight up
    '
    ' verticalPosition: Position on the Z axis of the camera, 75 is max up, -75 is max down
    '
    declare sub renderFrame ( lookVertical as double, verticalPosition as integer )

    ' bufferPoint
    ' ----------
    '
    ' Note: Use this function instead of fbfgx's pset, use after renderFrame, but
    '       before hiresStretch.
    '
    ' x, y: coordinates of pixel (on a 320x200 surface)
    '
    ' Returns: Colour of pixel at coordinates
    '
    declare function bufferPoint ( x as integer, y as integer ) as integer
    
    ' bufferPset
    ' ----------
    '
    ' Note: Use this function instead of fbfgx's pset, use after renderFrame, but
    '       before hiresStretch.
    '
    ' x, y: coordinates of pixel (on a 320x200 surface)
    '
    ' colour: colour of pixel (32bit)
    '
    declare sub bufferPset ( x as integer, y as integer, _
                             colour as integer )

    ' bufferPut
    ' ---------
    '
    ' Note: Use this function instead of fbfgx's put, use after renderFrame, but
    '       before hiresStretch.
    '
    ' sprptr: point to fbgfx sprite
    '
    ' x, y: cooridnates of sprite (on a 320x200 surface)
    '
    ' transparent: 1 (Skip pixels with colour RGB(0, 0, 0))
    '              0 (No transparencey)
    '
    ' opacity: Opacity of sprite, 0 to 255
    '
    declare sub bufferPut ( sprptr as integer, _
                            x as integer, y as integer, _
                            transparent as integer, _
                            opacity as integer )

    ' hiresStretch
    ' ------------
    '
    declare sub hiresStretch ( )
    
    ' updateDoors
    ' -----------
    '
    declare sub updateDoors ( )
    
    ' updateDBlocks
    ' -------------
    '
    ' Note: Updates movement of "Dynamic Blocks"
    '    
    declare sub updateDBlocks ( )
    
    ' moveBlockTo
    ' -----------
    '
    ' dbIndex%: Block index (0 .. )
    '
    ' x, y: Coordinates for block to move to
    '
    ' movetime: Time in seconds for the move to take place
    '
    ' stopIfGoing: 1 = Stop block at current position and move to new from there
    '              0 = Don't move if block is already moving
    '
    ' presistant: 1 = If a collision is detected, stop until clear, and then continue
    '             0 = Stop completely at a collision
    '
    ' Returns 1 (true) if the block has been moved, 0 (false) if not
    '
    declare function moveDBlockTo ( dbIndex as integer, _
                                    x as double, y as double, _
                                    movetime as double, _
                                    stopIfGoing as integer, _
                                    presistant as integer )

    ' loadMap
    ' -------
    '
    ' Note: Must be called after setScreenRes
    '
    declare sub loadMap ( mapfile as string )
    
    ' moveOnMap
    ' ---------
    '
    ' Moves a set of coordinates on the map
    '
    ' xpos, ypos: Map coordinate (each tile has a height and width of 1.0)
    '
    ' size: radius of object to be moved (0 to 0.5)
    '
    ' xv, yv: How much to move in x and y
    '
    ' testsprites: 1 if collisions with sprites are to be tested, 0 otherwise
    '
    ' exludesprite: Only used if testsprites is 1, used to exclude a single sprite
    '               from the collision detection (0 if your moving the player)
    '
    declare sub moveOnMap ( xpos as double, ypos as double, _
                            xv as double, yv as double, _
                            size as double, _
                            testsprites as integer, _
                            excludesprite as integer )
    
    ' canmovein
    ' ---------
    '
    ' Note: Same as moveOnMap, accept it just tests to see wether or not that position on the
    '       map is valid
    '
    ' Returns true (1) or false (0)
    '
    declare function canmovein ( x as double, y as double, _
                                 size as double, _
                                 testsprites as integer, _
                                 excludesprite as integer ) as integer
    
    ' collideWithSprites
    ' ------------------
    '
    ' Note: Tests for collision with sprites, similar to canmovein
    '
    declare function collideWithSprites ( xpos as double, ypos as double, _
                                          size as double, _
                                          excludesprite as integer ) as integer
        
    ' openCloseDoor
    ' -------------
    '
    ' doorn: Door index, 0 to ...
    '
    ' Note: Doors are indicated by a negative number on the map, the equation to get
    '       the door index is: index = -map(..) - 1
    '
    ' Note: Opens if closed, closes if open, does nothing if the door is opening or closing
    '
    declare sub openCloseDoor ( doorn as integer )
    
    ' findWall
    ' --------
    '
    ' hitx, hity: Return the location on the map of the hit
    '
    ' distance: Returns the distance from (startx, starty) to (hitx, hity)
    '
    ' Note: Casts a ray into the map, stops after first wall hit
    '
    declare function findWall ( startx as double, starty as double, _
                                xv as double, yv as double, _
                                hitx as double, hity as double, _
                                distance as double ) as integer

    ' angleBetween
    ' ------------
    '
    ' Note: Finds angle in radians between to points
    '
    ' Also: To convert to degrees multiply by 180/pi.
    '
    declare function angleBetween ( x1 as double, y1 as double, _
                                    x2 as double, y2 as double ) as double

    ' spriteInView
    ' ------------
    '
    ' Note: Tests to see if one sprite is visible from another,
    '       within a certain angle range.
    '
    ' fromsprite: The index of the sprite that is looking (0 is [playerx, playery])
    '
    ' viewnangle: Angle in radians of the middle of the view point
    '
    ' viewrange: Range (angle in radians) on either side of viewangle
    '
    ' maxdistance: Maximum distance for the sprite to be in view
    '
    ' tosprite: The index of the sprite you are testing for visibility
    '           (0 is [playerx, playery])
    '
    ' Returns: 1 (if sprite is visible) or 0 (if not)
    '
    declare function spriteInView ( fromsprite as integer, _
                                    viewangle as double, viewrange as double, _
                                    maxdistance as double, _
                                    tosprite as integer ) as integer

    ' firstSpriteHit
    ' --------------
    '
    ' xv and yv: Belong to the unit vector of the angle the ray is being shot.
    '            if you're using angles, do cos(angle), sin(angle)
    '    
    ' Note: Casts a ray out into the map, returns the index of the first
    '       sprite hit + 1 otherwise, 0.
    '
    ' Also: If it returns 1, that means the player has been hit, as the player's
    '       coordinates are stored in sprite 0 for this purpose.
    '       They are updated at every render.
    '
    declare function firstSpriteHit ( startx as double, starty as double, _
                                      xv as double, yv as double, _
                                      distance as double, _
                                      excludesprite as integer ) as integer
                                      
    ' addsprite
    ' ---------
    '
    ' Note: Adds a new sprite
    '
    declare function addsprite ( x as double, y as double, _
                                 image as integer ) as integer
                                 
    ' inDBlock
    ' --------
    '
    ' Note: Tests is point is inside a "Dynamic Block"
    '
    ' x, y: Point coordinates
    '
    ' Returns: 0 If no collision, or the block index + 1 if there is a
    '          collision
    '
    declare function inDBlock ( x as double, y as double, size as double ) as integer
    
    declare function blockInBlock ( byval x1 as double, byval y1 as double, _
                                    byval size1 as double, _
                                    byval x2 as double, byval y2 as double, _
                                    byval size2 as double ) as integer
                     
    declare sub trace ( msg$ )
    
    dim shared fps as double, mousesensitivity as double
    dim shared movespeed as double, doorspeed as double
    
    dim shared currentMap as string
    dim shared mapsizex as integer, mapsizey as integer
    dim shared texturedata ( 0 to maxtextures * onetexture ) as ubyte
    dim shared spritedata ( 0 to maxspriteimages * onetexture ) as ubyte
    dim shared membfr ( 0 to (320 * 200 * 4) - 1 ) as ubyte
    dim shared bgdata ( 0 to (320 * 200 * 4 + 4) ) as ubyte
    dim shared spritecount as integer, doorcount as integer
    dim shared playerx as double, playery as double, playerangle as double
    dim shared doors(0 to maxdoors-1) as door
    dim shared sprites(0 to maxsprites-1) as spritetype
    dim shared dblocks(0 to maxdblocks-1) as dblock
    dim shared map(0 to (128*128)-1) as integer
    dim shared fmap(0 to (128*128)-1) as integer
    dim shared cmap(0 to (128*128)-1) as integer
    dim shared textures as integer, spriteimages as integer
    dim shared floortexture as integer, ceelingtexture as integer
    dim shared darknessred as integer, darknessgreen as integer, darknessblue as integer
    dim shared redlut(0 to 65535) as ubyte, greenlut(0 to 65535) as ubyte, bluelut(0 to 65535) as ubyte
    dim shared depthshading as integer
    dim shared pspr(0 to maxsprites-1) as projectedsprite
    dim shared zbuffer(0 to 319) as integer
    dim shared disablebg as integer
    dim shared hires as integer, xres as integer, yres as integer

    ' Example Start -----------------------------------------------------------------------

    dim blah as double
    dim framestart as double, framerate as double
    dim lastShot as double
 
    defaultMap$ = "test1"
    print "Maps:"
    print
    print "   - atest"
    print "   - dblocks"
    print "   - test1"
    print "   - water"
    print "   - maze"
    print "   - outsidenight"
    print "   - outsideday"
    print
    print "Map to load?: ";
    line input mapFile$
    mapFile$ = trim$(mapFile$)
    if mapFile$ = "" then mapFile$ = defaultMap$
    mapFile$ = "maps/" + mapFile$ + ".map"

    loadConfiguration
    
    setScreenRes
    
    loadMap mapFile$
    
    randomize timer
    
    ' main loop
    
    lastShot = 0
    fireRate = 0.25
    
    lookVertical! = 0
    
    setmouse 0, yres/2, 0
    mousey = yres/2
    
    jumptime# = 0
    
    maxbutterflys = 20
    redim butterFlys(0 to maxbutterflys-1) as integer
    redim butterFlyOffset(0 to maxbutterflys-1) as double
    
    if currentMap = "test1" then
        
        floatingBarrel = addsprite(16.5, 10.5, 3)
        
    elseif currentMap = "outsideday" then
        
        for i = 0 to maxbutterflys-1
            
            do
            
                x# = fix(rnd*mapsizex)
                y# = fix(rnd*mapsizey)
            
            loop until map(x# + y# * 128) = 0
            
            butterFlys(i) = addsprite(x#, y#, 2)
            butterFlyOffset(i) = rnd
            
        next i
        
    end if
    
    starttime# = timer
    frames% = 0
    
    redim waterbuf(0 to 320*200-1) as integer
    redim waterlut(0 to 319) as integer
    
    for i = 0 to 319
        
        waterlut(i) = sin(i/16) * 4
        
    next i

    do
        
        framestart = timer
    
        '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        
        if currentMap = "water" then vpos! = sin(timer*2) * 20

        renderFrame lookVertical#, fix(vpos!)
        
        if currentMap = "water" then
            
            if hires = 0 then
            
                bfr% = 0
            
            else
            
                bfr% = @membfr(0)
            
            end if
            
            off = timer*16
            off2 = (timer+2)*16
            
            screenlock
            
            for x = 0 to 319
                
                nx = x + waterlut((x + off) mod 320)
                
                for y = 0 to 199
                    
                    ny = y + waterlut((y + off2) mod 200)
                    
                    if nx < 0 or ny < 0 or nx > 319 or ny > 199 then
                        
                        waterbuf(x + y * 320) = 12416
                        
                    else
                        
                        if bfr% = 0 then bfr2% = screenptr else bfr2% = bfr%
                        waterbuf(x + y * 320) = peek(integer, bfr2% + (nx shl 2) + ((ny shl 8) + (ny shl 6)) shl 2)
                        
                    end if
                    
                next y
            next x
            
            screenunlock
            
            wbptr% = @waterbuf(0)
            
            if bfr% = 0 then
                
                wdbfr% = screenptr
            
            else
            
                wdbfr% = bfr%
                
            end if
            
            screenlock
            
            asm
                
                mov ecx, [wbptr%]
                mov ebx, [wdbfr%]
                mov edx, 0
                
            waterLoop:
            
                mov eax, [ecx]
                mov [ebx], eax
                
                add edx, 4
                add ecx, 4
                add ebx, 4
                cmp edx, 256000
                jl waterLoop
                
            end asm
            
            screenunlock
            
        end if
        
        hiresStretch
        
        locate 1, 1: print framerate; " fps"
        
        screencopy 1, 0
        
        '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        
        getmouse newmousex, newmousey, , buttons%
        
        if newmousex = xres-1 then
            
            setmouse 1, newmousey
            mousepage = mousepage + 1
            newmousex = 1
        
        elseif newmousex = 0 then
        
            setmouse xres-2, newmousey
            mousepage = mousepage - 1
            newmousex = xres-2
        
        end if
    
        if newmousey = yres-1 then
            
            setmouse newmousex, 1
            mousepagey = mousepagey + 1
            newmousey = 1
            
        elseif newmousey = 0 then
            
            setmouse newmousex, yres-2
            mousepagey = mousepagey - 1
            newmousey = yres-2
            
        end if
    
        newmousex = newmousex + mousepage * xres
        newmousey = newmousey + mousepagey * yres
        
        if newmousex <> mousex then
            
            playerangle = playerangle + 2*pi*(((mousex - newmousex)) / (640 * (11 - mousesensitivity)))
            
            if playerangle >= 2*pi then playerangle = playerangle - 2*pi
            if playerangle < 0 then playerangle = playerangle + 2*pi
            
        end if
        
        if newmousey <> mousey then
            
            lookVertical# = lookVertical# + ((mousey - newmousey)) / (pi * 800 / mousesensitivity)
            if lookVertical# > pi/2 then lookVertical# = pi/2
            if lookVertical# < -pi/2 then lookVertical# = -pi/2

        end if

        mousex = newmousex
        mousey = newmousey
        
        vx# = 0
        vy# = 0
        
        jt# = timer - jumptime#
        ct# = timer - crouchtime#
        
        if multikey(SC_SPACE) and jt# > totaljumptime and ct# > totalcrouchtime then ' jump
            
            jumptime# = timer
            
        end if
        
        if multikey(SC_CONTROL) and jt# > totaljumptime then
            
            if ct# > totalcrouchtime then
            
                crouchtime# = timer
                
            elseif ct# > totalcrouchtime/2 then
                
                crouchtime# = timer - (totalcrouchtime/2)
                ct# = timer - crouchtime#
                
            end if
            
        end if
        
        if jt# <= totaljumptime then
            
            vpos! = (gravity*jt#*jt#) + (initialjumpvelocity*jt#)
            
        elseif ct# <= totalcrouchtime then
            
            vpos! = (-gravity*ct#*ct#) + (initialcrouchvelocity*ct#)
            
        else
            
            vpos! = 0
            
        end if
        
        if multikey(SC_A) then ' strafe left
            
            vx# = vx# + cos(playerangle+anglefix)
            vy# = vy# + sin(playerangle+anglefix)
            
        end if
        if multikey(SC_D) then ' strafe right
    
            vx# = vx# - cos(playerangle+anglefix)
            vy# = vy# - sin(playerangle+anglefix)
    
        end if
        if multikey(SC_W) then ' up
            
            vx# = vx# + cos(playerangle)
            vy# = vy# + sin(playerangle)
            
        end if
        if multikey(SC_S) then ' down
    
            vx# = vx# - cos(playerangle)
            vy# = vy# - sin(playerangle)
    
        end if
        if (buttons% and 2) = 2 then ' open/use
            
            frontx# = playerx + cos(playerangle) * 0.5
            fronty# = playery + sin(playerangle) * 0.5
            
            for i = 0 to maxdblocks-1
                
                if dblocks(i).inuse then
                    
                    bi% = inDBlock(frontx#, fronty#, 0) - 1
                    
                    if bi% >= 0 then
                        
                        if abs(cos(playerangle)) > abs(sin(playerangle)) then
                            
                            dx = sgn(cos(playerangle))
                            dy = 0
                            
                        else
                            
                            dx = 0
                            dy = sgn(sin(playerangle))
                            
                        end if
                        
                        nx# = dblocks(bi%).x + dx
                        ny# = dblocks(bi%).y + dy
                        
                        d# = sqr((dblocks(bi%).x - nx#)^2 + (dblocks(bi%).y - ny#)^2)
                        t# = 2.0 / d#
                        
                        'if map(fix(dblocks(bi%).x + dx) + fix(dblocks(bi%).y + dy) * 128) = 0 then
                        
                            moveDBlockTo ( bi%, _
                                           nx#, ny#, _
                                           t#, _
                                           1, _
                                           0 )
                        
                        'end if
                        
                    end if
                    
                end if
                
            next i
                
            frontx# = playerx + cos(playerangle) * 0.85
            fronty# = playery + sin(playerangle) * 0.85
                
            hit% = map(fix(frontx#) + fix(fronty#) * 128)
                
            if hit% < 0 and doors(-hit% - 1).locked = 0 then openCloseDoor(-hit%)
            
        end if
        if (buttons% and 1) and ((timer - fireRate) >= lastShot) then ' shoot
            
            sprHit% = firstSpriteHit ( playerx, playery, _
                                       cos(playerangle), sin(playerangle), _
                                       blah, _
                                       0 )
                                       
            if sprHit% > 0 then
                
                sprN% = sprHit% - 1
                
                sprites(sprN%).sprite = (sprites(sprN%).sprite + 1)
                if sprites(sprN%).sprite > spriteimages then sprites(sprN%).sprite = 1
                
            end if
            
            lastShot = timer
            
        end if
        
        if vx# <> 0 or vy# <> 0 then
            
            mag# = sqr(vx#*vx# + vy#*vy#)
            
            vx# = vx# / mag#
            vy# = vy# / mag#
    
            moveOnMap ( playerx, playery, _
                        vx# * movespeed, _
                        vy# * movespeed, _
                        playerradius, _
                        1, _
                        0 )
    
        end if
    
        updateDoors
        updateDBlocks
        
        if currentMap = "maze" then
            
            if fix(playerx) = 23 and fix(playery) = 14 then
                loadmap "maps\light.map"
            end if
        
        elseif currentMap = "test1" then
            
            sprites(floatingBarrel).z = 0.25 + (sin(timer*pi/1.5) / 4)
            
        elseif currentMap = "outsideday" then
            
            for i = 0 to maxbutterflys-1
                
                bx# = sprites(butterFlys(i)).x
                by# = sprites(butterFlys(i)).y
                
                pdx# = playerx - bx#
                pdy# = playery - by#
                
                dist# = sqr(pdx#*pdx# + pdy#*pdy#)
                
                if dist# < 4 then
                    
                    vx# = (-pdx# / dist#) * (1 / fps / dist#)
                    vy# = (-pdy# / dist#) * (1 / fps / dist#)
                    
                    moveOnMap ( bx#, by#, _
                                vx#, vy#, _
                                0.2, _
                                0, 0 )
                                
                else
                    
                    vx# = rnd * (1 / fps) - (1 / fps / 2)
                    vy# = rnd * (1 / fps) - (1 / fps / 2)
                    
                    moveOnMap ( bx#, by#, _
                                vx#, vy#, _
                                0.2, _
                                0, 0 )
                    
                end if
                
                sprites(butterFlys(i)).x = bx#
                sprites(butterFlys(i)).y = by#
                
                sprites(butterFlys(i)).sprite = 2 + (fix((timer + butterFlyOffset(i))*2) and 1)
                sprites(butterFlys(i)).z = sprites(butterFlys(i)).z + (2 * rnd / fps) - (1 / fps)
                
                if sprites(butterFlys(i)).z < -0.3 then sprites(butterFlys(i)).z = -0.3
                if sprites(butterFlys(i)).z > 0.3 then sprites(butterFlys(i)).z = 0.3
                
            next i
            
        end if
    
        '''''''''''''''''''''''''''''''''''''''''''''
    
        while (timer - framestart) <= (1 / fps): wend
        
        frames% = frames% + 1
        framerate = cint(1 / ((timer - starttime#) / frames%))
        
        if (timer - starttime#) >= 1 then
            frames% = 0
            starttime# = timer
        end if
        
    loop until multikey(&h1)

    ' Example End -------------------------------------------------------------------------

    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    
    defdbl a-z
    sub moveOnMap ( xpos as double, ypos as double, _
                    xv as double, yv as double, _
                    size as double, _
                    testsprites as integer, _
                    excludesprite as integer )
        
        newx = xpos + xv
        newy = ypos + yv
        
        'vmag = sqr(xv * xv + yv * yv)
        'uxv = xv / vmag
        'uyv = yv / vmag
        
        if canmovein ( newx, ypos, size, testsprites, excludesprite ) then xpos = newx
        if canmovein ( xpos, newy, size, testsprites, excludesprite ) then ypos = newy
        
    end sub
    
    defdbl a-z
    function canmovein ( x as double, y as double, _
                         size as double, _
                         testsprites as integer, _
                         excludesprite as integer ) as integer
        
        if indblock(x, y, size) then
            
            return 0
        
        end if
        
        'onmap% = map(fix(x) + fix(y) * 128)
        
        if testsprites and collideWithSprites(x, y, size, excludesprite) > 0 then return 0
        
        for tx = fix(x) - 1 to fix(x) + 1
            
            for ty = fix(y) - 1 to fix(y) + 1
              
              if tx >= 0 and ty >= 0 and tx < mapsizex and ty < mapsizey then
                
                onmap% = map(tx + ty * 128)
                
                if onmap% > 0 then
                    
                    if blockInBlock ( tx, ty, 1.0, x - size, y - size, size*2 ) = 1 then return 0
                    
                elseif onmap% < 0 then
                    
                    if doors(-onmap% - 1).amtopen < 48 then
                        
                        if blockInBlock ( tx, ty, 1.0, x - size, y - size, size*2 ) = 1 then return 0
                        
                    end if
                    
                end if                
                
              end if
              
            next ty
            
        next tx
        
        return 1
    
    end function
    
    defdbl a-z
    function collideWithSprites ( xpos as double, ypos as double, _
                                  size as double, _
                                  excludesprite as integer ) as integer
        
        for i = 0 to maxsprites-1
            
            if sprites(i).inuse and excludesprite <> i then
            
                if sprites(i).collisionradius > 0 then
                
                    minDistSq = (size + sprites(i).collisionradius) ^ 2
                    
                    distSq = ((xpos - (sprites(i).x))) ^ 2 + ((ypos - (sprites(i).y)) ^ 2)
                    
                    if distSq <= minDistSq then return (i+1)
                    
                end if
            
            end if
            
        next i
        
        return 0
        
    end function
    
    defdbl a-z
    sub openCloseDoor ( doorn as integer )
        
        dn% = doorn - 1
        
        if doors(dn%).oORc = opening and doors(dn%).amtopen = 64 then doors(dn%).oORc = closeing
        if doors(dn%).oORc = closing and doors(dn%).amtopen = 0 then doors(dn%).oORc = opening
        
    end sub
    
    defdbl a-z
    function angleBetween ( x1 as double, y1 as double, _
                            x2 as double, y2 as double ) as double
    
        dx = x2 - x1
        dy = y2 - y1
        
        ang = atn(dy / dx)
        
        if dy < 0 then
            
            if dx < 0 then
                
                return ang + pi
                
            else
                
                return pi + pi + ang
                
            end if
            
        else
            
            if dx < 0 then
                
                return ang + pi

            else
            
                return ang
    
            end if
            
        end if
        
    end function
    
    defdbl a-z
    function spriteInView ( fromsprite as integer, _
                            viewangle as double, viewrange as double, _
                            maxdistance as double, _
                            tosprite as integer ) as integer
                
        fromx = sprites(fromsprite).x
        fromy = sprites(fromsprite).y        
        sx = sprites(tosprite).x
        sy = sprites(tosprite).y
        
        ang = angleBetween(fromx, fromy, sx, sy)

        if abs(sin(ang - viewangle)) < abs(sin(viewrange)) then
        
            dx = sx - fromx
            dy = sy - fromy
            dist = sqr(dx*dx + dy*dy)
            dx = dx / dist
            dy = dy / dist
            
            retdist = 0
           
            if firstSpriteHit(fromx + cos(viewangle+pi/2), fromy + sin(viewangle+pi/2), dx, dy, retdist, fromsprite) = (tosprite+1) then
                
                if retdist <= maxdistance then return 1
                
            end if
            
            retdist = 0

            if firstSpriteHit(fromx + cos(viewangle-pi/2*2), fromy + sin(viewangle-pi/2), dx, dy, retdist, fromsprite) = (tosprite+1) then
                
                if retdist <= maxdistance then return 1
                
            end if
            
            retdist = 0

            if firstSpriteHit(fromx, fromy, dx, dy, retdist, fromsprite) = (tosprite+1) then
                
                if retdist <= maxdistance then return 1
                
            end if
            
        end if
        
        return 0

    end function
    
    defdbl a-z
    function firstSpriteHit ( startx as double, starty as double, _
                              xv as double, yv as double, _
                              distance as double, _
                              excludesprite as integer ) as integer
        
        dx = xv
        dy = yv
        
        m = dy / dx
        pm = -1 / m
    
        minSpr% = 0
        'minDist = 128*128*2
        
        for i = 0 to maxsprites-1
            
            if sprites(i).inuse and excludesprite <> i and startx <> sprites(i).x and starty <> sprites(i).y then
            
                sradius = sprites(i).collisionradius
                
                sprx = sprites(i).x
                spry = sprites(i).y
                
                if sradius > 0 then
                    
                    x = (spry - starty + (startx * m) - (sprx * pm)) / (m - pm)
                    y = starty + (x - startx) * m
                    
                    if sgn(x - startx) = sgn(dx) then
                    
                        cdx = sprx - x
                        cdy = spry - y
                        
                        if (cdx*cdx + cdy*cdy) <= (sradius * sradius) then
                            
                            cdistance = ((sprx - startx) ^ 2) + ((spry - starty) ^ 2)
                            
                            if cdistance < minDist or minSpr% = 0 then
                                
                                minSpr% = i+1
                                minDist = cdistance
                                
                            end if
                            
                        end if
                    
                    end if
                    
                end if
            
            end if
            
        next i
        
        if minSpr% = 0 then return 0
        
        wallDist = 0
        
        ret% = findWall ( startx, starty, _
                          cos(playerangle), sin(playerangle), _
                          blah, blah, _
                          wallDist )
                          
        if (wallDist*wallDist) < minDist then
            
            return 0
            
        else
            
            distance = sqr(minDist)        
            
            return minSpr%
            
        end if
        
    end function
    
    defdbl a-z
    function findWall ( startx as double, starty as double, _
                        xv as double, yv as double, _
                        hitx as double, hity as double, _
                        distance as double ) as integer
        
        rdx = xv
        rdy = yv
    
        getx = rdx / rdy
        gety = rdy / rdx
    
        hitA% = 0
        hitB% = 0
        obA% = 0
        obB% = 0
        
        mposHit% = 0
        
        for i% = 0 to 182
    
            if hitA% = 0 and obA% = 0 then
                
                Ax = fix(startx) + (sgn(rdx) * i%)
                
                if sgn(Ax - startx) = sgn(rdx) then
                
                    Ay = starty + (Ax - startx) * gety
                    
                    if Ax < 0 or Ay < 0 or Ax >= mapsizex or Ay >= mapsizey then
                        
                        obA% = 1
                    
                    else
                    
                        mposA% = fix(Ax + (sgn(rdx) / 2)) + (fix(Ay) shl 7)
                        
                        if map(mposA%) > 0 then
                            
                            hitA% = 1
                            
                        elseif map(mposA%) < 0 then
                            
                            Ax = fix(startx) + (sgn(rdx) * (i% + 0.5))
                            Ay = starty + (Ax - startx) * gety
                            
                            if not (Ax < 0 or Ay < 0 or Ax >= mapsizex or Ay >= mapsizey) then
                            
                                mposA% = fix(Ax) + (fix(Ay) shl 7)
                                
                                if map(mposA%) < 0 then
                                    
                                    doorno% = abs(map(mposA%)) - 1
                                    
                                    if doors(doorno%).hORv = vertical then
                                    
                                        if ((fix(Ay*texturesize) and 63) - doors(doorno%).amtopen) >= 0 then hitA% = 1
                                        
                                    end if
                                    
                                end if
                            
                            end if
                            
                        end if
                    
                    end if
            
                end if
            
            end if
        
            if hitB% = 0 and obB% = 0 then
                
                By = fix(starty) + (sgn(rdy) * i%)
                
                if sgn(By - starty) = sgn(rdy) then
                
                    Bx = startx + (By - starty) * getx
        
                    if Bx < 0 or By < 0 or Bx >= mapsizex or By >= mapsizey then
                        
                        obB% = 1
                    
                    else
                        
                        mposB% = fix(Bx) + (fix(By + (sgn(rdy) / 2)) shl 7)
        
                        if map(mposB%) > 0 then
                            
                            hitB% = 1
                            
                        elseif map(mposB%) < 0 then
                            
                            By = fix(starty) + (sgn(rdy) * (i% + 0.5))
                            Bx = startx + (By - starty) * getx
                            
                            if not (Bx < 0 or By < 0 or Bx >= mapsizex or By >= mapsizey) then
                            
                                mposB% = fix(Bx) + (fix(By) shl 7)
                                ' + (sgn(rdx) / 2)
                                
                                if map(mposB%) < 0 then
                                    
                                    doorno% = abs(map(mposB%)) - 1
                                    
                                    if doors(doorno%).hORv = horizontal then
                                    
                                        if ((fix(Bx*texturesize) and 63) - doors(doorno%).amtopen) >= 0 then hitB% = 1
                                    
                                    end if
                                    
                                end if
                            
                            end if
                            
                        end if
                        
                    end if
                
                end if
                
            end if
        
            if (obA% = 1 or hitA% = 1) and (obB% = 1 or hitB% = 1) then exit for
                
        next i%
        
        AdistSq = (startx-Ax)^2 + (starty-Ay)^2
        BdistSq = (startx-Bx)^2 + (starty-By)^2
        
        if obA% = 0 and (obB% or (AdistSq < BdistSq)) then
            
            hitx = Ax
            hity = Ay
            
            dbHitDsq = AdistSq
            mposHit% = mposA%
            
        else
    
            hitx = Bx
            hity = By
            
            dbHitDsq = BdistSq
            
            mposHit% = mposB%
            
        end if    

        for j% = 0 to maxdblocks-1
            
            if dblocks(j%).inuse then
            
                ' left side
                if rdx > 0 then
                    
                    x = dblocks(j%).x                
                    y = playery + (x - playerx) * gety
                    
                    if sgn(y - playery) = sgn(rdy) and y >= dblocks(j%).y and y < (dblocks(j%).y + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            mposHit% = -(j%+1)
                            dbHitSide% = dleft
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                    
                ' right side
                elseif rdx < 0 then
                    
                    x = dblocks(j%).x + 0.999999           
                    y = playery + (x - playerx) * gety
                    
                    if sgn(y - playery) = sgn(rdy) and y >= dblocks(j%).y and y < (dblocks(j%).y + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            mposHit% = -(j%+1)
                            dbHitSide% = dright
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                
                end if
                
                ' top side
                if rdy > 0 then
                    
                    y = dblocks(j%).y                
                    x = playerx + (y - playery) * getx
                    
                    if sgn(x - playerx) = sgn(rdx) and x >= dblocks(j%).x and x < (dblocks(j%).x + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            mposHit% = -(j%+1)
                            dbHitSide% = dtop
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                    
                ' bottom side
                elseif rdy < 0 then
                    
                    y = dblocks(j%).y + 0.999999              
                    x = playerx + (y - playery) * getx
                    
                    if sgn(x - playerx) = sgn(rdx) and x >= dblocks(j%).x and x < (dblocks(j%).x + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            mposHit% = -(j%+1)
                            dbHitSide% = dbottom
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                    
                end if
                
            end if
            
        next j%
        
        distance = sqr(dbHitDsq)
        
        return mposHit%

    end function
    
    defdbl a-z
    sub loadmap ( mapfile as string )
        
        dim tored as integer, togreen as integer, toblue as integer
        
        f = freefile
        open mapfile for input as #f
        
            line input #f, set$
        
            f2 = freefile
            open set$ for input as #f2
            
                line input #f2, texturepre$
                input #f2, textures
                line input #f2, spritepre$
                input #f2, spriteimages
                input #f2, floortexture, ceelingtexture
                
                redim cr(0 to spriteimages-1) as double
                
                for i = 0 to spriteimages-1
                    input #f2, cr(i)
                next i
                
                input #f2, darknessred, darknessgreen, darknessblue
                input #f2, depthshading
                
                input #f2, tored, togreen, toblue, shadesky
                
                input #f2, bgimg$
                if lcase$(trim$(bgimg$)) = "nobg" then disablebg = 1 else disablebg = 0
            
            close #f2
            
            input #f, mapsizex, mapsizey
            input #f, playerx, playery
            
            playerx = playerx + 0.5
            playery = playery + 0.5
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    input #f, map(x + y * 128)
                    
                next x
            next y
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    input #f, fmap(x + y * 128)
                    
                next x
            next y
            
            for y = 0 to mapsizey-1
                for x = 0 to mapsizex-1
                    
                    input #f, cmap(x + y * 128)
                    
                next x
            next y
            
            input #f, spritecount%
            
            sprites(0).inuse = 1
            sprites(0).x = playerx
            sprites(0).y = playery
            sprites(0).collisionradius = playerradius
           
            for i = 1 to spritecount%
                
                sprites(i).inuse = 1
                input #f, sprites(i).x, sprites(i).y, sprites(i).sprite, sprites(i).collisionradius
                sprites(i).x = sprites(i).x + 0.5
                sprites(i).y = sprites(i).y + 0.5
                sprites(i).collisionradius = cr(sprites(i).sprite-1)
                
            next i
            
            for i = spritecount%+1 to maxsprites-1
                
                sprites(i).inuse = 0
                
            next i
    
            input #f, doorcount%
            
            for i = 0 to doorcount%-1
                
                input #f, j
                
                doors(j).inuse = 1
                input #f, doors(j).texture, doors(j).locked, doors(j).hORv
                
            next i
            
            input #f, dblockcount%
            
            for i = 0 to dblockcount%-1
                
                dblocks(i).inuse = 1
                input #f, dblocks(i).x, dblocks(i).y
                input #f, dblocks(i).texture
                dblocks(i).starttime = 0
                dblocks(i).lasttime = 0
                
            next i
            
            if depthshading then
                
                for c% = 0 to 255
                    for d% = 0 to 255
                        
                        f = sqr(d%) / 16
                        if f > 1 then f = 1
                        lp% = c% + (d% shl 8)
                        
                        redlut(lp%) = fix(c% + (tored - c%) * f) shr darknessred
                        greenlut(lp%) = fix(c% + (togreen - c%) * f) shr darknessgreen
                        bluelut(lp%) = fix(c% + (toblue - c%) * f) shr darknessblue
                        
                    next d%
                next c%
                
            else

                for c% = 0 to 255
                    for d% = 0 to 255
                        
                        lp% = c% + (d% shl 8)
                        
                        redlut(lp%) = c% shr darknessred
                        greenlut(lp%) = c% shr darknessgreen
                        bluelut(lp%) = c% shr darknessblue
                        
                    next d%
                next c%

            end if
            
        close #f
        
        startPos% = 1
        endPos% = len(mapfile)
        for i% = len(mapfile) to 1 step -1
            if startPos% = 1 and mid$(mapfile, i%, 1) = "\" or mid$(mapfile, i%, 1) = "/" then
                startPos% = i% + 1
            end if
            if endPos% = len(mapfile) and mid$(mapfile, i%, 1) = "." then
                endPos% = i% - 1
            end if
        next i%
        
        currentMap = lcase$(mid$(mapfile, startPos%, endPos% - startPos% + 1))
    
        texturepre$ = trim$(texturepre$)
        for i = 0 to textures-1
            
            file$ = texturepre$ + ltrim$(str$(i+1)) + ".bmp"
            bload file$, varptr(texturedata(onetexture * i))
            
        next i
        
        spriteptr$ = trim$(spritepre$)
        for i = 0 to spriteimages-1
            
            file$ = spritepre$ + ltrim$(str$(i+1)) + ".bmp"
            bload file$, varptr(spritedata(onetexture * i))
            
        next i
        
        if disablebg = 0 then
            
            bload bgimg$, varptr(bgdata(0))
            
            if depthshading then
                
                f = shadesky
                
                for o% = 4 to (4*320*200)+4 step 4
                    
                    b% = bgdata(o%+0)
                    g% = bgdata(o%+1)
                    r% = bgdata(o%+2)
                    
                    r% = fix(r% + (tored - r%) * f) shr darknessred
                    g% = fix(g% + (togreen - g%) * f) shr darknessgreen
                    b% = fix(b% + (toblue - b%) * f) shr darknessblue
                    
                    bgdata(o%+0) = b%
                    bgdata(o%+1) = g%
                    bgdata(o%+2) = r%

                next o%
            
            end if
        
        else
        
            if depthshading > 0 and shadesky = 1 then
                
                r% = tored shr darknessred
                g% = togreen shr darknessgreen
                b% = toblue shr darknessblue
                
                for o% = 4 to (4*320*200)+4 step 4
                    
                    bgdata(o%+0) = b%
                    bgdata(o%+1) = g%
                    bgdata(o%+2) = r%

                next o%
            
                disablebg = 0
            
            end if

        end if
    
    end sub
    
    defdbl a-z
    sub setScreenRes ( )
        
        if hires = 0 then
            xres = 320
            yres = 200
        elseif hires = 1 then
            xres = 640
            yres = 400
        else
            xres = 640
            yres = 480
        end if
            
        screenres xres, yres, 32, 2, &h1
            
        screenset 1, 0
        
    end sub
    
    defint a-z
    function bufferPoint ( x as integer, y as integer ) as integer
        
        if x < 0 or y < 0 or x > 319 or y > 199 then
            
            return 0
            
        else
            
            screenlock
            
            pxl% = peek(integer, (x shl 2) + (y * 1280) + screenptr)
            
            screenunlock
            
            return pxl%
            
        end if
        
    end function
    
    defint a-z
    sub bufferPset ( x as integer, y as integer, _
                     colour as integer )
        
        if x < 0 or y < 0 or x > 319 or y > 199 then exit sub
        
        screenlock
        
        if hires = 0 then
            
            poke integer, (x shl 2) + (y * 1280) + screenptr, colour
            
        else
        
            poke integer, (x shl 2) + (y * 1280) + @membfr(0), colour
            
        end if
            
        screenunlock
        
    end sub
    
    defint a-z
    sub bufferPut ( sprptr as integer, _
                    x as integer, y as integer, _
                    transparent as integer, _
                    opacity as integer )
        
        xsize = peek(unsigned short, sprptr) shr 3
        ysize = peek(unsigned short, sprptr+2)
        scrStartx = x
        scrStarty = y
        scrEndx = x + xsize - 1
        scrEndy = y + ysize - 1
        sprStartx = 0
        sprStarty = 0
        sprEndx = xsize - 1
        sprEndy = ysize - 1
        
        if x <= -xsize or y <= -ysize or x > 319 or y > 199 then
            
            exit sub
            
        end if
        
        if x < 0 then
            
            scrStartx = 0
            sprStartx = -x
        
        end if
        
        if scrEndx > 319 then
            
            sprEndx = sprEndx - (scrEndx - 319)
            scrEndx = 319
            
        end if
        
        if y < 0 then
            
            scrStarty = 0
            sprStarty = -y
            
        end if

        if scrEndy > 199 then
            
            sprEndy = sprEndy - (scrEndy - 199)
            scrEndy = 199
            
        end if
        
        sprCsizex = sprEndx - sprStartx
        sprCsizey = sprEndy - sprStarty

        screeny = scrStarty * 1280
        spry = sprptr + 4 + (sprStarty * (xsize shl 2))

        if hires then
            
            screeny = screeny + @membfr(0)
            
        else 
            
            screeny = screeny + screenptr
            
        end if
        
        if opacity = 0 then exit sub
        
        if opacity < 255 then
            
            al = opacity
            bl = 255 - opacity

            if transparent then
                
                for yy = sprStarty to sprEndy
        
                    screenlock
        
                    screenx = scrStartx
                    for sprx = sprStartx to sprEndx

                        colour = peek(integer, spry + (sprx shl 2))
                        
                        if colour > 0 then
                            
                            scrpos = screeny + (screenx shl 2)                        
                        
                            scolour = peek(integer, scrpos)
                            
                            r = (((colour shr 16) shl 8) * al) shr 16
                            g = ((((colour shr 8) and 255) shl 8) * al) shr 16
                            b = (((colour and 255) shl 8) * al) shr 16
                            
                            sr = (((scolour shr 16) shl 8) * bl) shr 16
                            sg = ((((scolour shr 8) and 255) shl 8) * bl) shr 16
                            sb = (((scolour and 255) shl 8) * bl) shr 16
                            
                            colour = ((r + sr) shl 16) or ((g + sg) shl 8) or (b + sb)
                            
                            poke integer, scrpos, colour
                            
                        end if
                        
                        screenx = screenx + 1
                    next sprx
                    
                    screenunlock
                    
                    screeny = screeny + 1280  
                    spry = spry + (xsize shl 2)
                next spry
            
            else
    
                for yy = sprStarty to sprEndy
                    
                    screenlock
        
                    screenx = scrStartx
                    for sprx = sprStartx to sprEndx
                        
                        colour = peek(integer, spry + (sprx shl 2))
                        
                        scrpos = screeny + (screenx shl 2)                        
                    
                        scolour = peek(integer, scrpos)
                        
                        r = (((colour shr 16) shl 8) * al) shr 16
                        g = ((((colour shr 8) and 255) shl 8) * al) shr 16
                        b = (((colour and 255) shl 8) * al) shr 16
                        
                        sr = (((scolour shr 16) shl 8) * bl) shr 16
                        sg = ((((scolour shr 8) and 255) shl 8) * bl) shr 16
                        sb = (((scolour and 255) shl 8) * bl) shr 16
                        
                        colour = ((r + sr) shl 16) or ((g + sg) shl 8) or (b + sb)
                        
                        poke integer, scrpos, colour
                            
                        screenx = screenx + 1
                    next sprx
                    
                    screenunlock
                    
                    spry = spry + (xsize shl 2)
                    screeny = screeny + 1280            
                next spry
    
            end if
        
        else

            if transparent then
                
                for yy = sprStarty to sprEndy
        
                    screenlock
        
                    screenx = scrStartx
                    for sprx = sprStartx to sprEndx
                        
                        colour = peek(integer, spry + (sprx shl 2))
                        
                        if colour > 0 then poke integer, screeny + (screenx shl 2), colour
                        
                        screenx = screenx + 1
                    next sprx
                    
                    screenunlock
                    
                    screeny = screeny + 1280  
                    spry = spry + (xsize shl 2)
                next spry
            
            else
    
                for yy = sprStarty to sprEndy
                    
                    screenlock
        
                    screenx = scrStartx
                    for sprx = sprStartx to sprEndx
                        
                        colour = peek(integer, spry + (sprx shl 2))
                        
                        poke integer, screeny + (screenx shl 2), colour
                        
                        screenx = screenx + 1
                    next sprx
                    
                    screenunlock
                    
                    spry = spry + (xsize shl 2)
                    screeny = screeny + 1280            
                next spry
    
            end if

        end if
            
    end sub
    
    #define scaleFactor 65536
    #define scaleBits   16
    
    defdbl a-z
    sub renderFrame ( lookVertical as double, verticalPosition as integer )

        sprites(0).inuse = 1
        sprites(0).x = playerx
        sprites(0).y = playery
        sprites(0).collisionradius = playerradius

        lv% = -cos(lookVertical + pi/2) * 500
        vp% = -verticalPosition
        if vp% > 75 then vp% = 75
        if vp% < -75 then vp% = -75

        if hires = 0 then
            
            _screenptr% = screenptr
            
        else

            _screenptr% = @membfr(0)
            
        end if
        
        if disablebg = 0 then
            
            a = playerangle - anglefix
            
            while a > 2 * pi
                a = a - 2 * pi
            wend
            
            while a < 0
                a = a + 2 * pi
            wend
            
            x% = -(a - pi) / 4*pi * 320
    
            y% = -lv%
            
            x% = (x% + 32000) mod 320
            y% = (y% + 20000) mod 200
            
            yoff% = ((x% + y% * 320) * 4) mod 256000
    
            
            bgptr% = @bgdata(0 + 4)
            
            if hires = 0 then screenlock
            
            asm
                
                mov ecx, 0
            
            bgloop:
            
                mov ebx, ecx
                add ebx, [yoff%]
                
                cmp ebx, 256000
                jge warp
                
                jmp skipWarp
            warp:
                sub ebx, 256000
            skipWarp:
            
                add ebx, [bgptr%]
                mov edx, [ebx]
                mov eax, ecx
                add eax, [_screenptr%]
                mov [eax], edx
            
                add ecx, 4
                cmp ecx, 254720
                jl bgloop
                
            end asm
            
            if hires = 0 then screenunlock
            
        end if
        
        cp = cos(playerangle-anglefix)
        sp = sin(playerangle-anglefix)
        
        dim fd(0 to 199) as integer
        dim cd(0 to 199) as integer

        for y% = 0 to 199
            
            fd(y%) = (100 - vp%) / (y% - lv% - 99) * 256
            cd(y%) = -(100 + vp%) / (y% - lv% - 100) * 256
            
        next y%
        
        rptr% = @redlut(0)
        gptr% = @greenlut(0)
        bptr% = @bluelut(0)
        
        dim db(0 to maxdblocks-1) as integer
        
        dblockcount% = 0
        for i% = 0 to maxdblocks-1
            
            if dblocks(i%).inuse then
                
                db(dblockcount%) = i%
                dblockcount% = dblockcount% + 1
                
            end if
            
        next i%
        
        smapsizex% = mapsizex% * scaleFactor
        smapsizey% = mapsizey% * scaleFactor

        for x% = 0 to 319
            
            dx = (x%-160) / 260
            
            rdx = cp*dx - sp
            rdy = sp*dx + cp
            
            getx = rdx / rdy
            gety = rdy / rdx
            
            hitA% = 0
            hitB% = 0
            obA% = 0
            obB% = 0
            
            toofar% = 0
            
            if abs(getx) > 181 then obB% = 1
            if abs(gety) > 181 then obA% = 1
            
            Ax = fix(playerx): Dax = sgn(rdx) * scaleFactor
            Ay = playery + (Ax - playerx) * gety

            By = fix(playery): Dby = sgn(rdy) * scaleFactor
            Bx = playerx + (By - playery) * getx
            
            IncAy% = Dax * gety
            IncBx% = Dby * getx
            HIncAy% = (Dax * gety) / 2
            HIncBx% = (Dby * getx) / 2
            
            Ax% = Ax * scaleFactor
            Ay% = Ay * scaleFactor
            Bx% = Bx * scaleFactor
            By% = By * scaleFactor
            
            splayerx% = playerx * scaleFactor
            splayery% = playery * scaleFactor
            
            Dax% = Dax
            Dby% = Dby
            HDax% = Dax / 2
            HDby% = Dby / 2

            do
    
                if hitA% = 0 and obA% = 0 then
                    
                    if sgn(Ax% - splayerx%) = sgn(Dax%) then
                    
                        if Ax% < 0 or Ay% < 0 or Ax% >= smapsizex% or Ay% >= smapsizey% then
                            
                            obA% = 1
                        
                        else
                        
                            mposA% = (((Ax% + HDax%) shr scaleBits)) + ((Ay% shr scaleBits) shl 7)
                            
                            if map(mposA%) > 0 then
                                
                                hitA% = 1
                                
                            elseif map(mposA%) < 0 then
                                
                                Ax2% = Ax% + HDax%
                                Ay2% = Ay% + HIncAy%
                                
                                if not (Ax2% < 0 or Ay2% < 0 or Ax2% >= smapsizex% or Ay2% >= smapsizey%) then
                                
                                    mposA% = (Ax2% shr scaleBits) + ((Ay2% shr scaleBits) shl 7)
                                    
                                    if map(mposA%) < 0 then
                                        
                                        doorno% = abs(map(mposA%)) - 1
                                        
                                        if doors(doorno%).hORv = vertical then
                                        
                                            if (((Ay2% shr (scaleBits - 6)) and 63) - doors(doorno%).amtopen) >= 0 then
                                                
                                                Ax% = Ax2%
                                                Ay% = Ay2%
                                                
                                                hitA% = 1
                                                
                                            end if
                                            
                                        end if
                                        
                                    end if
                                    
                                end if
                                
                            end if
                        
                        end if
                
                    end if
                
                end if
            
                if hitA% = 0 and obA% = 0 then
                    
                    Ax% = Ax% + Dax%
                    Ay% = Ay% + IncAy%
                    
                end if
            
                if hitB% = 0 and obB% = 0 then
                    
                    if sgn(By% - splayery%) = sgn(Dby%) then
                    
                        if Bx% < 0 or By% < 0 or Bx% >= smapsizex% or By% >= smapsizey% then
                            
                            obB% = 1
                        
                        else
                            
                            mposB% = (Bx% shr scaleBits) + ((((By% + HDby%) shr scaleBits)) shl 7)
            
                            if map(mposB%) > 0 then
                                
                                hitB% = 1
                                
                            elseif map(mposB%) < 0 then
                                
                                By2% = By% + HDby%
                                Bx2% = Bx% + HIncBx%
                                
                                if not (Bx2% < 0 or By2% < 0 or Bx2% >= smapsizex% or By2% >= smapsizey%) then
                                
                                    mposB% = (Bx2% shr scaleBits) + ((By2% shr scaleBits) shl 7)
                                    ' + (sgn(rdx) / 2)
                                    
                                    if map(mposB%) < 0 then
                                        
                                        doorno% = abs(map(mposB%)) - 1
                                        
                                        if doors(doorno%).hORv = horizontal then
                                        
                                            if (((Bx2% shr (scaleBits - 6)) and 63) - doors(doorno%).amtopen) >= 0 then
                                                
                                                Bx% = Bx2%
                                                By% = By2%
                                                hitB% = 1
                                                
                                            end if
                                        
                                        end if
                                        
                                    end if
                                
                                end if
                                
                            end if
                            
                        end if
                    
                    end if
                    
                end if
                
                if hitB% = 0 and obB% = 0 then
                    
                    By% = By% + Dby%
                    Bx% = Bx% + IncBx%
                    
                end if
            
                if (hitA% = 1 and hitB% = 1) or (hitA% = 1 and obB% = 1) or (hitB% = 1 and obA% = 1) then exit do
                
            loop
            
            Ax = Ax% / scaleFactor
            Ay = Ay% / scaleFactor
            Bx = Bx% / scaleFactor
            By = By% / scaleFactor
    
            AdistSq = (playerx-Ax)^2 + (playery-Ay)^2
            BdistSq = (playerx-Bx)^2 + (playery-By)^2
            
            hitDoor% = 0
            
            if obA% = 0 and (obB% or (AdistSq < BdistSq)) then
                
                rayx = Ax
                rayy = Ay
                
                texnum% = map(mposA%)
                
                if texnum% < 0 then
                    
                    hitDoor% = abs(texnum%)
                    texnum% = doors(hitDoor% - 1).texture
                    
                end if
                
                hittype% = 0
                praydistance = sqr(AdistSq)
                
            else
    
                rayx = Bx
                rayy = By
                
                texnum% = map(mposB%)
                
                if texnum% < 0 then
                    
                    hitDoor% = abs(texnum%)
                    texnum% = doors(hitDoor% - 1).texture
                   
                end if
    
                hittype% = 1
                praydistance = sqr(BdistSq)
                
            end if
    
            'line (15+playerx*15, 15+playery*15)-(15+rayx*15, 15+rayy*15), 30 * 30000
            
            dbHitN% = -1
            dbHitDsq = praydistance * praydistance
            
            for i% = 0 to dblockcount%-1
                
                j% = db(i%)
                
                ' left side
                if rdx > 0 then
                    
                    x = dblocks(j%).x                
                    y = playery + (x - playerx) * gety
                    
                    if sgn(y - playery) = sgn(rdy) and y >= dblocks(j%).y and y < (dblocks(j%).y + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            dbHitN% = j%
                            dbHitSide% = dleft
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                    
                ' right side
                elseif rdx < 0 then
                    
                    x = dblocks(j%).x + 0.999999           
                    y = playery + (x - playerx) * gety
                    
                    if sgn(y - playery) = sgn(rdy) and y >= dblocks(j%).y and y < (dblocks(j%).y + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            dbHitN% = j%
                            dbHitSide% = dright
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                
                end if
                
                ' top side
                if rdy > 0 then
                    
                    y = dblocks(j%).y                
                    x = playerx + (y - playery) * getx
                    
                    if sgn(x - playerx) = sgn(rdx) and x >= dblocks(j%).x and x < (dblocks(j%).x + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            dbHitN% = j%
                            dbHitSide% = dtop
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                    
                ' bottom side
                elseif rdy < 0 then
                    
                    y = dblocks(j%).y + 0.999999              
                    x = playerx + (y - playery) * getx
                    
                    if sgn(x - playerx) = sgn(rdx) and x >= dblocks(j%).x and x < (dblocks(j%).x + 1.0) then
                        
                        Dsq = (playerx - x) * (playerx - x) + (playery - y) * (playery - y)                        
                        
                        if Dsq < dbHitDsq then
                            
                            dbHitN% = j%
                            dbHitSide% = dbottom
                            dbHitX = x
                            dbHitY = y
                            dbHitDsq = Dsq
                            
                        end if
                        
                    end if
                
                end if                

            next i%
            
            if dbHitN% >= 0 then
                
                j% = dbHitN%
                
                texnum% = dblocks(j%).texture

                if dbHitSide% = dleft or dbHitSide% = dright then
                    
                    ypos = dbHitY - dblocks(j%).y
                    texpos = ypos
                    if rdx >= 0 then texpos = 1 - texpos
                    
                else
                    
                    xpos = dbHitX - dblocks(j%).x
                    texpos = xpos
                    if rdy < 0 then texpos = 1 - texpos
                    
                end if
                
                raydistance = sqr(dbHitDsq) * cos(atn(dx))

            else
            
                xpos = rayx - fix(rayx)
                ypos = rayy - fix(rayy)
                
                if hitDoor% > 0 then
                    
                    doorn% = hitDoor% - 1
                    
                    if doors(doorn%).hORv = horizontal then
                        
                        xpos = xpos - (doors(doorn%).amtopen / texturesize)
                        
                    else
        
                        ypos = ypos - (doors(doorn%).amtopen / texturesize)
        
                    end if
                
                    if hittype% = 0 then
                        
                        texpos = 1 - ypos
                        
                    else
                        
                        texpos = 1 - xpos
                        
                    end if
                
                else
                    
                    if hittype% = 0 then
                        
                        texpos = ypos
                        if rdx >= 0 then texpos = 1 - texpos
                        
                    else 
                        
                        texpos = xpos
                        if rdy < 0 then texpos = 1 - texpos
                        
                    end if
                    
                end if
                
                raydistance = praydistance * cos(atn(dx))
            
            end if
        
            zbuffer(x%) = raydistance * 256
        
            depthdiv = raydistance'(raydistance * (raydistance / 4))
            if depthdiv < 1 then depthdiv = 1
            
            fdepthdiv% = 0
            
            ' draw floor
            starty% = 99 + ((100 - vp%) / raydistance) + lv%
            
            if starty% < 0 then starty% = 0
            
            if starty% <= 199 then
                
                _texptr% = @texturedata(0 + 4)'(floortexture-1) * onetexture + 4)
                '_texptr% = @texturedata(1 * onetexture + 4)
                
                fstartx% = playerx * 256 * 256
                fstarty% = playery * 256 * 256
                frdx% = rdx * 256
                frdy% = rdy * 256
                
                texx% = 0
                texy% = 0
                
                scrptr% = _screenptr%
                
                texptr% = 0
    
                scry% = scrptr% + (starty% * 1280) + (x% shl 2)
                mapptr% = @fmap(0)
                dptr% = @fd(0)
                
                if hires = 0 then screenlock
                
                asm
    
                    mov edx, [starty%]
                    mov ecx, [scry%]
    
                floorloop:
                    
                    mov ebx, edx
                    
                    push edx
                    push ecx
                
                    ' calculate fdist
                    ' raydistance = (100 - vp%) / (y% - lv% - 100)
                    mov ecx, [dptr%]
                    shl ebx, 2
                    add ecx, ebx
                    mov eax, [ecx]
                    ' (fdist stored in eax)
                    
                    ' texx% = fix((playerx + (rdx * fdist)) * 64) and 63
                    mov ebx, [frdx%]
                    imul ebx, eax
                    'shr ebx, 8
                    add ebx, [fstartx%]
                    shr ebx, 8
                    shr ebx, 2
                    
                    mov edx, ebx
                    shr edx, 6
                    shl edx, 2
                    
                    and ebx, 63
                    ' (texx% stored in ebx)
        
                    ' texy% = fix((playery + (rdy * fdist)) * 64) and 63
                    mov ecx, [frdy%]
                    imul ecx, eax
                    'shr ecx, 8
                    add ecx, [fstarty%]
                    shr ecx, 8
                    shr ecx, 2
                    
                    push ebx
                    mov ebx, ecx
                    shr ebx, 6
                    shl ebx, 9
                    add edx, ebx
                    pop ebx
                    
                    and ecx, 63
                    ' (texy% stored in ecx)
                    
                    push ecx
                    push ebx
                    
                    cmp edx, 64768
                    jg skip0f
                    cmp edx, 0
                    jle skip0f
                    
                    add edx, [mapptr%]
                    mov ecx, [edx]
                    
                    jmp skip0f
                set0f:
                    mov ecx, 1
                skip0f:
                    
                    dec ecx
                    mov ebx, ecx
                    shl ebx, 14
                    shl ecx, 2
                    add ecx, ebx
                    add ecx, [_texptr%]
                    mov [texptr%], ecx                    
                    pop ebx
                    pop ecx
                    
                    ' fdepthdiv = fdist ^ 2
                    'imul eax, eax
                    'shr eax, 10
                    'add eax, 256
                    
                    push ecx
                    mov ecx, [depthshading]
                    cmp ecx, 1
                    jge edsF
                    mov eax, 255
                edsF:
                    dec ecx
                    shr eax, cl
                    
                    'shr eax, 2
                    mov [fdepthdiv%], eax
                    pop ecx
                    ' (fdepthdiv stored in eax)
                    
                    ' colour% = peek(integer, @texturedata(texptr% + (texx% shl 2) + (texy% shl 8)))
                    shl ebx, 2
                    shl ecx, 8
                    mov edx, [texptr%]
                    add edx, ebx
                    add edx, ecx
                    mov eax, [edx]
                    
                    ' shade pixel
                    
                    mov ebx, [fdepthdiv%]
                    cmp ebx, 255
                    jle skipSF
                    mov ebx, 255
                skipSF:
                    
                    push eax
                    shr eax, 16
                    '
                    mov edx, ebx
                    shl edx, 8
                    add edx, eax
                    add edx, [rptr%]
                    mov al, [edx]
                    and eax, 255
                    '
                    shl eax, 16
                    mov ecx, eax
                    pop eax
                    
                    push eax
                    shr eax, 8
                    and eax, 255
                    '
                    mov edx, ebx
                    shl edx, 8
                    add edx, eax
                    add edx, [gptr%]
                    mov al, [edx]
                    and eax, 255
                    '
                    shl eax, 8
                    or ecx, eax
                    pop eax
                    
                    push eax
                    and eax, 255
                    '
                    mov edx, ebx
                    shl edx, 8
                    add edx, eax
                    add edx, [bptr%]
                    mov al, [edx]
                    and eax, 255
                    '
                    or ecx, eax
                    pop eax
                    
                    ' write pixel to screen
                    mov ebx, ecx
                    
                    pop ecx
                    mov eax, ecx
                    mov [eax], ebx
                    'add eax, 4
                    'mov [eax], ebx
                    
                    ' increase screen pointer in y by 1 pixel
                    add ecx, 1280
    
                    ' next
                    pop edx
                    inc edx
                    cmp edx, 199
                    jle floorloop
                    
                    jmp finishFl
                    
                exitFl:
                
                    pop ecx
                    pop edx
                    
                finishFl:
                
                blahblah:
                    
                end asm
                
                if hires = 0 then screenunlock
    
            end if
            
            ' draw ceeling
            starty% = 100 - ((100 + vp%) / raydistance) + lv%
            if starty% > 199 then starty% = 199

            if starty% >= 0 then
                
                'texptr% = @texturedata((ceelingtexture-1) * onetexture + 4)
                _texptr% = @texturedata(0 + 4)
                
                cstartx% = playerx * 256 * 256
                cstarty% = playery * 256 * 256
                crdx% = rdx * 256
                crdy% = rdy * 256
                
                texx% = 0
                texy% = 0
                
                scrptr% = _screenptr%
                
                scry% = scrptr% + (starty% * 1280) + (x% shl 2)
                
                fdepthdiv% = 0
                colour% = 0
                
                texptr% = 0
                
                mapptr% = @cmap(0)
                dptr% = @cd(0)
                
                if hires = 0 then screenlock
                
                asm
    
                    mov edx, [starty%]
                    mov ecx, [scry%]
    
                ceelingloop:
                    
                    mov ebx, edx
                    
                    push edx
                    push ecx
                
                    ' calculate fdist
                    mov ecx, [dptr%]
                    shl ebx, 2
                    add ecx, ebx
                    mov eax, [ecx]
                    ' (fdist stored in eax)
                    
                    mov ebx, [crdx%]
                    imul ebx, eax
                    'shr ebx, 8
                    add ebx, [cstartx%]
                    shr ebx, 8
                    shr ebx, 2
                    
                    mov edx, ebx
                    shr edx, 6
                    shl edx, 2
                    
                    and ebx, 63
                    ' (texx% stored in ebx)
        
                    ' texy% = fix((playery + (rdy * fdist)) * 64) and 63
                    mov ecx, [crdy%]
                    imul ecx, eax
                    'shr ecx, 8
                    add ecx, [cstarty%]
                    shr ecx, 8
                    shr ecx, 2
                    
                    push ebx
                    mov ebx, ecx
                    shr ebx, 6
                    shl ebx, 9
                    add edx, ebx
                    pop ebx
                    
                    and ecx, 63
                    ' (texy% stored in ecx)
                    
                    push ecx
                    push ebx
                    
                    cmp edx, 64768
                    jg skip0c
                    cmp edx, 0
                    jle skip0c
                    
                    add edx, [mapptr%]
                    mov ecx, [edx]
                    cmp ecx, 1
                    jl transc
                    
                    jmp skip0c
                set0c:
                    mov ecx, 1
                skip0c:
                    
                    dec ecx
                    mov ebx, ecx
                    shl ebx, 14
                    shl ecx, 2
                    add ecx, ebx
                    add ecx, [_texptr%]
                    mov [texptr%], ecx                    
                    pop ebx
                    pop ecx
                    
                    ' fdepthdiv = fdist ^ 2
                    'imul eax, eax
                    'shr eax, 10
                    'add eax, 256

                    push ecx
                    mov ecx, [depthshading]
                    cmp ecx, 1
                    jge edsC
                    mov eax, 255
                edsC:
                    dec ecx
                    shr eax, cl
                    
                    'shr eax, 2
                    mov [fdepthdiv%], eax
                    pop ecx
                    ' (fdepthdiv stored in eax)
                    
                    ' colour% = peek(integer, @texturedata(texptr% + (texx% shl 2) + (texy% shl 8)))
                    shl ebx, 2
                    shl ecx, 8
                    mov edx, [texptr%]
                    add edx, ebx
                    add edx, ecx
                    mov eax, [edx]
                    
                    ' shade pixel
                    
                    mov ebx, [fdepthdiv%]
                    cmp ebx, 255
                    jle skipSC
                    mov ebx, 255
                skipSC:
                    
                    push eax
                    shr eax, 16
                    '
                    mov edx, ebx
                    shl edx, 8
                    add edx, eax
                    add edx, [rptr%]
                    mov al, [edx]
                    and eax, 255
                    '
                    shl eax, 16
                    mov ecx, eax
                    pop eax
                    
                    push eax
                    shr eax, 8
                    and eax, 255
                    '
                    mov edx, ebx
                    shl edx, 8
                    add edx, eax
                    add edx, [gptr%]
                    mov al, [edx]
                    and eax, 255
                    '
                    shl eax, 8
                    or ecx, eax
                    pop eax
                    
                    push eax
                    and eax, 255
                    '
                    mov edx, ebx
                    shl edx, 8
                    add edx, eax
                    add edx, [bptr%]
                    mov al, [edx]
                    and eax, 255
                    '
                    or ecx, eax
                    pop eax
                    
                    ' write pixel to screen
                    mov ebx, ecx
                    
                    pop ecx
                    mov eax, ecx
                    mov [eax], ebx
                    'add eax, 4
                    'mov [eax], ebx
                    
                    jmp skiptransC
                    
                transc:
                
                    pop ebx
                    pop ecx
                    pop ecx
                    
                skiptransC:
                    
                    ' increase screen pointer in y by 1 pixel
                    sub ecx, 1280
    
                    ' next
                    pop edx
                    dec edx
                    cmp edx, 0
                    jge ceelingloop
                    
                    jmp finishCl
                    
                exitCl:
                
                    pop ecx
                    pop edx
                    
                finishCl:
                    
                end asm
                
                if hires = 0 then screenunlock
    
            end if

            ' draw walls
            
            texx% = texpos * (texturesize-1)
            texptr% = @texturedata((onetexture * (texnum% - 1)) + 4 + (texx% * 4))
            texy% = 0
            'texstep% = (256 * (texturesize+1)) / (lineheight * 2)
            
            if depthshading >= 1 then
                wdepthdiv% = fix(depthdiv * 256) shr (depthshading - 1)
                if wdepthdiv% > 255 then wdepthdiv% = 255
            else
                wdepthdiv% = 0
            end if
    
            scrptr% = _screenptr% + (x% * 4)
            
            'goto skipWallsX:
            
            firsty% = fix(99 - (100 + vp%) / raydistance + lv%) * 256
            finaly% = fix(101 + (100 - vp%) / raydistance + lv%) * 256
            texstep% = (256 * texturesize) / ((finaly% - firsty%) / 256)
            
            if texstep% < 256 then
                
                'firsty% = fix(99 - (100 + vp%) / raydistance + lv%) * 256
                'lasty% = fix(101 + (100 - vp%) / raydistance + lv%) * 256
                ystep% = (finaly% - firsty%) / (texturesize)
                'firsty% = firsty% shr 2
                'lasty% = lasty% shr 2
                
                overflow% = 0
                
                if firsty% <= (199 shl 8) and finaly% >= 0 then
                
                    if hires = 0 then screenlock
                
                    asm
                        
                        mov ebx, 0
                        mov ecx, [firsty%]
                        
                    wallloopA:
                    
                        ' colour% = peek(integer, @texturedata(texptr% + (texy% shl 8)))
                        mov edx, [texptr%]
                        mov eax, ebx
                        'shr eax, 2
                        shl eax, 8
                        add edx, eax
                        mov eax, [edx]
                        
                        ' shade pixel
                        push ebx
                        push ecx
        
                        mov ebx, [wdepthdiv%]
                        
                        push eax
                        shr eax, 16
                        '
                        mov edx, ebx
                        shl edx, 8
                        add edx, eax
                        add edx, [rptr%]
                        mov al, [edx]
                        and eax, 255
                        '
                        shl eax, 16
                        mov ecx, eax
                        pop eax
                        
                        push eax
                        shr eax, 8
                        and eax, 255
                        '
                        mov edx, ebx
                        shl edx, 8
                        add edx, eax
                        add edx, [gptr%]
                        mov al, [edx]
                        and eax, 255
                        '
                        shl eax, 8
                        or ecx, eax
                        pop eax
                        
                        push eax
                        and eax, 255
                        '
                        mov edx, ebx
                        shl edx, 8
                        add edx, eax
                        add edx, [bptr%]
                        mov al, [edx]
                        and eax, 255
                        '
                        or ecx, eax
                        pop eax
                        
                        mov eax, ecx
                        
                        pop ecx
                        pop ebx
                        
                        ' draw verticle line to screen
                        push ecx
                        push ebx
                        shr ecx, 8
                        imul ecx, 1280
                        mov ebx, ecx
                        mov edx, [scrptr%]
                        add edx, ecx
        
                        mov ecx, [ystep%]
                        'shr ecx, 2
                        
                    walldrawloopA:
                    
                        cmp ebx, 255991
                        jge exitA
                        cmp ebx, 0
                        jl clipA
                        
                        mov [edx], eax
                        'add edx, 4
                        'mov [edx], eax
                        'sub edx, 4
                            
                    clipA:
                        
                        add edx, 1280
                        add ebx, 1280
                            
                        sub ecx, 256
                        cmp ecx, 0
        
                        jg walldrawloopA
        
                        pop ebx
                        pop ecx
            
                        ' increase and loop
                        mov edx, [ystep%]
                        add ecx, edx
                        inc ebx
                        cmp ebx, 64
                        jne wallloopA
                        
                        jmp finishA
                        
                    exitA:
                        
                        pop ebx
                        pop ecx
                        
                    finishA:
                        
                    end asm
                    
                    if buffer = 0 then screenunlock
                
                end if
                
                'for texy% = 0 to (texturesize-1)
                '    
                '    colour% = peek(integer, @texturedata(texptr% + (texy% shl 8)))
                '    
                '    r% = (colour% shr 16) / depthdiv
                '    g% = ((colour% shr 8) and 255) / depthdiv
                '    b% = (colour% and 255) / depthdiv
                '    
                '    line(x%, y% shr 8)-step(2, ystep% shr 8), (r% shl 16) or (g% shl 8) or b%, bf                
                '    y% = y% + ystep%
                '    
                'next texy%
                
            else
                
                firsty% = firsty% shr 8
                finaly% = finaly% shr 8
                
                if firsty% <= 199 and finaly% >= 0 then
                
                    if hires = 0 then screenlock
                
                    asm
                        
                        mov ebx, [firsty%]
                        mov ecx, 0
                    
                    wallloopB:
                        
                        push ebx
                        push ecx
                        
                        ' get pixel
                        shr ecx, 8
                        shl ecx, 8
                        mov eax, [texptr%]
                        add ecx, eax
                        mov eax, [ecx]
                        
                        push ebx
                        
                        mov ebx, [wdepthdiv%]
                        
                        push eax
                        shr eax, 16
                        '
                        mov edx, ebx
                        shl edx, 8
                        add edx, eax
                        add edx, [rptr%]
                        mov al, [edx]
                        and eax, 255
                        '
                        shl eax, 16
                        mov ecx, eax
                        pop eax
                        
                        push eax
                        shr eax, 8
                        and eax, 255
                        '
                        mov edx, ebx
                        shl edx, 8
                        add edx, eax
                        add edx, [gptr%]
                        mov al, [edx]
                        and eax, 255
                        '
                        shl eax, 8
                        or ecx, eax
                        pop eax
                        
                        push eax
                        and eax, 255
                        '
                        mov edx, ebx
                        shl edx, 8
                        add edx, eax
                        add edx, [bptr%]
                        mov al, [edx]
                        and eax, 255
                        '
                        or ecx, eax
                        pop eax
                        
                        mov eax, ecx
        
                        pop ebx
                        
                        imul ebx, 1280
                        
                        mov edx, ebx
                        add edx, [scrptr%]
                        sub edx, [_screenptr%]
                        cmp edx, 255991
                        jge nodrawA
                        cmp edx, 0
                        jl nodrawA                  
                        
                        mov ecx, [scrptr%]
                        add ecx, ebx
                        mov [ecx], eax
                        'add ecx, 4
                        'mov [ecx], eax
                        
                    nodrawA:
                        
                        pop ecx
                        pop ebx
                        
                        mov eax, [texstep%]
                        add ecx, eax
                        
                        cmp ecx, 16384
                        jl wallskipB
                        mov ecx, 16380
                    wallskipB:
                        
                        inc ebx
                        mov eax, [finaly%]
                        cmp ebx, eax
                        jle wallloopB
                        
                    end asm
                    
                    if buffer = 0 then screenunlock
                    
                end if
                
                'for y% = 100 - lineheight% to 100 + lineheight%
                '    
                '    colour% = peek(integer, @texturedata(texptr% + (texy% shr 8) shl 8))
                '
                '    r% = (colour% shr 16) / depthdiv
                '    g% = ((colour% shr 8) and 255) / depthdiv
                '    b% = (colour% and 255) / depthdiv
                '    
                '    line(x%, y%)-step(2, 0), (r% shl 16) or (g% shl 8) or b%
                '    texy% = texy% + texstep%
                '    
                'next y%
                
            end if
            
            skipWallsX:

        next x
        
        spritecount% = 0
        for i% = 1 to maxsprites-1
            
            if sprites(i%).inuse then spritecount% = spritecount% + 1
            
        next i
    
        cp = cos(-(playerangle-anglefix))
        sp = sin(-(playerangle-anglefix))
        
        j% = 0
        for i% = 1 to maxsprites-1
            
            if sprites(i%).inuse then
            
                pdx = (sprites(i%).x) - playerx
                pdy = (sprites(i%).y) - playery
        
                rdx = cp*pdx - sp*pdy
                rdy = sp*pdx + cp*pdy
        
                distance = sqr(pdx*pdx + pdy*pdy) * cos(atn(rdx / rdy))
                
                if distance < 20 then
                
                    rdx = rdx / distance
                    rdy = rdy / distance
                    
                    if rdy < 0 then pspr(j%).show = 0 else pspr(j%).show = 1
            
                    'distance = 
                    
                    pspr(j%).scrx = (260 * rdx) + 160
                    pspr(j%).yoff = 200 * sprites(i%).z
                    pspr(j%).distance = distance * 256
                    pspr(j%).sprite = sprites(i%).sprite
                    
                    j% = j% + 1
                    
                else
                    
                    pspr(j%).show = 0
                    
                end if
            
            end if
            
        next i
        
        spritecount% = j%
        
        for i% = 0 to spritecount%-1
            for j% = i%+1 to spritecount%-1
                
                if pspr(j%).distance > pspr(i%).distance then
                
                    swap pspr(i%), pspr(j%)
                    
                end if
                
            next j%
        next i%
        
        for i% = 0 to spritecount%-1
            
            size% = 51200 / pspr(i%).distance
            vsize1% = (25600 + (vp% * 256) + (pspr(i%).yoff * 256)) / pspr(i%).distance
            vsize2% = (25600 - (vp% * 256) - (pspr(i%).yoff * 256)) / pspr(i%).distance
    
            startx% = pspr(i%).scrx - (size% shr 1)
            endx% = pspr(i%).scrx + (size% - (size% shr 1))
            
            if (pspr(i%).show = 1) and (pspr(i%).distance > 38) and (startx% <= 319) and (endx% >= 0) then
            
                sprstep% = 16384 / size%
                
                if depthshading >= 1 then
                    wdepthdiv% = pspr(i%).distance shr (depthshading - 1)
                    if wdepthdiv% > 255 then wdepthdiv% = 255
                else
                    wdepthdiv% = 255
                end if                
                 
                texx% = 0
    
                starty% = 100 - (size% shr 1)
                endy% = 100 + (size% - (size% shr 1))
                
                fsprptr% = @spritedata(0) + ((onetexture * (pspr(i%).sprite - 1)) + 4)
                
                for x% = startx% to endx%' step 2
                    
                    if x% <= 319 and x% >= 0 then
                    
                        if pspr(i%).distance < zbuffer(x%) then
                            
                            sprptr% = fsprptr% + (texx% shr 8) shl 2
                            
                            texy% = 0
                            texstep% = (256 * texturesize) / (vsize1% + vsize2%)
                            
                            scrptr% = _screenptr% + (x% shl 2)
                            
                            if texstep% <= 256 then
                                
                                firsty% = (100 - vsize1% + lv%) shl 8
                                lasty% = (100 + vsize2% + lv% + 1) shl 8
                                ystep% = (lasty% - firsty%) / (texturesize-1)
                                
                                if firsty% <= (199 shl 8) and lasty% >= 0 then
                                
                                    if hires = 0 then screenlock
                                    
                                    asm
                                    
                                        mov ebx, 0
                                        mov ecx, [firsty%]
                                        
                                    sprloopA:
                                    
                                        ' colour% = peek(integer, @texturedata(texptr% + (texy% shl 8)))
                                        mov edx, [sprptr%]
                                        mov eax, ebx
                                        shl eax, 8
                                        add edx, eax
                                        mov eax, [edx]
                                        sub edx, [fsprptr%]
                                        cmp edx, 16384
                                        jge sprfinishA
                                        
                                        cmp eax, 0
                                        je transA
                                        
                                        ' shade pixel
                                        push ebx
                                        push ecx
                        
                                        mov ebx, [wdepthdiv%]
                                        
                                        push eax
                                        shr eax, 16
                                        '
                                        mov edx, ebx
                                        shl edx, 8
                                        add edx, eax
                                        add edx, [rptr%]
                                        mov al, [edx]
                                        and eax, 255
                                        '
                                        shl eax, 16
                                        mov ecx, eax
                                        pop eax
                                        
                                        push eax
                                        shr eax, 8
                                        and eax, 255
                                        '
                                        mov edx, ebx
                                        shl edx, 8
                                        add edx, eax
                                        add edx, [gptr%]
                                        mov al, [edx]
                                        and eax, 255
                                        '
                                        shl eax, 8
                                        or ecx, eax
                                        pop eax
                                        
                                        push eax
                                        and eax, 255
                                        '
                                        mov edx, ebx
                                        shl edx, 8
                                        add edx, eax
                                        add edx, [bptr%]
                                        mov al, [edx]
                                        and eax, 255
                                        '
                                        or ecx, eax
                                        pop eax
                                        
                                        mov eax, ecx
                                        
                                        pop ecx
                                        pop ebx
                                        
                                        ' draw verticle line to screen
                                        push ecx
                                        push ebx
                                        shr ecx, 8
                                        imul ecx, 1280
                                        mov ebx, ecx
                                        mov edx, [scrptr%]
                                        add edx, ecx
                        
                                        mov ecx, [ystep%]
                                        'shr ecx, 8
                                        
                                    sprdrawloopA:
                                    
                                        cmp ebx, 255991
                                        jge sprexitA
                                        cmp ebx, 0
                                        jl sprclipA
                                        
                                        mov [edx], eax
                                        'add edx, 4
                                        'mov [edx], eax
                                        'sub edx, 4
                                            
                                    sprclipA:
                                        
                                        add edx, 1280
                                        add ebx, 1280
                                            
                                        sub ecx, 256
                                        cmp ecx, 0
                        
                                        jg sprdrawloopA
                        
                                        pop ebx
                                        pop ecx
                                        
                                    transA:
                            
                                        ' increase and loop
                                        mov edx, [ystep%]
                                        add ecx, edx
                                        inc ebx
                                        cmp ebx, 64
                                        jne sprloopA
                                        
                                        jmp sprfinishA
                                        
                                    sprexitA:
                                        
                                        pop ebx
                                        pop ecx
                                        
                                    sprfinishA:
                                        
                                    end asm
                                    
                                    if hires = 0 then screenunlock
                                    
                                end if
                                            
                                'for texy% = 0 to (texturesize-1)
                                '    
                                '    colour% = peek(integer, @texturedata(texptr% + (texy% shl 8)))
                                '    
                                '    r% = (colour% shr 16) / depthdiv
                                '    g% = ((colour% shr 8) and 255) / depthdiv
                                '    b% = (colour% and 255) / depthdiv
                                '    
                                '    line(x%, y% shr 8)-step(2, ystep% shr 8), (r% shl 16) or (g% shl 8) or b%, bf                
                                '    y% = y% + ystep%
                                '    
                                'next texy%
                                
                            else
                                
                                firsty% = (100 - vsize1% + lv%)
                                finaly% = (100 + vsize2% + lv%)
                                
                                if firsty% <= 199 and finaly% >= 0 then 
                                    
                                    if hires = 0 then screenlock
                                    
                                    asm
                                        
                                        mov ebx, [firsty%]
                                        mov ecx, 0
                                    
                                    sprloopB:
                                        
                                        push ebx
                                        push ecx
                                        
                                        ' get pixel
                                        shr ecx, 8
                                        shl ecx, 8
                                        mov eax, [sprptr%]
                                        add ecx, eax
                                        mov eax, [ecx]
                                        
                                        cmp eax, 0
                                        je transB
                                        
                                        push ebx
                                        
                                        mov ebx, [wdepthdiv%]
                                        
                                        push eax
                                        shr eax, 16
                                        '
                                        mov edx, ebx
                                        shl edx, 8
                                        add edx, eax
                                        add edx, [rptr%]
                                        mov al, [edx]
                                        and eax, 255
                                        '
                                        shl eax, 16
                                        mov ecx, eax
                                        pop eax
                                        
                                        push eax
                                        shr eax, 8
                                        and eax, 255
                                        '
                                        mov edx, ebx
                                        shl edx, 8
                                        add edx, eax
                                        add edx, [gptr%]
                                        mov al, [edx]
                                        and eax, 255
                                        '
                                        shl eax, 8
                                        or ecx, eax
                                        pop eax
                                        
                                        push eax
                                        and eax, 255
                                        '
                                        mov edx, ebx
                                        shl edx, 8
                                        add edx, eax
                                        add edx, [bptr%]
                                        mov al, [edx]
                                        and eax, 255
                                        '
                                        or ecx, eax
                                        pop eax
                        
                                        mov eax, ecx
                        
                                        pop ebx

                                        imul ebx, 1280
                                        
                                        mov edx, ebx
                                        add edx, [scrptr%]
                                        sub edx, [_screenptr%]
                                        cmp edx, 255991
                                        jge nodrawB
                                        cmp edx, 0
                                        jl nodrawB                  
    
                                        mov ecx, [scrptr%]
                                        add ecx, ebx
                                        mov [ecx], eax
                                        'add ecx, 4
                                        'mov [ecx], eax
                                        
                                    nodrawB:
                                    transB:
                                        
                                        pop ecx
                                        pop ebx
                                        
                                        mov eax, [texstep%]
                                        add ecx, eax
                                        
                                        inc ebx
                                        mov eax, [finaly%]
                                        cmp ebx, eax
                                        jl sprloopB
                                        
                                    end asm
                                    
                                    if hires = 0 then screenunlock
                                    
                                end if
                                
                                'for y% = 100 - lineheight% to 100 + lineheight%
                                '    
                                '    colour% = peek(integer, @texturedata(texptr% + (texy% shr 8) shl 8))
                                '
                                '    r% = (colour% shr 16) / depthdiv
                                '    g% = ((colour% shr 8) and 255) / depthdiv
                                '    b% = (colour% and 255) / depthdiv
                                '    
                                '    line(x%, y%)-step(2, 0), (r% shl 16) or (g% shl 8) or b%
                                '    texy% = texy% + texstep%
                                '    
                                'next y%
                                
                            end if
   
                            'texy = 0
                            
                            'for y% = starty% to endy%
                            '    
                            '    if y% <= 199 and y% >= 0 then
                            '    
                            '        colour% = peek(integer, sprptr% + (fix(texy) shl 8))
                            '        
                            '        if colour% > 0 then
                            '
                            '            r% = (colour% shr 16) / depthdiv
                            '            g% = ((colour% shr 8) and 255) / depthdiv
                            '            b% = (colour% and 255) / depthdiv
                            '            
                            '            colour% = (r% shl 16) or (g% shl 8) or b%
    
                            '            'pset (x%, y%), colour%
                            '            'pset (x%+1, y%), colour%
                            '            poke integer, (_scrptr% + y% * 1280), colour%
                            '            poke integer, (_scrptr% + y% * 1280 + 4), colour%
                            '        
                            '        end if
                            '        
                            '    end if
                            '    
                            '    texy = texy + sprstep
                            '    
                            'next y%
                            
                        end if
                    
                    end if
                    
                    texx% = texx% + sprstep%
                    
                next x%
                
            end if
            
        next i
        
        'screenunlock
    
    end sub

    defint a-z
    sub hiresStretch ( )
        
        if hires > 0 then

            screenlock
            
            if hires = 2 then yinc% = 20
            
            for y% = 0 to 199
                
                yscrptr% = (y% + yinc%) * 5120 + screenptr
                ybfr% = y% * 1280 + @membfr(0)
            
                asm
                    
                    mov ecx, [yscrptr%]
                    mov ebx, [ybfr%]
                    mov edx, 0
                    
                stretchLoop:
                
                    mov eax, [ebx]
                    
                    mov [ecx], eax
                    add ecx, 4
                    mov [ecx], eax
                    add ecx, 2556
                    mov [ecx], eax
                    add ecx, 4
                    mov [ecx], eax
                    sub ecx, 2556
                    
                    add ebx, 4
                    add edx, 4
                    cmp edx, 1280
                    jl stretchLoop
                    
                end asm
                
            next y%
            
            screenunlock
            
        end if

    end sub
    
    defdbl a-z
    sub updateDBlocks ( )
        
        tmr = timer
        
        for i% = 0 to maxdblocks-1
            
            if dblocks(i%).inuse then
            
                t = (tmr - dblocks(i%).starttime) / dblocks(i%).movetime
                
                if dblocks(i%).starttime > 0 then
                    
                    if t >= 1.0 then
                        
                        nx = dblocks(i%).x2
                        ny = dblocks(i%).y2
                        'dblocks(i%).starttime = 0
                        
                    else
                        
                        nx = dblocks(i%).x1 + (dblocks(i%).x2 - dblocks(i%).x1) * t
                        ny = dblocks(i%).y1 + (dblocks(i%).y2 - dblocks(i%).y1) * t
                        
                    end if
                    
                    collision% = 0
                    
                    for x = fix(nx) - 2 to fix(nx) + 2
                        
                        for y = fix(ny) - 2 to fix(ny) + 2
                            
                            if x >= 0 and y >= 0 and x < mapsizex and y < mapsizey then
                                
                                onmap% = map(x + (y * 128))
                            
                                if onmap% <> 0 and blockInBlock ( x, y, 1.0, nx+0.00025, ny+0.00025, 0.9995 ) = 1 then
                                   
                                    collision% = 1
                                    exit for
                                   
                                    'if onmap% < 0 then
                                        
                                    '    if doors(-onmap% - 1).amtopen < 48 then
                                            
                                    '        collision% = 1
                                    '        exit for
                                            
                                    '    end if
                                        
                                    'else
                                   
                                    '    collision% = 1
                                    '    exit for
                                        
                                    'end if
                                    
                                end if
                                
                            end if
                            
                        next y
                        
                        if collision% then exit for
                        
                    next x
                    
                    if collision% = 0 then
                        
                        for j% = 1 to maxsprites-1
                            
                            if sprites(j%).inuse = 1 then
                                
                                if sprites(j%).collisionradius > 0 then
                                
                                    if blockInBlock ( sprites(j%).x - sprites(j%).collisionradius, _
                                                      sprites(j%).y - sprites(j%).collisionradius, _
                                                      sprites(j%).collisionradius * 2, _
                                                      nx, ny, _
                                                      0.9999 ) then
                                          
                                        'trace (str$(sprites(j%).x) + ", " + str$(sprites(j%).y) + " block: " + str$(nx) + ", " + str$(ny))
                                          
                                        collision% = 1
                                        
                                        exit for
                                          
                                    end if
                                    
                                end if
                                
                            end if
                            
                        next j%
                        
                    end if

                    if collision% = 0 then
                        
                        for j% = 0 to maxdblocks-1
                            
                            if j% <> i% and dblocks(j%).inuse then
                                
                                if blockInBlock ( dblocks(j%).x+0.00025, dblocks(j%).y+0.00025, 0.9995, nx+0.00025, ny+0.00025, 0.9995 ) = 1 then
                                    
                                    collision% = 1
                                    
                                    exit for
                                    
                                end if
                                
                            end if
                            
                        next j%
                        
                    end if

                    if collision% = 0 then
                        
                        dblocks(i%).x = nx
                        dblocks(i%).y = ny
                        
                        if t! >= 1.0 then dblocks(i%).starttime = 0
                        
                    else
                        
                        if dblocks(i%).presistant then
                            
                            if dblocks(i%).lasttime > 0 then
                                
                                dblocks(i%).starttime = dblocks(i%).starttime - (tmr - dblocks(i%).lasttime)
                                
                            end if
                            
                            dblocks(i%).lasttime = tmr
                            
                        else
                            
                            dblocks(i%).starttime = 0
                            
                        end if
                        
                    end if
                    
                end if
            
            end if
            
        next i%
        
    end sub
    
    defdbl a-z
    function moveDBlockTo ( dbIndex as integer, _
                            x as double, y as double, _
                            movetime as double, _
                            stopIfGoing as integer, _
                            presistant as integer ) as integer
                
        if dblocks(dbIndex).inuse then
            
            if dblocks(dbIndex).starttime > 0 and stopIfGoing = 0 then
                
                return 0
                    
            end if
                
            dblocks(dbIndex).x1 = dblocks(dbIndex).x
            dblocks(dbIndex).y1 = dblocks(dbIndex).y
            dblocks(dbIndex).x2 = x
            dblocks(dbIndex).y2 = y
            dblocks(dbIndex).starttime = timer
            dblocks(dbIndex).movetime = movetime
            dblocks(dbIndex).presistant = presistant
            dblocks(dbIndex).lasttime = 0
            
            return 1
                
        else
            
            return 0
            
        end if
                
    end function
    
    defdbl a-z
    sub updateDoors
    
        for i% = 0 to doorcount-1
            
            oldamtopen% = doors(i).amtopen        
            
            if doors(i%).oORc = opening then
                
                doors(i%).amtopen = doors(i%).amtopen + doorspeed
                if doors(i%).amtopen > 64 then doors(i%).amtopen = 64
                
            elseif doors(i%).oORc = closing then
                
                doors(i%).amtopen = doors(i%).amtopen - doorspeed
                if doors(i%).amtopen < 0 then doors(i%).amtopen = 0
                
            end if
            
        next i%

        for j% = 0 to maxsprites-1
            
            if sprites(j%).inuse = 1 and sprites(j%).collisionradius > 0 then
            
                sx = sprites(j%).x
                sy = sprites(j%).y
            
                for x% = fix(sx) - 1 to fix(sx) + 1

                    if x% >= 0 and x% < mapsizex then

                        for y% = fix(sy) - 1 to fix(sy) + 1
                            
                            if y% >= 0 and y% < mapsizey then
                            
                                mpos% = map(x% + (y% shl 7))
                
                                if mpos% < 0 then
                                        
                                    i% = -(mpos% + 1)
                                    
                                    x# = x%
                                    y# = y%
                                    
                                    if blockInBlock ( x#, y#, 1.0, sx - sprites(j%).collisionradius, sy - sprites(j%).collisionradius, sprites(j%).collisionradius*2 ) then
                                        
                                        if doors(i%).amtopen < 48 then doors(i%).amtopen = 48
                                        
                                    end if
                                        
                                end if
                                
                            end if
                                
                        next y%
                        
                    end if
                    
                next x%
                    
            end if
            
        next j%

    end sub
    
    defdbl a-z
    function addsprite ( x as double, y as double, _
                         image as integer ) as integer
        
        for i% = 1 to maxsprites-1
            
            if sprites(i%).inuse = 0 then
                
                sprites(i%).inuse = 1
                sprites(i%).x = x
                sprites(i%).y = y
                sprites(i%).z = 0
                sprites(i%).sprite = image
                addsprite = i%
                exit for
                
            end if
            
        next i%
        
    end function
    
    defdbl a-z
    function inDBlock ( x as double, y as double, size as double ) as integer
        
        for i% = 0 to maxdblocks-1
            
            if dblocks(i%).inuse then
                
                dx = dblocks(i%).x
                dy = dblocks(i%).y
                
                if blockInBlock ( dx, dy, 1.0, x-size, y-size, size*2 ) then
                    
                    return i%+1
                    
                end if
                
            end if
            
        next i%
        
    end function

    defdbl a-z
    function blockInBlock ( byval x1 as double, byval y1 as double, _
                            byval size1 as double, _
                            byval x2 as double, byval y2 as double, _
                            byval size2 as double ) as integer
                            
        if size1 < size2 then
            
            xa = x1         : ya = y1
            xb = x1 + size1 : yb = y1
            xc = x1         : yc = y1 + size1
            xd = x1 + size1 : yd = y1 + size1
            
            tx1 = x2            : ty1 = y2
            tx2 = x2 + size2    : ty2 = y2 + size2
            
        else

            xa = x2         : ya = y2
            xb = x2 + size2 : yb = y2
            xc = x2         : yc = y2 + size2
            xd = x2 + size2 : yd = y2 + size2
            
            tx1 = x1            : ty1 = y1
            tx2 = x1 + size1    : ty2 = y1 + size1

        end if
        
        if ((xa >= tx1) and (xa <= tx2) and (ya >= ty1) and (ya <= ty2)) or _
           ((xb >= tx1) and (xb <= tx2) and (yb >= ty1) and (yb <= ty2)) or _
           ((xc >= tx1) and (xc <= tx2) and (yc >= ty1) and (yc <= ty2)) or _
           ((xd >= tx1) and (xd <= tx2) and (yd >= ty1) and (yd <= ty2)) then
           
            return 1
            
        else
            
            return 0
            
        end if
        
    end function
    
    defdbl a-z
    sub loadConfiguration ( )
        
        f = freefile
        open "config.ini" for input as #f
        
            input #f, fps, mousesensitivity, hires
        
        close #f
   
        movespeed = 2/fps ' 2 blocks/second
        doorspeed = 64/(fps*2) ' open or close in two seconds
   
    end sub
    
    sub trace ( msg$ )
        
        f = freefile
        open "log.txt" for append as #f
        
            print #f, msg$
        
        close #f
        
    end sub
    