'=============================================================================
'                           RAYCASTING TUTORIAL #1
'                                By Joe King
'
'                        Getting the idea of raycasting
'=============================================================================

'What is raycasting?
'   Raycasting if converting a map grid to a 3d image by casting out rays from
' your position on the map grid.  Why do we need to cast out rays?  We all
' have a field of vision(F.O.V.), this is the range of what we can see.  There
' are 360 degrees in a circle.  We don't have a 360 F.O.V. because we can't
' see all the way around us.  Our F.O.V. is less than 180.  We need to choose
' our F.O.V. for our 3d image we are going to put on the screen of what we can
' see.  Lots of people use 60 degrees for their F.O.V., so we will use it too.
'   We will cast out a ray for each degree of our F.O.V. and we want keep on
' casting the ray until it hits a wall.  Then we want to put a vertical strip
' on the screen according to where the wall is, and how far away the wall is.
'   You can run this program and you'll get a good idea of how this works.
' It starts by cating out a ray, adding the distance as it goes until it
' hits a wall.  If the wall is far away, we draw a small strip, if it's close
' we draw a large strip.  We calculate this distance by 200/distance.  If you
' increase the 200 or decrease the 200, the walls will get bigger or smaller.
' 200 works fine for this example.  And we keep on casting out all of our rays
' until we covered our F.O.V.
'   Once you got the idea of how this works, move on to the next tutorial.


'***** The code to this program *****
'You don't need to know how this works at all.

  DIM SinTable(359) AS SINGLE
  DIM CosTable(359) AS SINGLE
  DIM Map%(10, 10)

  CONST PI = 22 / 7

FOR z% = 0 TO 359
  SinTable(z%) = SIN(z% * PI / 180)
  CosTable(z%) = COS(z% * PI / 180)
NEXT z%

SCREEN 13

COLOR 7
FOR y% = 1 TO 10
FOR x% = 1 TO 10
  READ Map%(x%, y%)
  IF Map%(x%, y%) = 2 THEN Map%(x%, y%) = 0: px% = x%: py% = y%
  IF Map%(x%, y%) = 1 THEN LOCATE y%, x%: PRINT ""
NEXT x%
NEXT y%

COLOR 15
LOCATE py%, px%: PRINT CHR$(1)

LOCATE 11, 1
PRINT "MAP GRID"
LOCATE 10, 23
PRINT "3D IMAGE"

LOCATE 22, 1
COLOR 14
PRINT "PRESS ANY KEY TO START"
SLEEP
LOCATE 22, 1
PRINT "                      "

s% = 175
FOR z% = 30 TO -30 STEP -1
s% = s% + 1
a% = z%
IF a% < 0 THEN a% = a% + 360
IF a% > 359 THEN a% = a% - 360
xx! = px% * 8 - 4
yy! = py% * 8 - 10
dd% = 0

LOCATE 19, 1
PRINT "CASTING OUT RAY"
COLOR 15

DO
PSET (xx!, yy!), 15
xx! = xx! - SinTable(a%)
yy! = yy! - CosTable(a%)
dd% = dd% + 1
LOCATE 20, 1
PRINT "ADDING DISTANCE "; dd%
LOOP UNTIL Map%(xx! / 7, yy! / 7)

LOCATE 21, 1
PRINT "DISTANCE TO WALL=200/"; dd%; "  WHICH IS"; INT(200 / dd%)
SLEEP
LOCATE 21, 1
PRINT "                                                "

ds% = 200 / dd%

LINE (s%, 50 - ds%)-(s%, 50 + ds%), 15

DO
LOOP UNTIL INKEY$ = ""

NEXT z%

DATA 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
DATA 1, 0, 0, 0, 0, 0, 0, 0, 0, 1
DATA 1, 0, 1, 0, 1, 1, 1, 0, 0, 1
DATA 1, 1, 1, 0, 0, 0, 1, 0, 0, 1
DATA 1, 0, 0, 0, 0, 0, 1, 0, 0, 1
DATA 1, 0, 0, 0, 0, 0, 0, 0, 0, 1
DATA 1, 0, 0, 2, 0, 0, 0, 0, 0, 1
DATA 1, 0, 0, 0, 0, 1, 1, 1, 0, 1
DATA 1, 0, 0, 0, 0, 1, 0, 0, 0, 1
DATA 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

