'=============================================================================
'                           RAYCASTING TUTORIAL #2
'                                By Joe King
'
'                             Explaining slopes
'=============================================================================

'  Now since you've got the idea of raycasting from tutorial 1, or you already
' know the idea, let's get to know how more of this stuff works.

'  When we are casting out a ray, it's like we can move to the left a certain
' number and move up a certain number and we will be on the ray.

'        /
'      /
'    /
'  /
'/ 

'   As you see in that picture above, you can be on the line by moving to the
' right 2 '' and moving up 1 '' and you'll still be with the line.  This
' is what we are going to do when we cast out our rays.  The part of the line
' where you can move to the left or right a certain number, and up or down a
' certain number is called the slope of the line.  The slope of a line is
' defined by it's rise/run, so the slope of the line above is 1/2.

'    /
'   /
'  /
' /
'/

'   Guess what the slope of the line above is.  Bring you cursor up to the
' bottom of the line and move to the right 1 and up 1.  You'll be on that line
' as you move to the right 1 and up 1.  So the slope of that line is 1/1,
' this is how we are going to cast out our rays, by using it's slope to move
' to the left or right a certain number, and up or down a certain number on
' the map grid.  So we need to find the slope of a line of a certain angle
' that we are going to cast out.  But how do we do that, there's a formula for
' finding the slope of your lines.  To find the rise of your line is
' COS('angle'* Pi/180),and to find the run is SIN('angle'* Pi/180).
' Where 'angle' is the angle you be casting out your line.  When you run this
' program, it will form a circle out of lines.  We calculate the rise and run
' of the line from the angle we are casting out our line at.

'***** The code *****
'***** Read through this to see how it works *****

  DIM SinTable(359) AS SINGLE   '***** Our tables for storing our slopes, they
  DIM CosTable(359) AS SINGLE   '***** only go to 359 because 0 = 360.
                                '***** They are single precision variables,
                                '***** because the slopes are decimal numbers.

  CONST PI = 22 / 7   '***** Remember that Pi is 3.14159 or 22/7

FOR z% = 0 TO 359                       '***** Here, we make a FOR...NEXT loop
  SinTable(z%) = SIN(z% * PI / 180)     '***** so we can construct our Sine and
  CosTable(z%) = COS(z% * PI / 180)     '***** Cosine tables for storing our
NEXT z%                                 '***** slopes in.

SCREEN 13     '***** Put it into graphics mode to draw the lines.

'***** Do another FOR...NEXT loop from 0 to 359 to draw our lines.
'***** Draws from the middle of the screen to a specific point by adding the
'***** x-axis by the run, and the y-axis by the rise, then it times by 50 so
'***** you can see the line.  If you take away the * 50, the circle will be
'***** really small.
FOR z% = 0 TO 359
  LINE (160, 100)-(160 + SinTable(z%) * 50, 100 + CosTable(z%) * 50), 15
NEXT z%

'***** End of code *****

'   If you got what I'm trying to tell you in this tutorial, let's move on to
' the next one.

