'=============================================================================
'                           RAYCASTING TUTORIAL #5
'                                By Joe King
'
'                              A finer raycaster
'=============================================================================

'   This one will cast out 320 rays for 64 F.O.V.  So, instead of casting out
' 64 rays, we will cast out 64*5(to make the width of one stip 1 pixel) or
' 320.  If we times one thing by 5, we times everything by 5(this is exactly
' how I thought of it).  You'll see everything times by 5.

'***** The code *****
'=============================================================================

  '***** 359*5 = 1795
  DIM SinTable(1795) AS INTEGER    '***** The run table for the slope.
  DIM CosTable(1799) AS INTEGER    '***** The rise table for the slope.
                                  '***** Make them integers to add faster.

  CONST PI = 22 / 7               '***** The Pi constant 3.14159 or 22/7

  DIM Map%(10, 10)                '***** Our map grid we are going to use.

'***** Calculate our slope tables.  Sine is the run of the slope, and cosine
'***** is the run of the slopes.  Then times them by 100, so when they round
'***** off, they don't all = 1 or 0.
FOR z% = 0 TO 1795  '***** 359 * 5 = 1795
  SinTable(z%) = SIN(z% * PI / 900) * 100   '***** 900 is 180 * 5
  CosTable(z%) = COS(z% * PI / 900) * 100
NEXT z%

'***** Read the map data, and put it into the Map% array
'***** If the part of the map equals 2 then get the player's coordinates and
'***** make the part of the map equal 0(nothing).
FOR y% = 1 TO 10
FOR x% = 1 TO 10
  READ Map%(x%, y%)
    IF Map%(x%, y%) = 2 THEN
      Map%(x%, y%) = 0
      px% = x%: py% = y%
    END IF
NEXT x%
NEXT y%

'***** Times the player's coordinates by 100 for purposes explained in
'***** tutorial #3
px% = px% * 1000
py% = py% * 1000


  SCREEN 13               '***** Put it into graphics mode so we can draw
                          '***** lines.

  Angle% = 0              '***** The angle you are facing at.

  SkyColor% = 9           '***** The color of the sky.
  WallColor% = 15         '***** The color of the walls.
  FloorColor% = 2         '***** The color of the floor.

  DO

  GOSUB Raycast           '***** Gosub the raycasting routine.

  DO                      '***** This makes a DO...LOOP, and waits for a key
    a$ = INKEY$           '***** to be pressed.
  LOOP UNTIL a$ <> ""

  '***** If you press '' then move up.  Do this by subtracting your x and y
  '***** position by the run and rise of your angle.
  IF a$ = CHR$(0) + "H" THEN px% = px% - SinTable(Angle%) * 5: py% = py% - CosTable(Angle%) * 5
  '***** If you press '' then move down.  Do this by adding your x and y
  '***** position by the run and rise of your angle.
  IF a$ = CHR$(0) + "P" THEN px% = px% + SinTable(Angle%) * 5: py% = py% + CosTable(Angle%) * 5

  '***** 5 * 5 = 25
  IF a$ = CHR$(0) + "M" THEN Angle% = Angle% + 25 '***** Add the angle or
  IF a$ = CHR$(0) + "K" THEN Angle% = Angle% - 25 '***** subtract it by which
                                                  '***** key you pressed

  IF a$ = CHR$(27) THEN END   '***** End the program if you pressed 'Esc'

  '***** Make sure that your angle dosen't go below 0 or above 359
  IF Angle% < 0 THEN Angle% = Angle% + 1800     '***** 360*5 = 1800
  IF Angle% > 1795 THEN Angle% = Angle% - 1800  '***** 359*5 = 1795

  LOOP  '***** Loop back to the start



'***** The raycasting routine *****
Raycast:

s% = -1     '***** Make it -1 since the width of 1 strip is 1 pixel.

'***** Start of FOR...NEXT loop for casting out rays for our F.O.V.
'***** We will cast out 30 degrees to the left and 30 degrees to the right,
'***** but remember we need a 64 F.O.V. to cover the entire screen, so we will
'***** cast out 31 degrees to the left and 32 degrees to the right(your
'***** probaly thinking that 31+32=63, not 64, we include angle 0 for casting
'***** out a ray also).
FOR z% = -160 TO 160    '***** 31 * 5 is 155 and 32 * 5 is 160, added up is
                        '***** 315, so we will make 155 = 160 so we get 320
                        '*****rays you will cast out

s% = s% + 1   '***** Add the spot where we are going to draw our vertical
              '***** strip.

a% = Angle% + z%  '***** The angle that we are going to cast out our ray. It's
                  '***** the angle your facing at plus the angle for out
                  '***** F.O.V.

IF a% < 0 THEN a% = a% + 1795     '***** 360*5 = 1800,make it 1795 so it dosen't error out
IF a% > 1795 THEN a% = a% - 1795  '***** 359*5 = 1795
                                
xx% = px%: yy% = py%  '***** Make the coordinates that we will add our slopes
                      '***** by for our ray so we don't change the player's
                      '***** coordinates.

dd% = 0   '***** This is the distance counter, make it 0 to start counting
          '***** when you cast out your ray.

'***** This is where we cast out our ray.  We add yy% by the rise, and xx%
'***** by then run.  But I subtract it so that angle 0 is infront of you.
DO
  xx% = xx% - SinTable(a%)
  yy% = yy% - CosTable(a%)
  m% = Map%(xx% \ 1000, yy% \ 1000) '***** Make m% = Map(RAYX/100,RAYY/100) to
                                  '***** check if you hit a wall on the map
                                  '***** grid.  I use '\' instead if '/',
                                  '***** because '\' divides faster.
  dd% = dd% + 1 '***** Count the distance up to count how far the ray goes
LOOP UNTIL m%   '***** Loop until m% is true(until m%<>0)

ds% = 1000 / dd%    '***** Makes ds%(distance) 1000/dd%, so if the distance
                    '***** is far, we make it small, and if it's close, make
                    '***** it big. Example/ dd% = 50, ds% = 1000/50, ds% = 20
                    '***** 1000/dd% works fine, you could change the 1000 and
                    '***** see what happens.

'***** We want to draw from to top down to the top of the wall, if you take
'***** this line out, you'll get a blurry effect.
LINE (s%, 0)-(s%, 99 - ds%), SkyColor%, BF
'***** We draw from the center up to the center down to draw our wall.  And
'***** go from s% to s% which is 1 pixels for a vertical strip of the wall.
LINE (s%, 100 - ds%)-(s%, 100 + ds%), WallColor%, BF
'***** Now we want to draw from the bottom of the wall down to the bottom of
'***** the screen.
LINE (s%, 101 + ds%)-(s%, 199), FloorColor%, BF


NEXT z%

RETURN


'***** This is the data for the map that we read and put it into the Map%
'***** array.

DATA 1,1,1,1,1,1,1,1,1,1
DATA 1,0,0,0,0,0,0,0,0,1
DATA 1,0,0,1,0,1,1,1,0,1
DATA 1,1,1,1,0,0,0,1,0,1
DATA 1,0,0,0,0,0,0,1,0,1
DATA 1,0,0,0,0,2,0,0,0,1
DATA 1,1,1,1,0,1,0,0,0,1
DATA 1,0,0,0,0,1,0,1,0,1
DATA 1,0,1,1,1,1,0,0,0,1
DATA 1,1,1,1,1,1,1,1,1,1

'***** End of code *****
'=============================================================================

'   It's still just about as choopy as the one on tutorial #4.  Try timesing
' the rise and run tables by 50 instead of ten, so it loops around more times
' while it's casting out a ray.  And make ds% = 1000/dd% to ds% = 1500/dd% so
' the walls don't look far away, this will make the raycaster not as choppy,
' but longer to take.


