'*************************************************
'raytut.bas version 1.0  
'     Edited and explained by Dieter Marfurt.
'*************************************************
'Some of you asked me for a Raycasting Tutorial after the Release of
'my Wolfenstein-Type QB-Game "KABOOM". I wrote then a simple Raycaster
'based on "Doom.bas, Raycasterdemo". I removed all unnecessary code.
'First I try to explain the RAYCASTING-method.
'
'Take a Paper and cut 320 fine parallel lines into it. (just imagine...)
'Now close one eye and watch the Enviroment trough the Paper.
'Actually you don't see Objects anymore. Now you see only Lines.
'If you could visualize the Connections of the objects behind the Paper
'trough the Paper to your eye, then your eye would look like a Star, sending
'out rays. Imagine these weren'nt ordinary rays but each one was a
'Laser-Distance-Computer. Depending on the Distance from the "eye"
'to a reflecting Object we could then draw the lines as we have seen it
'trough the paper. It is like Ultra-Waves from Vampires or like Radar - used
'to assemble a Picture even in the darkest night...
'So we send out 320 Rays and then we draw what each Ray was reflecting.
'
'Important:
'Raycasting is NOT an OBJECT-ORIENTED render-method. It is PIXEL-ORIENTED!
'Ok, here we go...
'
SCREEN 13
DIM Grid%(13, 13) ' the Level-Grid
REDIM SHARED STable!(-192 TO 1992), CTable!(-192 TO 1992)
                  ' sin/cos tables for movement and raycaster

REDIM SHARED iSTable%(-192 TO 1992), iCTable%(-192 TO 1992)
                  ' Int-Tables wich will hold the  Float-Tables multiplied
                  ' with 10000.
                  ' (I recommend not to use Floating Point in a Realtime
                  ' Renderer.)

PX& = 95000: PY& = 110000    ' starting coordinates of camera
Stride2% = 3      ' stepwidth-parameter camera (or player)
Heading% = 1780   ' initial heading of the camera (in degrees*5)
Turn% = 30        ' number of degrees of rotation produced by the user
 
FOR Y% = 1 TO 12
  FOR X% = 1 TO 12
    READ Grid%(X%, Y%)   'read level-map
  NEXT
NEXT

Factor! = (ATN(1) * 8) / 1800
FOR a% = 0 TO 1799
  Angle! = CSNG(a%) * Factor!         'define sin/cos-tables
  STable!(a%) = SIN(Angle!) * .1
  CTable!(a%) = COS(Angle!) * .1
                                      'unREM the following 3 lines if you
                                      'don't understand it...
  'LINE (160, 100)-(160 + (STable!(a%) * 500), 100 + (CTable!(a%) * 500)), 15
  'LOCATE 1, 1: PRINT "STable!("; a%; "): "; STable!(a%); "  "
  'PRINT "CTable!("; a%; "): "; CTable!(a%); "  ": PALETTE 0, 0'slow down demonstration.
NEXT
FOR a% = 1800 TO 1800 + 192           'rotation-exeption-patches...
  STable!(a%) = STable!(a% - 1800)    '(used if Heading% is < 160 or > 1740)
  CTable!(a%) = CTable!(a% - 1800)
NEXT
FOR a% = 0 TO -192 STEP -1
  STable!(a%) = STable!(a% + 1800)
  CTable!(a%) = CTable!(a% + 1800)
NEXT
FOR a% = -192 TO 1992                 'important: shift to integer
  iSTable%(a%) = STable!(a%) * 10000  '(The raycaster will use only int.
  iCTable%(a%) = CTable!(a%) * 10000  'Everything but the Grid is multiplied
NEXT a%                               'by 10000.)
REDIM SHARED STable!(0), CTable!(0)   'not used anymore

GOSUB ComputeView                     'A first Picture pleaze...

DO '...................................!!!!  Main loop !!!!
 aa% = INP(&H60)
 a$ = INKEY$
 IF aa% <> 0 THEN
  IF aa% = 75 THEN                    'turn left
    Heading% = (Heading% + Turn%) MOD 1800
    GOSUB ComputeView
  END IF
  IF aa% = 77 THEN                    'turn right
    Heading% = (Heading% + (1800 - Turn%)) MOD 1800
    GOSUB ComputeView
  END IF
  IF aa% = 72 THEN                    'walk forward
    NewPX& = PX& - (iSTable%(Heading%) * Stride2%)
    NewPY& = PY& - (iCTable%(Heading%) * Stride2%)
    IF Grid%(NewPX& \ 10000, NewPY& \ 10000) = 0 THEN
      PX& = NewPX&: PY& = NewPY&
      GOSUB ComputeView
    ELSE 'tried to walk through a wall
      SOUND 80, 1
    END IF
  END IF
  IF aa% = 80 THEN                    'walk back
    NewPX& = PX& + (iSTable%(Heading%) * Stride2%)
    NewPY& = PY& + (iCTable%(Heading%) * Stride2%)
    IF Grid%(NewPX& \ 10000, NewPY& \ 10000) = 0 THEN
      PX& = NewPX&: PY& = NewPY&
      GOSUB ComputeView
    ELSE 'tried to walk through a wall
      SOUND 80, 1
    END IF
  END IF
 END IF
LOOP UNTIL a$ = CHR$(27)
END '....................................eo mainloop

ComputeView:
x1% = 0       ' set initial pixelcolumn
 
FOR a% = Heading% + 160 TO Heading% - 159 STEP -1
              ' (320 rays will be sent in 320 directions taken from
              ' a table with 1800 "Degrees". (means u see about 18 % of
              ' the whole panorama)
              ' don't worry about negative counting - it draws from
              ' left to right anyway...
  XX& = PX&: YY& = PY&
              ' initialize raycaster at cameraposition (for each column)

  L% = 0      ' initialize distance-counter L% (for each column)
 
  stepx% = iSTable%(a%) \ 5: stepy% = iCTable%(a%) \ 5
              ' set x- and y- raycast-movement-values
              ' (taken from the sin/cos-tables mentioned above)

  '***************************************************************************
  DO          '4,3,2,1,lift off!!!  This loop IS the raycaster.
    XX& = XX& - stepx%: YY& = YY& - stepy%
             ' like a Sun we send out our ray now...
    L% = L% + 2
             '...while we are counting the steps; independent from direction...
    xg% = XX& \ 10000  '(checkin out the map-index k% under the curr.ray-pos.)
    yg% = YY& \ 10000
    k% = Grid%(xg%, yg%)
  LOOP UNTIL k%        '(only exit when the ray reached a wall (k% is <> 0))
  '***************************************************************************
             ' and when the ray finaly shines onto any Block of the Maze...
  DD% = 9000 \ L%
             ' ...we use _DISTANCE_ L% to define the Height of the visible
             ' Part of the Block.
             ' Example:  DD%=9000\1000 (far, height is 9)
             ' Example:  DD%=9000\20 (near, height is 450)
  roof% = 100 - DD%
  floor% = 100 + DD%
  LINE (x1%, roof%)-(x1%, floor%), k%, B
             ' draw the visible part of the block
  LINE (x1%, 0)-(x1%, roof%), 0, B
  LINE (x1%, floor%)-(x1%, 199), 0, B
             ' and paint floor and top black.
  x1% = x1% + 1
             ' finaly add 1 to x1% wich is the current pixelcolumn
NEXT a%
RETURN       ' that's all !!!

'bye the way: you can make it run faster if u use some tricks and tables.
'check out kaboom.zip on files-section of www.qb45.com (also for textures)
'and last but not least: try qmanche, the 3D-helicopter-simulation.
'Both Games are based on this Method.
'Think about to multiply with &hffff instead of 10000 - It could then
'be divided simply and fast by peeking the upper significant two bytes
'of the Longs...(but I guess it must be unsigned - we'll see)
'
'Have Funnn! Dieter (dietermarfurt@angelfire.com)
'
' Level data for Grid%(,)
DATA  9,  1,  9,  1,  9,  1,  9,  1,  9,  1,  9,  1
DATA  1,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  9
DATA  9,  0,  2, 10,  0,  0,  0,  0,  0, 12,  0,  1
DATA  1,  0, 10,  2,  0,  0,  0,  0,  0,  4,  0,  9
DATA  9,  0,  0,  0,  0,  0,  0,  0,  0, 12,  0,  1
DATA  1,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  9
DATA  9,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  1
DATA  1,  0, 13,  0,  0,  0,  0,  8,  0, 12,  0,  9
DATA  9,  0,  5,  0,  0,  0,  0,  7,  0,  4,  0,  1
DATA  1,  0, 13,  0,  0,  0,  0,  8,  0, 12,  0,  9
DATA  9,  0,  5,  0,  0,  0,  0,  7,  0,  4,  0,  1
DATA  1,  9,  1,  9,  1,  9,  1,  9,  1,  9,  1,  9

